/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.collections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface ImmutableLinkedList<T>
extends Iterable<T> {
    public boolean isEmpty();

    public T getValue();

    public ImmutableLinkedList<T> getTail();

    public ImmutableLinkedList<T> add(T var1);

    public int size();

    public List<T> toList();

    public Stream<T> stream();

    public static <A> ImmutableLinkedList<A> cons(A a, ImmutableLinkedList<A> tail) {
        return new Cons<A>(a, tail);
    }

    public static <A> ImmutableLinkedList<A> cons(A a) {
        return new Cons<A>(a, new Nil());
    }

    public static <A> ImmutableLinkedList<A> empty() {
        return new Nil();
    }

    public static class Cons<A>
    implements ImmutableLinkedList<A> {
        private final A value;
        private final ImmutableLinkedList<A> tail;

        public Cons(A value, ImmutableLinkedList<A> tail) {
            this.value = value;
            this.tail = tail;
        }

        @Override
        public A getValue() {
            return this.value;
        }

        @Override
        public ImmutableLinkedList<A> getTail() {
            return this.tail;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public ImmutableLinkedList<A> add(A a) {
            return ImmutableLinkedList.cons(a, this);
        }

        @Override
        public int size() {
            return (int)this.stream().count();
        }

        @Override
        public List<A> toList() {
            ArrayList list = new ArrayList();
            this.stream().forEach(list::add);
            Collections.reverse(list);
            return list;
        }

        @Override
        public Stream<A> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        @Override
        public Iterator<A> iterator() {
            return new Iterator<A>(){
                private ImmutableLinkedList<A> current;
                {
                    this.current = this;
                }

                @Override
                public boolean hasNext() {
                    return !(this.current instanceof Nil);
                }

                @Override
                public A next() {
                    if (this.current instanceof Nil) {
                        throw new IllegalStateException("Empty list does not have next.");
                    }
                    Object nextValue = ((Cons)this.current).getValue();
                    this.current = ((Cons)this.current).tail;
                    return nextValue;
                }
            };
        }

        public String toString() {
            return String.format("[%sNIL]", this.toStringRec("", this));
        }

        private String toStringRec(String acc, ImmutableLinkedList<A> list) {
            if (list instanceof Nil) {
                return acc;
            }
            return this.toStringRec(String.format("%s%s, ", acc, ((Cons)list).getValue()), ((Cons)list).tail);
        }
    }

    public static class Nil<R>
    implements ImmutableLinkedList<R> {
        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public R getValue() {
            throw new IllegalStateException("Does not have value.");
        }

        @Override
        public ImmutableLinkedList<R> getTail() {
            throw new IllegalStateException("Does not have tail.");
        }

        @Override
        public ImmutableLinkedList<R> add(R r) {
            return ImmutableLinkedList.cons(r, this);
        }

        @Override
        public int size() {
            return (int)this.stream().count();
        }

        @Override
        public List<R> toList() {
            return new ArrayList();
        }

        @Override
        public Stream<R> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        @Override
        public Iterator<R> iterator() {
            return new Iterator<R>(this){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public R next() {
                    throw new IllegalStateException("Empty list does not have next.");
                }
            };
        }

        public String toString() {
            return "[NIL]";
        }
    }
}

