/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.util;

import com.t4login.datetime.NDateTime;
import com.t4login.datetime.NTimeSpan;

public final class GraphicsUtil {
    private GraphicsUtil() {
    }

    public static final boolean getDoColorsContrast(int backColor, int foreColor) {
        double aBg = 1.0 - (0.299 * (double)GraphicsUtil.getRed(backColor) + 0.587 * (double)GraphicsUtil.getGreen(backColor) + 0.114 * (double)GraphicsUtil.getBlue(backColor)) / 255.0;
        double aFg = 1.0 - (0.299 * (double)GraphicsUtil.getRed(foreColor) + 0.587 * (double)GraphicsUtil.getGreen(foreColor) + 0.114 * (double)GraphicsUtil.getBlue(foreColor)) / 255.0;
        return !(aBg < 0.5 && aFg < 0.5) && (!(aBg > 0.5) || !(aFg > 0.5));
    }

    public static final int getContrastingTextColor(int backColor) {
        double a = 1.0 - (0.299 * (double)GraphicsUtil.getRed(backColor) + 0.587 * (double)GraphicsUtil.getGreen(backColor) + 0.114 * (double)GraphicsUtil.getBlue(backColor)) / 255.0;
        if (a < 0.5) {
            return GraphicsUtil.colorFromRGB(0, 0, 0);
        }
        return GraphicsUtil.colorFromRGB(255, 255, 255);
    }

    public static final int getHighlightColor(int color, float percent) {
        double a = 1.0 - (0.299 * (double)GraphicsUtil.getRed(color) + 0.587 * (double)GraphicsUtil.getGreen(color) + 0.114 * (double)GraphicsUtil.getBlue(color)) / 255.0;
        if (a > 0.5) {
            return GraphicsUtil.shadeColor(color, percent);
        }
        return GraphicsUtil.shadeColor(color, -1.0f * percent);
    }

    public static final int shadeColor(int color, float percent) {
        int r = GraphicsUtil.getRed(color);
        int g = GraphicsUtil.getGreen(color);
        int b = GraphicsUtil.getBlue(color);
        int a = GraphicsUtil.getAlpha(color);
        float P = percent < 0.0f ? 1.0f + percent : 1.0f - percent;
        float t = percent < 0.0f ? 0.0f : 255.0f * percent;
        r = Math.round((float)r * P + t);
        g = Math.round((float)g * P + t);
        b = Math.round((float)b * P + t);
        return GraphicsUtil.colorFromARGB(a, r, g, b);
    }

    public static final int getContrastedColor(int color, float amount) {
        double a = 1.0 - (0.299 * (double)GraphicsUtil.getRed(color) + 0.587 * (double)GraphicsUtil.getGreen(color) + 0.114 * (double)GraphicsUtil.getBlue(color)) / 255.0;
        int adj = (int)(255.0f * amount / 100.0f);
        if (a < 0.5) {
            int r = GraphicsUtil.getRed(color) - adj;
            int g = GraphicsUtil.getGreen(color) - adj;
            int b = GraphicsUtil.getBlue(color) - adj;
            return GraphicsUtil.colorFromRGB(Math.min(255, Math.max(0, r)), Math.min(255, Math.max(0, g)), Math.min(255, Math.max(0, b)));
        }
        int r = GraphicsUtil.getRed(color) + adj;
        int g = GraphicsUtil.getGreen(color) + adj;
        int b = GraphicsUtil.getBlue(color) + adj;
        return GraphicsUtil.colorFromRGB(Math.min(255, Math.max(0, r)), Math.min(255, Math.max(0, g)), Math.min(255, Math.max(0, b)));
    }

    public static final int getFadedColor(int colorStart, int colorEnd, NDateTime dtStart, NDateTime dtEnd, int fadeMinutes) {
        float A = GraphicsUtil.getAlpha(colorStart);
        float R = GraphicsUtil.getRed(colorStart);
        float G = GraphicsUtil.getGreen(colorStart);
        float B = GraphicsUtil.getBlue(colorStart);
        float A2 = GraphicsUtil.getAlpha(colorEnd);
        float R2 = GraphicsUtil.getRed(colorEnd);
        float G2 = GraphicsUtil.getGreen(colorEnd);
        float B2 = GraphicsUtil.getBlue(colorEnd);
        NTimeSpan duration = dtEnd.Subtract(dtStart);
        double deltaMins = Math.max(0.0, Math.min(duration.getTotalMinutes(), (double)fadeMinutes));
        float ratio = (float)deltaMins / (float)fadeMinutes;
        int a = (int)Math.max(0.0f, Math.min(255.0f, A + (A2 - A) * ratio));
        int r = (int)Math.max(0.0f, Math.min(255.0f, R + (R2 - R) * ratio));
        int g = (int)Math.max(0.0f, Math.min(255.0f, G + (G2 - G) * ratio));
        int b = (int)Math.max(0.0f, Math.min(255.0f, B + (B2 - B) * ratio));
        int faded = GraphicsUtil.colorFromARGB(a, r, g, b);
        return faded;
    }

    public static int lightenColor(int color, int amount) {
        int ir = Math.min(255, GraphicsUtil.getRed(color) + amount);
        int ig = Math.min(255, GraphicsUtil.getGreen(color) + amount);
        int ib = Math.min(255, GraphicsUtil.getBlue(color) + amount);
        int ia = GraphicsUtil.getAlpha(color);
        return GraphicsUtil.colorFromARGB(ia, ir, ig, ib);
    }

    public static final int getAlpha(int color) {
        return (color & 0xFF000000) >>> 24;
    }

    public static final int getRed(int color) {
        return (color & 0xFF0000) >> 16;
    }

    public static final int getGreen(int color) {
        return (color & 0xFF00) >> 8;
    }

    public static final int getBlue(int color) {
        return color & 0xFF;
    }

    public static final int colorFromARGB(int a, int r, int g, int b) {
        return (0xFF & a) << 24 | (0xFF & r) << 16 | (0xFF & g) << 8 | 0xFF & b;
    }

    public static final int colorFromRGB(int r, int g, int b) {
        return 0xFF000000 | (0xFF & r) << 16 | (0xFF & g) << 8 | 0xFF & b;
    }
}

