/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.sparkline;

import com.t4login.application.sparkline.ISparklineTimeScale;
import com.t4login.application.sparkline.SparklineChartData;
import com.t4login.application.sparkline.SparklineDataPoint;
import com.t4login.collections.TreeSet;
import com.t4login.datetime.NDateTime;
import com.t4login.util.Range;

public class SparklineTimeScaleAlt
implements ISparklineTimeScale {
    private static final String TAG = "SparklineTimeScaleAlt";
    public static final SparklineTimeScaleAlt Empty = new SparklineTimeScaleAlt();
    private final Range<Float> PlotRange;
    private final TreeSet<NDateTime> TimePoints;

    private SparklineTimeScaleAlt() {
        this.PlotRange = Range.empty();
        this.TimePoints = new TreeSet();
    }

    public SparklineTimeScaleAlt(SparklineChartData data, Range<Float> plotRange) {
        this.PlotRange = plotRange;
        this.TimePoints = new TreeSet();
        for (SparklineDataPoint pt : data.Points) {
            this.TimePoints.add(pt.Time);
        }
    }

    @Override
    public Float getPositionOf(NDateTime time) {
        int index;
        int totalPoints = this.TimePoints.size();
        if (!this.PlotRange.isEmpty() && totalPoints > 1 && (index = this.TimePoints.indexOf(time)) > 0) {
            float incr = (this.PlotRange.end().floatValue() - this.PlotRange.start().floatValue()) / ((float)totalPoints - 1.0f);
            return Float.valueOf((float)index * incr + this.PlotRange.start().floatValue());
        }
        return null;
    }
}

