/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.sparkline;

import com.t4login.application.sparkline.ISparklineTimeScale;
import com.t4login.datetime.NDateTime;
import com.t4login.util.Range;
import com.t4login.util.TimeRange;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SparklineTimeScale
implements ISparklineTimeScale {
    private static final String TAG = "SparklinePathBuilder";
    public static final SparklineTimeScale Empty = new SparklineTimeScale();
    private final Range<Float> PlotRange;
    private final List<Session> Sessions;
    private final int TotalPoints;

    private SparklineTimeScale() {
        this.PlotRange = Range.empty();
        this.Sessions = new ArrayList<Session>();
        this.TotalPoints = 0;
    }

    public SparklineTimeScale(List<TimeRange> openTimes, Range<Float> plotRange) {
        this.PlotRange = plotRange;
        this.Sessions = openTimes.stream().map(Session::new).collect(Collectors.toList());
        this.TotalPoints = this.Sessions.stream().map(Session::getTotalPoints).reduce(0, Integer::sum);
    }

    @Override
    public Float getPositionOf(NDateTime time) {
        if (!this.PlotRange.isEmpty() && this.TotalPoints > 1) {
            Float incr = Float.valueOf((this.PlotRange.end().floatValue() - this.PlotRange.start().floatValue()) / ((float)this.TotalPoints - 1.0f));
            Float idx = this.indexOf(time);
            if (idx != null) {
                return Float.valueOf(idx.floatValue() * incr.floatValue() + this.PlotRange.start().floatValue());
            }
        }
        return null;
    }

    private Float indexOf(NDateTime time) {
        float passed = 0.0f;
        for (Session sess : this.Sessions) {
            Float idx = sess.indexOf(time);
            if (idx != null) {
                return Float.valueOf(idx.floatValue() + passed);
            }
            passed = sess.getTotalPoints();
        }
        return null;
    }

    private static class Session {
        public TimeRange SessionTimeRange;

        public Session(TimeRange timeRange) {
            this.SessionTimeRange = timeRange;
        }

        public int getTotalPoints() {
            return (int)(this.SessionTimeRange.end.Subtract(this.SessionTimeRange.start).getTotalMinutes() + 1.0);
        }

        public boolean contains(NDateTime time) {
            return this.SessionTimeRange.contains(time);
        }

        public Float indexOf(NDateTime time) {
            if (this.contains(time)) {
                double deltaMin = time.Subtract(this.SessionTimeRange.start).getTotalMinutes();
                return Float.valueOf((float)deltaMin);
            }
            return null;
        }
    }
}

