/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.sparkline;

import com.t4login.application.sparkline.ISparklineTimeScale;
import com.t4login.application.sparkline.SparklineChartData;
import com.t4login.application.sparkline.SparklineDataPoint;
import com.t4login.application.sparkline.SparklineTimeScale;
import com.t4login.datetime.NDateTime;
import com.t4login.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SparklinePathBuilder {
    private static final String TAG = "SparklinePathBuilder";
    public IPath SettlementPath;
    public IPath LinePath;
    public IPath GradientPath;
    private float boundsX;
    private float boundsY;
    private float boundsWidth;
    private float boundsHeight;
    private float marginTop;
    private float marginBottom;
    private float marginLeft;
    private float marginRight;
    private String description = "";
    private ISparklineTimeScale timeScale = SparklineTimeScale.Empty;

    public SparklinePathBuilder(IPath settlementPath, IPath linePath, IPath gradientPath) {
        this.SettlementPath = settlementPath;
        this.LinePath = linePath;
        this.GradientPath = gradientPath;
    }

    public SparklinePathBuilder setDescription(String descr) {
        this.description = descr;
        return this;
    }

    public SparklinePathBuilder setTimeScale(ISparklineTimeScale ts) {
        this.timeScale = ts;
        return this;
    }

    public SparklinePathBuilder setBounds(float x, float y, float w, float h) {
        this.boundsX = x;
        this.boundsY = y;
        this.boundsWidth = w;
        this.boundsHeight = h;
        return this;
    }

    public SparklinePathBuilder setMargin(float top, float bottom, float left, float right) {
        this.marginTop = top;
        this.marginBottom = bottom;
        this.marginLeft = left;
        this.marginRight = right;
        return this;
    }

    public void buildSparklinePath(SparklineChartData sparkChart) {
        ArrayList<Pair<Float, Object>> pathPoints;
        float vy;
        float vw = this.boundsWidth - this.marginLeft - this.marginRight;
        float vh = this.boundsHeight - this.marginTop - this.marginBottom;
        float vx = this.boundsX + this.marginLeft;
        float top = vy = this.boundsY + this.marginTop;
        float bottom = vy + vh;
        float left = vx;
        float right = vx + vw;
        float phTmp = 0.0f;
        int minPriceIncrTmp = 0;
        int maxPriceIncrTmp = 0;
        if (sparkChart.Points.size() > 0) {
            minPriceIncrTmp = sparkChart.Points.stream().min(Comparator.comparing(SparklineDataPoint::getPriceIncr)).get().getPriceIncr();
            maxPriceIncrTmp = sparkChart.Points.stream().max(Comparator.comparing(SparklineDataPoint::getPriceIncr)).get().getPriceIncr();
            if (sparkChart.Settlement != null && sparkChart.Settlement.PriceIncr != 0) {
                minPriceIncrTmp = Math.min(minPriceIncrTmp, sparkChart.Settlement.PriceIncr);
                maxPriceIncrTmp = Math.max(maxPriceIncrTmp, sparkChart.Settlement.PriceIncr);
            }
            phTmp = maxPriceIncrTmp - minPriceIncrTmp;
        }
        float ph = phTmp;
        int minPriceIncr = minPriceIncrTmp;
        int maxPriceIncr = maxPriceIncrTmp;
        Function<NDateTime, Float> getXPos = time -> this.timeScale.getPositionOf((NDateTime)time);
        Function<Integer, Float> getYPos = priceIncr -> Float.valueOf(vy + vh - vh / ph * (float)(priceIncr - minPriceIncr));
        this.SettlementPath.clear();
        this.LinePath.clear();
        if (this.GradientPath != null) {
            this.GradientPath.clear();
        }
        String settlTrace = "-";
        if (sparkChart.Settlement != null && sparkChart.Settlement.Time != NDateTime.MinValue) {
            settlTrace = String.format("%d", sparkChart.Settlement.PriceIncr);
            float yPos = getYPos.apply(sparkChart.Settlement.PriceIncr).floatValue();
            this.SettlementPath.moveTo(vx, yPos);
            this.SettlementPath.lineTo(vx + vw, yPos);
        }
        ArrayList<Pair<Float, Object>> tmpPoints = pathPoints = sparkChart.Points.stream().map(point -> new Pair<Float, Float>((Float)getXPos.apply(point.Time), (Float)getYPos.apply(point.PriceIncr))).filter(pr -> pr.first != null).map(pr -> new Pair<Float, Float>(Float.valueOf(Math.round(((Float)pr.first).floatValue())), Float.valueOf(Math.round(((Float)pr.second).floatValue())))).collect(Collectors.toCollection(ArrayList::new));
        pathPoints = new ArrayList<Pair<Float, Object>>();
        for (Pair pair : tmpPoints) {
            if (pathPoints.isEmpty()) {
                pathPoints.add(pair);
                continue;
            }
            if (Objects.equals(pair.first, ((Pair)pathPoints.get((int)(pathPoints.size() - 1))).first)) continue;
            pathPoints.add(pair);
        }
        if (sparkChart.Settlement != null && sparkChart.Settlement.Time != NDateTime.MinValue) {
            Float yPos = getYPos.apply(sparkChart.Settlement.PriceIncr);
            pathPoints.add(0, new Pair<Float, Object>(Float.valueOf(vx), yPos));
        }
        if (this.GradientPath != null) {
            this.GradientPath.moveTo(left, bottom);
        }
        for (Pair pair : pathPoints) {
            float x = ((Float)pair.first).floatValue();
            float y = ((Float)pair.second).floatValue();
            if (this.LinePath.getIsEmpty()) {
                this.LinePath.moveTo(x, y);
            } else {
                this.LinePath.lineTo(x, y);
            }
            if (this.GradientPath == null) continue;
            this.GradientPath.lineTo(x, y);
        }
        if (this.GradientPath != null && pathPoints.size() > 0) {
            this.GradientPath.lineTo(((Float)((Pair)pathPoints.get((int)(pathPoints.size() - 1))).first).floatValue(), bottom);
        }
        if (this.GradientPath != null) {
            this.GradientPath.close();
        }
        int nPoints = sparkChart.Points.size();
        int n = pathPoints.size();
    }

    static interface IPath {
        public void clear();

        public boolean getIsEmpty();

        public void moveTo(float var1, float var2);

        public void lineTo(float var1, float var2);

        public void close();
    }
}

