/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.settings;

import com.t4login.Resource;
import com.t4login.application.configuration.Category;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.EditorType;
import com.t4login.application.configuration.IncludeConfig;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.SliderConfig;
import com.t4login.application.configuration.SoundPickerConfig;
import com.t4login.application.configuration.SupportedOnIOS;
import com.t4login.application.settings.SoundTriggerUser;

@Category(value="prefs_sounds_settings_title")
public class SoundSettings
extends Configurable {
    @Category(value="prefs_sounds_general_category")
    @PropertyConfig(idx=100, name="prefs_sounds_volume_title", description="empty", editor=EditorType.VolumeSlider)
    @SliderConfig(min=0, max=100, step=1, units="%")
    @DefaultValue(value="80")
    @SupportedOnIOS(value=false)
    public int AlertVolume = 80;
    @IncludeConfig(idx=200)
    @Category(value="prefs_sounds_fill")
    @DefaultValue(value="Enabled=true,AudioFile=T4:Fill")
    public final SoundSetting OnFill = new SoundSetting("prefs_sounds_fill", true, "T4:Fill");
    @IncludeConfig(idx=201)
    @Category(value="prefs_sounds_partialfill")
    @DefaultValue(value="Enabled=true,AudioFile=T4:PartialFill")
    public final SoundSetting OnPartialFill = new SoundSetting("prefs_sounds_partialfill", true, "T4:PartialFill");
    @IncludeConfig(idx=202)
    @Category(value="prefs_sounds_pitfill")
    @DefaultValue(value="Enabled=false,AudioFile=T4:PitFill")
    public final SoundSetting OnPitFill = new SoundSetting("prefs_sounds_pitfill", false, "T4:PitFill");
    @IncludeConfig(idx=203)
    @Category(value="prefs_sounds_submission")
    @DefaultValue(value="Enabled=true,AudioFile=T4:Submission")
    public final SoundSetting OnSubmission = new SoundSetting("prefs_sounds_submission", true, "T4:Submission");
    @IncludeConfig(idx=204)
    @Category(value="prefs_sounds_working")
    @DefaultValue(value="Enabled=true,AudioFile=T4:Working")
    public final SoundSetting OnWorking = new SoundSetting("prefs_sounds_working", true, "T4:Working");
    @IncludeConfig(idx=205)
    @Category(value="prefs_sounds_pull")
    @DefaultValue(value="Enabled=true,AudioFile=T4:Pulled")
    public final SoundSetting OnPulled = new SoundSetting("prefs_sounds_pull", true, "T4:Pulled");
    @IncludeConfig(idx=206)
    @Category(value="prefs_sounds_rejected")
    @DefaultValue(value="Enabled=true,AudioFile=T4:Rejected")
    public final SoundSetting OnRejected = new SoundSetting("prefs_sounds_rejected", true, "T4:Rejected");

    @Override
    public String configID() {
        return "Sounds";
    }

    @Override
    public String configurableName() {
        return Resource.localizeString("prefs_sounds_settings_title");
    }

    public static class SoundSetting
    extends Configurable {
        @PropertyConfig(idx=0, name="prefs_sound_settings_enable_sound", description="empty", editor=EditorType.Switch)
        public boolean Enabled = true;
        @PropertyConfig(idx=1, name="prefs_sound_settings_sound", description="empty", editor=EditorType.SoundPicker)
        @SoundPickerConfig(sampleUsingVolumeSetting=true)
        public String AudioFile;
        @PropertyConfig(idx=2, name="prefs_sound_settings_trigger_user", description="prefs_sound_settings_trigger_user_summary")
        @DefaultValue(value="MyUser")
        public SoundTriggerUser TriggerUser = SoundTriggerUser.MyUser;
        private final String mAlertName_loc;

        public SoundSetting(String nm, boolean en, String au) {
            this.mAlertName_loc = nm;
            this.Enabled = en;
            this.AudioFile = au;
        }

        public String getAlertNameResID() {
            return this.mAlertName_loc;
        }

        @Override
        public String configID() {
            return "Alert";
        }

        @Override
        public String configurableName() {
            return Resource.localizeString("prefs_alert_title");
        }

        @Override
        public boolean isEnabled(String propertyName) {
            if (propertyName.equals("AudioFile") && !this.Enabled) {
                return false;
            }
            return !propertyName.equals("TriggerUser") || this.Enabled;
        }
    }
}

