/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.settings;

import com.t4login.Resource;
import com.t4login.application.configuration.IEnum;
import java.util.HashMap;
import java.util.Map;

public enum PriceDisplayMode implements IEnum
{
    Decimal(1, "prefs_pricedisplaymode_decimal", "prefs_pricedisplaymode_decimal_summary"),
    RealDecimal(2, "prefs_pricedisplaymode_realdecimal", "prefs_pricedisplaymode_realdecimal_summary"),
    ClearingDecimal(3, "prefs_pricedisplaymode_clearingdecimal", "prefs_pricedisplaymode_clearingdecimal_summary"),
    PriceFormatAndDecimal(4, "prefs_pricedisplaymode_priceformatanddecimal", "prefs_pricedisplaymode_priceformatanddecimal_summary"),
    PriceFormatAndRealDecimal(5, "prefs_pricedisplaymode_priceformatandrealdecimal", "prefs_pricedisplaymode_priceformatandrealdecimal_summary"),
    PriceFormatAndClearingDecimal(6, "prefs_pricedisplaymode_priceformatandclearingdecimal", "prefs_pricedisplaymode_priceformatandclearingdecimal_summary");

    private final int value;
    private final String descr_loc;
    private final String summary_loc;
    private static Map<Integer, PriceDisplayMode> map;

    private PriceDisplayMode(int value, String descr_loc, String summ_loc) {
        this.value = value;
        this.descr_loc = descr_loc;
        this.summary_loc = summ_loc;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getDescription() {
        return Resource.localizeString(this.descr_loc);
    }

    public String getSummary() {
        return Resource.localizeString(this.summary_loc);
    }

    public static PriceDisplayMode get(int value) {
        return map.get(value);
    }

    static {
        map = new HashMap<Integer, PriceDisplayMode>();
        for (PriceDisplayMode t : PriceDisplayMode.values()) {
            map.put(t.getValue(), t);
        }
    }
}

