/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.settings;

import com.t4login.Resource;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.EditorType;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.Serialize;
import com.t4login.application.settings.DisplayTheme;
import com.t4login.util.ColorUtil;
import com.t4login.util.ValueCompare;
import java.math.BigDecimal;

public class DisplaySettings
extends Configurable {
    @PropertyConfig(idx=0, name="prefs_display_color_bid", description="prefs_display_color_bid_summary", editor=EditorType.ColorPicker)
    @Serialize(value=Serialize.As.Color)
    public int BidColor = ColorUtil.rgb(96, 96, 255);
    @PropertyConfig(idx=1, name="prefs_display_color_bidbackground", description="prefs_display_color_bidbackground_summary", editor=EditorType.ColorPicker)
    @Serialize(value=Serialize.As.Color)
    public int BidColorBackground = ColorUtil.rgb(173, 216, 230);
    @PropertyConfig(idx=2, name="prefs_display_color_offer", description="prefs_display_color_offer_summary", editor=EditorType.ColorPicker)
    @Serialize(value=Serialize.As.Color)
    public int OfferColor = ColorUtil.rgb(255, 96, 96);
    @PropertyConfig(idx=3, name="prefs_display_color_offerbackground", description="prefs_display_color_offerbackground_summary", editor=EditorType.ColorPicker)
    @Serialize(value=Serialize.As.Color)
    public int OfferColorBackground = ColorUtil.rgb(255, 182, 193);
    @PropertyConfig(idx=4, name="prefs_display_color_trade", description="prefs_display_color_trade_summary", editor=EditorType.ColorPicker)
    @Serialize(value=Serialize.As.Color)
    public int TradeColor = ColorUtil.rgb(0, 255, 0);
    @PropertyConfig(idx=5, name="prefs_display_color_tradebackground", description="prefs_display_color_tradebackground_summary", editor=EditorType.ColorPicker)
    @Serialize(value=Serialize.As.Color)
    public int TradeColorFade = ColorUtil.rgb(143, 188, 143);
    @PropertyConfig(idx=6, name="prefs_display_color_settlement", description="prefs_display_color_settlement_summary", editor=EditorType.ColorPicker)
    @Serialize(value=Serialize.As.Color)
    public int SettlementColor = ColorUtil.rgb(255, 255, 0);
    @PropertyConfig(idx=7, name="prefs_display_color_high", description="prefs_display_color_high_summary", editor=EditorType.ColorPicker)
    @Serialize(value=Serialize.As.Color)
    public int HighColor = ColorUtil.rgb(0, 0, 255);
    @PropertyConfig(idx=8, name="prefs_display_color_low", description="prefs_display_color_low_summary", editor=EditorType.ColorPicker)
    @Serialize(value=Serialize.As.Color)
    public int LowColor = ColorUtil.rgb(255, 0, 0);
    @PropertyConfig(idx=9, name="prefs_display_color_positivevalue", description="prefs_display_color_positivevalue_summary", editor=EditorType.ColorPicker)
    @Serialize(value=Serialize.As.Color)
    public int PositiveValueColor = ColorUtil.rgb(0, 0, 255);
    @PropertyConfig(idx=10, name="prefs_display_color_negativevalue", description="prefs_display_color_negativevalue_summary", editor=EditorType.ColorPicker)
    @Serialize(value=Serialize.As.Color)
    public int NegativeValueColor = ColorUtil.rgb(255, 0, 0);
    public boolean PriceColors = false;
    private final String mConfigID;

    public DisplaySettings(DisplayTheme theme) {
        this.mConfigID = theme.name();
        if (theme.equals((Object)DisplayTheme.Dark)) {
            this.BidColor = ColorUtil.parseColor("#377eb8");
            this.BidColorBackground = ColorUtil.parseColor("#1c3f5c");
            this.OfferColor = ColorUtil.parseColor("#e41a1d");
            this.OfferColorBackground = ColorUtil.parseColor("#720d0f");
            this.TradeColor = ColorUtil.parseColor("#4daf4a");
            this.TradeColorFade = ColorUtil.parseColor("#275825");
            this.SettlementColor = ColorUtil.parseColor("#bfbf26");
            this.HighColor = ColorUtil.parseColor("#3b8338");
            this.LowColor = ColorUtil.parseColor("#ab1316");
            this.PositiveValueColor = ColorUtil.parseColor("#3b8338");
            this.NegativeValueColor = ColorUtil.parseColor("#ab1316");
        }
    }

    @Override
    public String configID() {
        return this.mConfigID;
    }

    @Override
    public String configurableName() {
        return Resource.localizeString("prefs_colors_title");
    }

    public int getValueColor(int value) {
        if (value == 0) {
            return -16777216;
        }
        if (value > 0) {
            return this.PositiveValueColor;
        }
        return this.NegativeValueColor;
    }

    public int getValueColor(double value) {
        if (value == 0.0) {
            return -16777216;
        }
        if (value > 0.0) {
            return this.PositiveValueColor;
        }
        return this.NegativeValueColor;
    }

    public int getValueColor(BigDecimal value) {
        if (ValueCompare.Equals(value, BigDecimal.ZERO)) {
            return -16777216;
        }
        if (value.compareTo(BigDecimal.ZERO) > 0) {
            return this.PositiveValueColor;
        }
        return this.NegativeValueColor;
    }
}

