/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.settings;

import com.t4login.Host;
import com.t4login.Log;
import com.t4login.Resource;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.IncludeConfig;
import com.t4login.application.configuration.serialization.ConfigUtil;
import com.t4login.application.settings.AccountDataSettings;
import com.t4login.application.settings.BatteryAndBandwidthSettings;
import com.t4login.application.settings.ContractSettings;
import com.t4login.application.settings.DisplaySettings;
import com.t4login.application.settings.DisplayTheme;
import com.t4login.application.settings.GeneralSettings;
import com.t4login.application.settings.MarketDataSettings;
import com.t4login.application.settings.NotificationSettings;
import com.t4login.application.settings.SoundSettings;
import com.t4login.application.settings.Tap2TradeSettings;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class AppSettings
extends Configurable {
    private static final String TAG = "AppSettings";
    public static final AppSettings instance = new AppSettings();
    @IncludeConfig(idx=100)
    public final GeneralSettings General = new GeneralSettings();
    @IncludeConfig(idx=200)
    public final MarketDataSettings MarketData = new MarketDataSettings();
    @IncludeConfig(idx=300)
    public final AccountDataSettings AccountData = new AccountDataSettings();
    @IncludeConfig(idx=400)
    public final Tap2TradeSettings Tap2Trade = new Tap2TradeSettings();
    @IncludeConfig(idx=500)
    public final ContractSettings Contract = new ContractSettings();
    @IncludeConfig(idx=600)
    public final DisplaySettings DisplayLight = new DisplaySettings(DisplayTheme.Light);
    @IncludeConfig(idx=601)
    public final DisplaySettings DisplayDark = new DisplaySettings(DisplayTheme.Dark);
    @IncludeConfig(idx=700)
    public final SoundSettings Sounds = new SoundSettings();
    @IncludeConfig(idx=750)
    public final NotificationSettings Notifications = new NotificationSettings();
    @IncludeConfig(idx=800)
    public final BatteryAndBandwidthSettings BatteryAndBandwidth = new BatteryAndBandwidthSettings();
    private static List<Configurable.ConfigurationChangedHandler> configChangedHandlers = new CopyOnWriteArrayList<Configurable.ConfigurationChangedHandler>();
    private DecimalFormat mCashFormatter = null;
    private DecimalFormat mCashFormatterWithCents = null;
    private boolean mCachedFormatterDisplayCents = false;

    private AppSettings() {
    }

    @Override
    public String configID() {
        return TAG;
    }

    @Override
    public String configurableName() {
        return Resource.localizeString("action_settings");
    }

    public static void registerForConfigurationChanges(Configurable.ConfigurationChangedHandler handler) {
        if (!configChangedHandlers.contains(handler)) {
            configChangedHandlers.add(handler);
        }
    }

    public static void unregisterForConfigurationChanges(Configurable.ConfigurationChangedHandler handler) {
        if (configChangedHandlers.contains(handler)) {
            configChangedHandlers.remove(handler);
        }
    }

    private static void onConfigurationChanged(boolean restored) {
        for (Configurable.ConfigurationChangedHandler h : configChangedHandlers) {
            try {
                h.onConfigurationChanged(restored);
            }
            catch (Exception ex) {
                Log.e(TAG, "onConfigurationChanged(), Error.", ex);
            }
        }
    }

    public static void settingsUpdated(boolean restored) {
        AppSettings.onConfigurationChanged(restored);
    }

    public void resetToDefaults() {
        ConfigUtil.resetToDefaults(this);
    }

    public DecimalFormat getCashFormat() {
        if (this.mCashFormatter == null || this.mCachedFormatterDisplayCents != this.AccountData.DisplayCents) {
            this.mCachedFormatterDisplayCents = this.AccountData.DisplayCents;
            this.mCashFormatter = this.AccountData.DisplayCents ? new DecimalFormat("#,##0.00") : new DecimalFormat("#,##0");
            this.mCashFormatter.setRoundingMode(RoundingMode.HALF_UP);
        }
        return this.mCashFormatter;
    }

    public DecimalFormat getCashFormatWithCents() {
        if (this.mCashFormatterWithCents == null) {
            this.mCashFormatterWithCents = new DecimalFormat("#,##0.00");
            this.mCashFormatterWithCents.setRoundingMode(RoundingMode.HALF_UP);
        }
        return this.mCashFormatterWithCents;
    }

    public DisplaySettings getDisplaySettings() {
        if (Host.getDisplayTheme().equals((Object)DisplayTheme.Dark)) {
            return this.DisplayDark;
        }
        return this.DisplayLight;
    }
}

