/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.recentfills;

import com.t4login.api.Market;
import com.t4login.api.MarketData;
import com.t4login.api.PriceFormatter;
import com.t4login.api.accounts.Order;
import com.t4login.api.accounts.Trade;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.BuySell;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.util.Pair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class TradeItem {
    private static final SimpleDateFormat DefaultTimeFormatter = NDateTime.createDateFormat("h:mm:ss.SSS a");
    public final Pair<Long, Integer> ID;
    private List<Trade> mTrades = new ArrayList<Trade>();
    private Market mMarket;
    private int mSortID;

    public TradeItem(Trade trade, Market market, int sortID) {
        this.mTrades.add(trade);
        this.mMarket = market;
        this.ID = new Pair<Long, Integer>(trade.getUniqueOrderID(), trade.getTradeSeq());
        this.mSortID = sortID;
    }

    public boolean aggregate(Trade trade) {
        Trade t = this.mTrades.get(0);
        long ordID = t.getUniqueOrderID();
        long ordIDTrade = trade.getUniqueOrderID();
        BuySell side = t.getSide();
        BuySell sideTrade = trade.getSide();
        Price price = t.getPrice();
        Price priceTrade = trade.getPrice();
        NDateTime timeBucket = t.getTimeBucket();
        NDateTime timeBucketTrade = trade.getTimeBucket();
        if (ordID == ordIDTrade && side == sideTrade && price == priceTrade && timeBucket.compareTo(timeBucketTrade) == 0) {
            this.mTrades.add(trade);
            return true;
        }
        return false;
    }

    public Order getOrder() {
        return this.mTrades.get(0).getOrder();
    }

    public int getSortID() {
        return this.mSortID;
    }

    public long getUniqueOrderID() {
        return this.mTrades.get(0).getUniqueOrderID();
    }

    public int getTradeSeq() {
        return this.mTrades.get(0).getTradeSeq();
    }

    public String getOrderID() {
        return this.mTrades.get(0).getOrderID();
    }

    public Market getMarket() {
        return this.mMarket;
    }

    public NDateTime getTime() {
        NDateTime time = this.mTrades.get(0).getTime();
        for (int i = 1; i < this.mTrades.size(); ++i) {
            NDateTime iTime = this.mTrades.get(i).getTime();
            if (iTime.compareTo(time) <= 0) continue;
            time = iTime;
        }
        return time;
    }

    public String getTimeDisplay() {
        NDateTime time = this.getTime();
        if (time != null) {
            return time.toString(DefaultTimeFormatter);
        }
        return "";
    }

    public int getCount() {
        return this.mTrades.size();
    }

    public BuySell getSide() {
        return this.mTrades.get(0).getSide();
    }

    public String getFillDescription(PriceFormatter prcFmt) {
        int totalVolume = 0;
        for (Trade trade : this.mTrades) {
            totalVolume += trade.getVolume();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSide().getDescription()).append(" ");
        sb.append(totalVolume).append("@").append(prcFmt.formatPrice(this.getMarket(), this.mTrades.get(0).getPrice()));
        return sb.toString();
    }

    public String getMarketDescription(MarketData marketData) {
        if (marketData != null) {
            return marketData.getFormattedMarketDescription(this.mMarket);
        }
        return this.mMarket.getDescription();
    }
}

