/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.quoteboard.settings;

import com.t4login.Resource;
import com.t4login.application.accountboard.PositionFilter;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.IncludeConfigs;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.quoteboard.settings.QuoteBoardPageType;
import com.t4login.definitions.ContractType;
import com.t4login.definitions.StrategyType;
import com.t4login.util.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QuoteBoardPage
extends Configurable {
    @PropertyConfig(idx=0, name="quoteboard_page_name", description="empty")
    public String PageName = "";
    @PropertyConfig(idx=1, name="quoteboard_page_uuid", description="empty")
    public int PageID = -1;
    @PropertyConfig(idx=2, name="quoteboard_page_type", description="empty")
    public PageLayout Layout = PageLayout.Quotes;
    @PropertyConfig(idx=3, name="quoteboard_page_autoentries", description="empty")
    public QuoteBoardPageType PageType = QuoteBoardPageType.Custom;
    @PropertyConfig(idx=4, name="quoteboard_page_position_filter", description="empty")
    public PositionFilter AutoPagePositionFilter = PositionFilter.All;
    @IncludeConfigs(idx=5, as="Entry")
    public List<PageEntry> Entries = new ArrayList<PageEntry>();

    @Override
    public String configID() {
        return "QuoteBoardPage";
    }

    @Override
    public String configurableName() {
        return "Quote Board Page";
    }

    public boolean isAuto() {
        return this.PageType.equals((Object)QuoteBoardPageType.Automatic);
    }

    public String getPageTitle() {
        if (this.isAuto()) {
            return this.AutoPagePositionFilter.getTitle() + " " + Resource.localizeString("quoteboard_page_auto_page_name_suffix");
        }
        return this.PageName;
    }

    public String getDescription() {
        if (this.PageType.equals((Object)QuoteBoardPageType.Automatic)) {
            return this.AutoPagePositionFilter.getTitle();
        }
        if (this.Entries.size() == 0) {
            return Resource.localizeString("quoteboard_page_description_empty");
        }
        ArrayList<String> contractDescriptions = new ArrayList<String>();
        for (int i = 0; i < Math.min(5, this.Entries.size()); ++i) {
            PageEntry entry = this.Entries.get(i);
            if (entry.ContractDescription.isEmpty()) continue;
            contractDescriptions.add(entry.ContractDescription);
        }
        if (this.Entries.size() > 5) {
            contractDescriptions.add("...");
        }
        return TextUtils.join((CharSequence)", ", contractDescriptions);
    }

    public static enum PageLayout {
        Quotes(0, "qb_pagelayout_quotes"),
        CondensedQuotes(1, "qb_pagelayout_condensed_quotes"),
        CondensedCharts(2, "qb_pagelayout_condensed_charts");

        private final int value;
        private final String descr_loc;
        private static Map<Integer, PageLayout> map;

        private PageLayout(int value, String descr) {
            this.value = value;
            this.descr_loc = descr;
        }

        public int getValue() {
            return this.value;
        }

        public String getDescr() {
            return Resource.localizeString(this.descr_loc);
        }

        public String toString() {
            return this.getDescr();
        }

        static {
            map = new HashMap<Integer, PageLayout>();
            for (PageLayout t : PageLayout.values()) {
                map.put(t.getValue(), t);
            }
        }
    }

    public static class PageEntry
    extends Configurable {
        @PropertyConfig(idx=0, name="quoteboard_page_entry_exchangeid", description="empty")
        public String ExchangeID;
        @PropertyConfig(idx=1, name="quoteboard_page_entry_contractid", description="empty")
        public String ContractID = "";
        @PropertyConfig(idx=2, name="quoteboard_page_entry_marketid", description="empty")
        public String MarketID = "";
        @PropertyConfig(idx=3, name="quoteboard_page_entry_marketdetail", description="empty")
        public String MarketDetail = "";
        @PropertyConfig(idx=4, name="quoteboard_page_entry_basemarketid", description="empty")
        public String BaseMarketID = "";
        @PropertyConfig(idx=5, name="quoteboard_page_entry_extra", description="empty")
        public String Extra = "";
        @PropertyConfig(idx=6, name="quoteboard_page_entry_contractdescription", description="empty")
        public String ContractDescription = "";
        @PropertyConfig(idx=7, name="quoteboard_page_entry_expirydescription", description="empty")
        public String ExpiryDescription = "";
        @PropertyConfig(idx=8, name="quoteboard_page_entry_contracttype", description="empty")
        @DefaultValue(value="Unknown")
        public ContractType ContractType = com.t4login.definitions.ContractType.Unknown;
        @PropertyConfig(idx=9, name="quoteboard_page_entry_strategytype", description="empty")
        @DefaultValue(value="Any")
        public StrategyType StrategytType = StrategyType.Any;
        @PropertyConfig(idx=10, name="quoteboard_page_entry_strikeprice", description="empty")
        @DefaultValue(value="0")
        public Integer StrikePrice = 0;
        @PropertyConfig(idx=11, name="quoteboard_page_entry_strikeprice", description="empty")
        @DefaultValue(value="")
        public Long ProfileId = null;

        @Override
        public String configID() {
            return "QuoteBoardPage$PageEntry";
        }

        @Override
        public String configurableName() {
            return "Page Item";
        }
    }
}

