/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.quoteboard.settings;

import com.t4login.Log;
import com.t4login.application.ConfigContext;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.IncludeConfigs;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.serialization.ConfigReader;
import com.t4login.application.configuration.serialization.ConfigSerializer;
import com.t4login.application.configuration.serialization.XmlSerializerDelayedWrapper;
import com.t4login.application.quoteboard.settings.QuoteBoardPage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class QuoteBoardLayout
extends Configurable {
    private static final String TAG = "QuoteBoardLayout";
    public static final String STATE_CURRENT_PAGE_ID = "quoteboard.currentpage";
    public static final QuoteBoardLayout instance = new QuoteBoardLayout();
    @PropertyConfig(idx=0, name="quoteboard_auto_page_introduced", description="empty")
    public boolean AutoPageIntroduced = false;
    @IncludeConfigs(idx=0, as="Page")
    public List<QuoteBoardPage> Pages = new ArrayList<QuoteBoardPage>();
    private static List<Configurable.ConfigurationChangedHandler> configChangedHandlers;

    @Override
    public String configID() {
        return TAG;
    }

    @Override
    public String configurableName() {
        return "Quote Board Layout";
    }

    public int getIndexOfPageID(int pageID) {
        for (int i = 0; i < this.Pages.size(); ++i) {
            if (this.Pages.get((int)i).PageID != pageID) continue;
            return i;
        }
        return 0;
    }

    public static void registerForConfigurationChanges(Configurable.ConfigurationChangedHandler handler) {
        if (!configChangedHandlers.contains(handler)) {
            configChangedHandlers.add(handler);
        }
    }

    public static void unregisterForConfigurationChanges(Configurable.ConfigurationChangedHandler handler) {
        if (configChangedHandlers.contains(handler)) {
            configChangedHandlers.remove(handler);
        }
    }

    private static void onConfigurationChanged() {
        for (Configurable.ConfigurationChangedHandler h : configChangedHandlers) {
            try {
                h.onConfigurationChanged(false);
            }
            catch (Exception ex) {
                Log.e(TAG, "onConfigurationChanged(), Error.", ex);
            }
        }
    }

    public static void restoreFromXML(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, null, TAG);
        ConfigReader rdr = new ConfigReader(ConfigContext.Default);
        QuoteBoardLayout.instance.Pages.clear();
        rdr.parseConfigSettings(parser, (Configurable)instance);
    }

    public static void saveToXML(XmlSerializerDelayedWrapper ser) {
        if (instance != null) {
            ConfigSerializer configSer = new ConfigSerializer(ConfigContext.Default);
            configSer.serializeConfigSettings(ser, instance, TAG, false);
        }
    }

    public static QuoteBoardPage getPage(long pageID) {
        QuoteBoardLayout.checkInitialized();
        QuoteBoardPage page = null;
        for (QuoteBoardPage p : QuoteBoardLayout.instance.Pages) {
            if ((long)p.PageID != pageID) continue;
            page = p;
            break;
        }
        if (page == null) {
            Log.e(TAG, "getPage(), page ID '" + pageID + "' does not exist. Returning default page instead.");
            page = QuoteBoardLayout.instance.Pages.get(0);
        }
        return page;
    }

    public static void pageUpdated(QuoteBoardPage page) {
        QuoteBoardLayout.onConfigurationChanged();
    }

    private static int getUniquePageID() {
        int id = 0;
        for (QuoteBoardPage p : QuoteBoardLayout.instance.Pages) {
            id = Math.max(id, p.PageID);
        }
        if (id < Integer.MAX_VALUE) {
            return id + 1;
        }
        id = -1;
        int tryID = 0;
        while (id == -1) {
            boolean unique = true;
            for (QuoteBoardPage p : QuoteBoardLayout.instance.Pages) {
                if (p.PageID != tryID) continue;
                unique = false;
                break;
            }
            id = unique ? tryID : -1;
        }
        return id;
    }

    public static void checkInitialized() {
        if (QuoteBoardLayout.instance.Pages.size() == 0) {
            // empty if block
        }
        if (QuoteBoardLayout.instance.Pages.size() == 0) {
            QuoteBoardPage p = QuoteBoardLayout.createDefaultPage();
            p.PageName = "Default";
            QuoteBoardLayout.instance.Pages.add(p);
        }
    }

    public static void addPage(QuoteBoardPage page) {
        for (QuoteBoardPage p : QuoteBoardLayout.instance.Pages) {
            if (p != page) continue;
            Log.e(TAG, "addPage(), Page already exists.");
        }
        if (page.PageID < 0) {
            page.PageID = QuoteBoardLayout.getUniquePageID();
        }
        QuoteBoardLayout.instance.Pages.add(page);
        QuoteBoardLayout.onConfigurationChanged();
    }

    public static void removePage(QuoteBoardPage page) {
        int idx;
        if (instance != null && (idx = QuoteBoardLayout.instance.Pages.indexOf(page)) >= 0) {
            QuoteBoardLayout.instance.Pages.remove(idx);
        }
        QuoteBoardLayout.onConfigurationChanged();
    }

    public static void removePage(int idx) {
        if (instance != null && idx >= 0) {
            QuoteBoardLayout.instance.Pages.remove(idx);
        }
    }

    public static void movePage(int from, int to) {
        QuoteBoardPage page = QuoteBoardLayout.instance.Pages.remove(from);
        QuoteBoardLayout.instance.Pages.add(to, page);
    }

    public static QuoteBoardPage createNewPage(QuoteBoardPage copy) {
        Object newName = "";
        int i = 1;
        while (((String)newName).isEmpty()) {
            Object testName = "New Page";
            if (i > 1) {
                testName = (String)testName + " (" + i + ")";
            }
            for (QuoteBoardPage p : QuoteBoardLayout.instance.Pages) {
                if (!p.PageName.equals(testName)) continue;
                ++i;
                break;
            }
            newName = testName;
        }
        QuoteBoardPage newPage = new QuoteBoardPage();
        newPage.PageName = newName;
        if (copy != null) {
            ConfigSerializer ser = new ConfigSerializer(ConfigContext.Default);
            String xml = ser.serializeConfigSettings(copy, "Page");
            ConfigReader rdr = new ConfigReader(ConfigContext.Default);
            rdr.parseConfigSettings(xml, (Configurable)newPage);
        }
        newPage.PageID = QuoteBoardLayout.getUniquePageID();
        return newPage;
    }

    public static boolean checkName(String name) {
        for (QuoteBoardPage p : QuoteBoardLayout.instance.Pages) {
            if (!p.PageName.equals(name)) continue;
            return false;
        }
        return true;
    }

    public static QuoteBoardPage createDefaultPage() {
        QuoteBoardPage page = new QuoteBoardPage();
        page.PageName = "Default";
        return page;
    }

    static {
        QuoteBoardLayout.checkInitialized();
        configChangedHandlers = new CopyOnWriteArrayList<Configurable.ConfigurationChangedHandler>();
    }
}

