/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.quoteboard;

import com.t4login.api.Contract;
import com.t4login.api.Market;
import com.t4login.api.MarketData;
import com.t4login.api.MarketDataChange;
import com.t4login.api.MarketDataSnapshot;
import com.t4login.application.quoteboard.settings.QuoteBoardPage;
import com.t4login.application.sparkline.SparklineChartData;
import java.util.EnumSet;

public class QuoteBoardItem {
    public final QuoteBoardPage.PageEntry PageEntry;
    private Contract mContract;
    private Market mMarket;
    public MarketDataSnapshot Snapshot;
    public SparklineChartData SparkChart = SparklineChartData.Empty;
    public MarketDataSnapshot PreviousSnapshot = null;
    private ItemState mState = ItemState.Restored;

    public QuoteBoardItem(QuoteBoardPage.PageEntry item) {
        this.PageEntry = item;
        this.Snapshot = MarketDataSnapshot.Empty;
        this.mState = ItemState.Restored;
    }

    public String toString() {
        return String.format("e: %s, c: %s, m: %s xtra: %s (%s / %s), State: %s", this.PageEntry.ExchangeID, this.PageEntry.ContractID, this.PageEntry.MarketID, this.PageEntry.Extra, this.getContractDescription(), this.getExpiryDisp(), this.mState.toString());
    }

    public ItemState getItemState() {
        return this.mState;
    }

    public void setItemState(ItemState value) {
        this.mState = value;
    }

    public void Update(MarketDataSnapshot snapshot) {
        this.Snapshot = snapshot;
    }

    public boolean hasData() {
        return this.Snapshot != null && !this.Snapshot.isEmpty();
    }

    public EnumSet<MarketDataChange> getChanges(MarketDataSnapshot snapshot) {
        if (this.Snapshot == null && snapshot != null) {
            return EnumSet.allOf(MarketDataChange.class);
        }
        return this.Snapshot.getChanges(snapshot);
    }

    public String getExchangeID() {
        return this.PageEntry.ExchangeID;
    }

    public String getContractID() {
        return this.PageEntry.ContractID;
    }

    public String getMarketID() {
        if (this.mMarket != null) {
            return this.PageEntry.MarketID;
        }
        String marketID = this.PageEntry.MarketID;
        Contract contract = this.getContract();
        if (contract != null && contract.getExchangeID().equals("DL" + this.PageEntry.ExchangeID)) {
            marketID = marketID.replace("CME_", "DLCME_");
            marketID = marketID.replace("ICE_", "DLICE_");
        }
        return marketID;
    }

    public String getMarketDetail() {
        return this.PageEntry.MarketDetail;
    }

    public String getBaseMarketID() {
        return this.PageEntry.BaseMarketID;
    }

    public boolean hasExtraDetail() {
        return this.PageEntry.Extra != null && this.PageEntry.Extra.length() > 0;
    }

    public String getMarketExtraDetail() {
        return this.PageEntry.Extra;
    }

    public String getMarketDescription() {
        return this.getMarketDescription(null);
    }

    public String getMarketDescription(MarketData marketData) {
        if (this.mMarket != null) {
            if (marketData != null) {
                return marketData.getFormattedMarketDescription(this.mMarket);
            }
            return this.mMarket.getDescription();
        }
        return this.getContractDescription();
    }

    public String getContractDescription() {
        if (this.mContract != null) {
            return this.mContract.getDescription();
        }
        if (this.PageEntry.ContractDescription != null && this.PageEntry.ContractDescription.length() > 0) {
            return this.PageEntry.ContractDescription;
        }
        return this.PageEntry.ContractID;
    }

    public String getContractType() {
        if (this.mMarket != null) {
            return this.mMarket.getContractType().name();
        }
        return "";
    }

    public String getStrategyType() {
        if (this.mMarket != null) {
            return this.mMarket.getStrategyType().name();
        }
        return "";
    }

    public String getStrikePrice() {
        return "";
    }

    public Contract getContract() {
        return this.mContract;
    }

    public void setContract(Contract c) {
        this.mContract = c;
        this.mState = this.mContract != null ? ItemState.WaitingForMarkets : ItemState.Undefined;
    }

    public Market getMarket() {
        return this.mMarket;
    }

    public void setMarket(Market market) {
        this.mMarket = market;
        this.PageEntry.ExchangeID = market.getExchangeID();
        this.PageEntry.ContractID = market.getContractID();
        this.PageEntry.MarketID = market.getMarketID();
        this.PageEntry.MarketDetail = market.getMarketDetail();
        this.PageEntry.BaseMarketID = "";
        this.PageEntry.Extra = "";
        this.PageEntry.ContractDescription = this.getContractDescription();
        this.PageEntry.ExpiryDescription = this.getMarketDescription();
        this.PageEntry.ContractType = market.getContractType();
        this.PageEntry.StrategytType = market.getStrategyType();
        this.PageEntry.StrikePrice = null;
    }

    public boolean getMarketChanged() {
        if (this.mMarket == null ^ this.Snapshot == null) {
            return true;
        }
        return this.mMarket != null && this.Snapshot != null && !this.mMarket.getMarketID().equals(this.Snapshot.Market.getMarketID());
    }

    public String getExpiryDisp() {
        if (this.mMarket == null) {
            if (this.PageEntry.ExpiryDescription != null && this.PageEntry.ExpiryDescription.length() > 0) {
                return this.PageEntry.ExpiryDescription;
            }
            return "-";
        }
        return this.mMarket.getExpiryDescription();
    }

    public static enum ItemState {
        Undefined,
        Restored,
        WaitingForMarkets,
        Complete;

    }
}

