/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.orderdetail;

import com.t4login.api.Market;
import com.t4login.api.MarketPriceFormatter;
import com.t4login.api.accounts.Account;
import com.t4login.api.accounts.Order;
import com.t4login.datetime.NDateTime;
import com.t4login.messages.MsgOrderUpdateD;
import com.t4login.util.Pair;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class OrderDetailUtil {
    private static SimpleDateFormat mDateFormatter = NDateTime.createDateFormat("M/d/yyyy");
    private static SimpleDateFormat mTimeFormatter = NDateTime.createDateFormat("h:mm:ss.S a");

    private OrderDetailUtil() {
    }

    public static List<Pair<String, String>> createOrderDetailList(Account acct, Order order, MarketPriceFormatter prcFmt) {
        ArrayList<Pair<String, String>> details = new ArrayList<Pair<String, String>>();
        MsgOrderUpdateD msg = order.getLastUpdate();
        Market market = prcFmt.getMarket();
        details.clear();
        details.add(new Pair<String, String>("Date", msg.Time.toString(mDateFormatter)));
        details.add(new Pair<String, String>("Time", msg.Time.toString(mTimeFormatter)));
        details.add(new Pair<String, String>("Exchange Time", msg.ExchangeTime.toString(mTimeFormatter)));
        details.add(new Pair<String, String>("Trade Date", msg.TradeDate.toString(mDateFormatter)));
        details.add(new Pair<String, String>("Market", market.getDescription()));
        details.add(new Pair<String, String>("Buy/Sell", msg.BuySell.getDescription()));
        details.add(new Pair<String, CallSite>("Volume", (CallSite)((Object)(msg.TotalFillVolume + "/" + msg.CurrentVolume))));
        details.add(new Pair<String, String>("Order Type", Order.getOrderTypeDisplay(msg, prcFmt)));
        details.add(new Pair<String, String>("Status", Order.getOrderStatusSummary(order)));
        details.add(new Pair<String, String>("Current Volume", Integer.toString(msg.CurrentVolume)));
        details.add(new Pair<String, String>("New Volume", Integer.toString(msg.NewVolume)));
        details.add(new Pair<String, String>("Current Limit Price", prcFmt.formatPrice(msg.CurrentLimitPrice)));
        details.add(new Pair<String, String>("New Limit Price", prcFmt.formatPrice(msg.NewLimitPrice)));
        details.add(new Pair<String, String>("Current Stop Price", prcFmt.formatPrice(msg.CurrentStopPrice)));
        details.add(new Pair<String, String>("New Stop Price", prcFmt.formatPrice(msg.NewStopPrice)));
        details.add(new Pair<String, String>("Current Max Show", Integer.toString(msg.CurrentMaxShow)));
        details.add(new Pair<String, String>("New Max Show", Integer.toString(msg.NewMaxShow)));
        details.add(new Pair<String, String>("Trail Price", order.getTrailPrice() != null ? prcFmt.formatPrice(order.getTrailPrice()) : ""));
        details.add(new Pair<String, String>("Price Type", msg.PriceType.getDescription()));
        details.add(new Pair<String, String>("Time Type", msg.TimeType.getDescription()));
        details.add(new Pair<String, String>("Pending", msg.PendingResponse.toString()));
        details.add(new Pair<String, String>("Change", msg.Change.getDescription()));
        details.add(new Pair<String, String>("Exchange Order ID", msg.ExchangeOrderID));
        details.add(new Pair<String, String>("Executing Login ID", msg.ExecutingLoginID));
        details.add(new Pair<String, String>("Account Name", acct.getDisplayName()));
        details.add(new Pair<String, String>("Account", msg.AccountNumber));
        details.add(new Pair<String, String>("CTI", msg.CTI.getDescription()));
        details.add(new Pair<String, String>("Origin", msg.Origin.getDescription()));
        details.add(new Pair<String, String>("Account Code", msg.AccountCode.getDescription()));
        details.add(new Pair<String, String>("Billing Fee", msg.BillingFee.toString()));
        details.add(new Pair<String, String>("Member Allocation", msg.MemberAllocation));
        details.add(new Pair<String, String>("Trader Allocation", msg.TraderAllocation));
        details.add(new Pair<String, String>("Omnibus Account", msg.OmnibusAccount));
        details.add(new Pair<String, String>("Customer Reference", msg.CustomerReference));
        details.add(new Pair<String, String>("Open/Close", msg.OpenClose.toString()));
        details.add(new Pair<String, String>("User Name", msg.UserName));
        details.add(new Pair<String, String>("User Address", msg.UserAddress));
        details.add(new Pair<String, String>("Exchange Login ID", msg.ExchangeLoginID));
        details.add(new Pair<String, String>("Exchange Location", msg.ExchangeLocation));
        details.add(new Pair<String, String>("Primary User", msg.PrimaryUser.toString()));
        details.add(new Pair<String, String>("Master Type", msg.MasterType.toString()));
        details.add(new Pair<String, String>("Routing User", msg.RoutingUserName));
        details.add(new Pair<String, String>("App Name", msg.AppName));
        details.add(new Pair<String, String>("App Type", msg.AppType.toString()));
        details.add(new Pair<String, String>("First Exchange Tag", msg.FirstExchangeTag));
        details.add(new Pair<String, String>("Last Exchange Tag", msg.LastExchangeTag));
        details.add(new Pair<String, String>("Tag", msg.Tag));
        details.add(new Pair<String, String>("TagClOrdId", msg.TagClOrdID));
        details.add(new Pair<String, String>("TagRelationId", msg.TagRelationID));
        details.add(new Pair<String, String>("User Svr", msg.UserSvr));
        details.add(new Pair<String, String>("Account Svr", msg.AccountSvr));
        details.add(new Pair<String, String>("Exchange Svr", msg.ExchangeSvr));
        details.add(new Pair<String, String>("OrderLink", msg.OrderLink.getDescription()));
        details.add(new Pair<String, String>("Orders Linked", msg.OrdersLinked));
        details.add(new Pair<String, String>("Activiation Type", msg.ActivationType.toString()));
        details.add(new Pair<String, String>("Activiation Details", msg.ActivationDetails));
        details.add(new Pair<String, String>("Working Volume", Integer.toString(msg.WorkingVolume)));
        details.add(new Pair<String, String>("Total Fill Volume", Integer.toString(msg.TotalFillVolume)));
        details.add(new Pair<String, String>("SMPID", msg.SMPID));
        details.add(new Pair<String, String>("ATS Regulatory ID", msg.ATSRegulatoryID));
        details.add(new Pair<String, String>("Authorized Trader ID", msg.AuthorizedTraderID));
        details.add(new Pair<String, String>("Instruction Extra", msg.InstructionExtra.toString()));
        return details;
    }
}

