/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.orderbook;

import com.t4login.api.Market;
import com.t4login.api.MarketData;
import com.t4login.api.MarketPriceFormatter;
import com.t4login.api.PriceFormatter;
import com.t4login.api.accounts.Order;
import com.t4login.application.settings.AppSettings;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.BuySell;
import com.t4login.definitions.OrderStatus;
import com.t4login.definitions.priceconversion.IPriceFormatArgs;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.definitions.priceconversion.PriceFormat;
import com.t4login.messages.MsgOrderUpdateD;
import java.text.SimpleDateFormat;

public class OrderBookItem {
    public static final SimpleDateFormat DefaultTimeFormatter = NDateTime.createDateFormat("h:mm:ss.SSS a");
    private Order mOrder;
    private Market mMarket;
    private NDateTime mSubmitTime;
    private NDateTime mUpdateTime;

    public OrderBookItem(Order order, Market market) {
        this.mOrder = order;
        this.mMarket = market;
        this.mSubmitTime = this.mOrder.getLastUpdate().SubmitTime;
        this.mUpdateTime = this.mOrder.getLastUpdate().Time;
    }

    public String toString() {
        PriceFormatter prcFmt = new PriceFormatter(this){

            @Override
            public String formatPrice(Market market, Price price) {
                return PriceFormat.convertPriceToDisplayFormat(price, (IPriceFormatArgs)market, AppSettings.instance.MarketData.PriceDisplay);
            }
        };
        return String.format("OrderBookItem, time: %s market: %s, side: %s, volume: %s, typ: %s, status: %s", this.getSubmitTimeDisplay(), this.getMarketDescription(null), this.getSide().getDescription(), this.getVolumeDisplay(), this.getOrderDescription(prcFmt), this.getOrderStatusDisplay());
    }

    public Market getMarket() {
        return this.mMarket;
    }

    public String getOrderID() {
        return this.mOrder.getUniqueID();
    }

    public long getUniqueOrderID() {
        return this.mOrder.UniqueOrderID;
    }

    public String getOrderDescription(PriceFormatter prcFmt) {
        return this.getOrderTypeDisplay(prcFmt) + ", " + this.mMarket.getDescription();
    }

    public boolean isWorking() {
        MsgOrderUpdateD update = this.mOrder.getLastUpdate();
        return (update.Status.equals(OrderStatus.Working) || update.Status.equals(OrderStatus.None)) && update.WorkingVolume > 0;
    }

    public void updateItem(Order order) {
        this.mOrder = order;
        this.mSubmitTime = this.mOrder.getLastUpdate().SubmitTime;
        this.mUpdateTime = this.mOrder.getLastUpdate().Time;
    }

    public NDateTime getUpdateTime() {
        return this.mUpdateTime;
    }

    public String getUpdateTimeDisplay() {
        if (this.mUpdateTime != null) {
            return this.mUpdateTime.toString(DefaultTimeFormatter);
        }
        return "";
    }

    public String getUpdateDateDisplay() {
        return this.mUpdateTime.toDateString();
    }

    public NDateTime getSubmitTime() {
        return this.mSubmitTime;
    }

    public String getSubmitTimeDisplay() {
        if (this.mSubmitTime != null) {
            return this.mSubmitTime.toString(DefaultTimeFormatter);
        }
        return "";
    }

    public String getMarketDescription(MarketData marketData) {
        if (marketData != null) {
            return marketData.getFormattedMarketDescription(this.mMarket);
        }
        return this.mMarket.getDescription();
    }

    public BuySell getSide() {
        return this.mOrder.getSide();
    }

    public String getVolumeDisplay() {
        return this.mOrder.getTotalFillVolume() + "/" + this.mOrder.getCurrentVolume();
    }

    public String getOrderTypeDisplay(final PriceFormatter prcFmt) {
        return Order.getOrderTypeDisplay(this.mOrder.getLastUpdate(), new MarketPriceFormatter(){

            @Override
            public Market getMarket() {
                return OrderBookItem.this.mMarket;
            }

            @Override
            public String formatPrice(Price price) {
                return prcFmt.formatPrice(this.getMarket(), price);
            }
        });
    }

    public String getOrderStatusDisplay() {
        return Order.getOrderStatusSummary(this.mOrder);
    }
}

