/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.orderbook;

import com.t4login.Resource;
import java.util.HashMap;
import java.util.Map;

public enum OrderBookFilter {
    All(0, "orderbookfilter_menu_all", "orderbookfilter_title_all"),
    AllCurrentDay(1, "orderbookfilter_menu_allcurrentday", "orderbookfilter_title_allcurrentday"),
    Filled(2, "orderbookfilter_menu_filled", "orderbookfilter_title_filled"),
    PreviousDayFills(3, "orderbookfilter_menu_previousdayfills", "orderbookfilter_title_previousdayfills"),
    CurrentDayFills(4, "orderbookfilter_menu_currentdayfills", "orderbookfilter_title_currentdayfills"),
    Working(5, "orderbookfilter_menu_working", "orderbookfilter_title_working"),
    WorkingGTC(6, "orderbookfilter_menu_workinggtc", "orderbookfilter_title_workinggtc"),
    WorkingNonGTC(7, "orderbookfilter_menu_workingnongtc", "orderbookfilter_title_workingnongtc"),
    Canceled(8, "orderbookfilter_menu_canceled", "orderbookfilter_title_canceled"),
    HeldOnServer(9, "orderbookfilter_menu_heldonserver", "orderbookfilter_title_heldonserver"),
    Rejected(10, "orderbookfilter_menu_rejected", "orderbookfilter_title_rejected"),
    CurrentDayFillsNoPit(11, "orderbookfilter_menu_currentdayfillsnopit", "orderbookfilter_title_currentdayfillsnopit");

    private final int value;
    private final String menuLabel_loc;
    private final String activityTitle_loc;
    private static Map<Integer, OrderBookFilter> map;

    private OrderBookFilter(int value, String lablel_loc, String title_loc) {
        this.value = value;
        this.menuLabel_loc = lablel_loc;
        this.activityTitle_loc = title_loc;
    }

    public int getValue() {
        return this.value;
    }

    public String getMenuLabel() {
        return Resource.localizeString(this.menuLabel_loc);
    }

    public String getActivityTitle() {
        return Resource.localizeString(this.activityTitle_loc);
    }

    public static OrderBookFilter get(int value) {
        OrderBookFilter v = map.get(value);
        if (v == null) {
            v = All;
        }
        return v;
    }

    public String toString() {
        return this.name();
    }

    static {
        map = new HashMap<Integer, OrderBookFilter>();
        for (OrderBookFilter t : OrderBookFilter.values()) {
            map.put(t.getValue(), t);
        }
    }
}

