/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.contract.ladder.pricescale;

import com.t4login.Log;
import com.t4login.api.Market;
import com.t4login.api.accounts.PositionWorkingOrders;
import com.t4login.application.contract.ladder.DepthSnapshot;
import com.t4login.application.contract.ladder.PriceHighlight;
import com.t4login.application.contract.ladder.pricescale.DepthPriceScale;
import com.t4login.application.contract.ladder.pricescale.LadderPriceScale;
import com.t4login.application.settings.AutoTrackMode;
import com.t4login.definitions.ImpliedPriceType;
import com.t4login.definitions.priceconversion.IMarketConversion;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.util.Range;
import java.math.BigDecimal;

public abstract class PriceScale {
    private static final String TAG = "ChartPriceScale";
    private final boolean mIsPlaceholder;
    private final IMarketConversion mMarket;
    private int mScaleCenter = 0;
    private int mScrollOffset = 0;
    private Range<Integer> mPlotRange = Range.empty();
    private int mIntervalSize = 18;

    public PriceScale(boolean isPlaceHolder, IMarketConversion market, Range<Integer> plotRange, int intervalSize) {
        this.mIsPlaceholder = isPlaceHolder;
        this.mMarket = market;
        this.mPlotRange = plotRange;
        this.mIntervalSize = intervalSize;
    }

    public static PriceScale createPriceScale(Market market, Range<Integer> plotRange, int intervalSize, AutoTrackMode autoTrack) {
        if (plotRange.isEmpty()) {
            plotRange = new Range<Integer>(0, intervalSize);
        }
        if (market == null) {
            return new LadderPriceScale(true, Market.Empty, plotRange, intervalSize);
        }
        if (autoTrack == AutoTrackMode.Depth) {
            return new DepthPriceScale(market.isCachedMarket(), market, plotRange, intervalSize);
        }
        return new LadderPriceScale(market.isCachedMarket(), market, plotRange, intervalSize);
    }

    public static boolean checkPriceScale(PriceScale scale, Market market, Range<Integer> plotRange, int intervalSize, AutoTrackMode autoTrack) {
        if (market == null || market.isCachedMarket()) {
            return scale.mIsPlaceholder;
        }
        if (scale.mIsPlaceholder || !scale.mMarket.getMarketID().equals(market.getMarketID()) || autoTrack == AutoTrackMode.Depth && !(scale instanceof DepthPriceScale) || autoTrack != AutoTrackMode.Depth && scale instanceof DepthPriceScale) {
            Log.d(TAG, "checkPriceScale(),  isPlaceHolder: " + scale.mIsPlaceholder + ", market: " + String.valueOf(market));
            Log.d(TAG, "                   markets differ: " + !scale.mMarket.getMarketID().equals(market.getMarketID()));
            Log.d(TAG, "                   <> depth scale: " + (autoTrack == AutoTrackMode.Depth && !(scale instanceof DepthPriceScale) || autoTrack != AutoTrackMode.Depth && scale instanceof DepthPriceScale));
            return false;
        }
        return true;
    }

    public final IMarketConversion getMarket() {
        return this.mMarket;
    }

    public final int getIntervalSize() {
        return this.mIntervalSize;
    }

    public final void setIntervalSize(int value) {
        this.mIntervalSize = value;
    }

    public final Range<Integer> getPlotRange() {
        return this.mPlotRange;
    }

    public final void setPlotRange(Range<Integer> value) {
        this.mPlotRange = value;
    }

    protected final int getScaleCenter() {
        return this.mScaleCenter;
    }

    public final Price getVisCenterPrice() {
        double prcDiff = Math.floor((float)Math.abs(this.mScrollOffset) / (float)this.mIntervalSize) * (double)(this.mScrollOffset < 0 ? -1 : 1);
        BigDecimal priceIncrements = new BigDecimal((double)this.mScaleCenter + prcDiff);
        return Price.fromIncrements(this.mMarket, priceIncrements).round(this.mMarket);
    }

    public final int getVisOffset() {
        return this.mScrollOffset % this.mIntervalSize;
    }

    public boolean updateDepthPrices(DepthSnapshot depth, PositionWorkingOrders working, PriceHighlight priceHighlight, ImpliedPriceType impiedPriceType) {
        return false;
    }

    public int centerOnPrice(Price price) {
        Integer scaleIndex = price.toIncrements(this.mMarket).intValue();
        if (scaleIndex != null) {
            return this.centerOnPriceIncrements(scaleIndex);
        }
        this.mScaleCenter = 0;
        this.mScrollOffset = 0;
        return 0;
    }

    public int centerOnPriceIncrements(int priceIncrements) {
        int scrollAmt = -1 * ((this.mScaleCenter - priceIncrements) * this.mIntervalSize + this.mScrollOffset);
        this.mScaleCenter = priceIncrements;
        this.mScrollOffset = 0;
        return scrollAmt;
    }

    public final void scrollScale(ScrollUnit unit, int amount) {
        switch (unit) {
            case Pixels: {
                this.mScrollOffset += amount;
                break;
            }
            case Rows: {
                this.mScrollOffset += amount * this.mIntervalSize;
                break;
            }
            case Pages: {
                this.mScrollOffset += amount * (this.mPlotRange.end() - this.mPlotRange.start());
            }
        }
    }

    public Range<Price> getVisibleScalePriceRange() {
        return this.getPriceRangeForPlotRange(this.mPlotRange);
    }

    public Range<Price> getPriceRangeForPlotRange(Range<Integer> plotRange) {
        int topIndex = this.getScaleIndexAtPosition(plotRange.start());
        int botIndex = this.getScaleIndexAtPosition(plotRange.end());
        return new Range<Price>(Price.fromIncrements(this.mMarket, botIndex), Price.fromIncrements(this.mMarket, topIndex)).normalized();
    }

    public Range<Integer> getPriceIndexRangeForPlotRange(Range<Integer> plotRange) {
        int topIndex = this.getScaleIndexAtPosition(plotRange.start());
        int botIndex = this.getScaleIndexAtPosition(plotRange.end());
        return new Range<Integer>(botIndex, topIndex).normalized();
    }

    public Integer priceOffset(Price price) {
        if (price != null) {
            Integer priceIndex = price.toIncrements(this.mMarket).intValue();
            return -1 * ((this.mScaleCenter - priceIndex) * this.mIntervalSize + this.mScrollOffset);
        }
        return null;
    }

    public Range<Integer> getPlotRangeForPrice(Price price) {
        if (this.mPlotRange.isEmpty()) {
            Log.e(TAG, "getPlotRangeForPrice(), Plot range not set.");
            return Range.empty();
        }
        Integer pos = this.getIndexPosition(price.toWholeIncrements(this.mMarket));
        if (pos != null) {
            int delta = (int)Math.floor((float)this.mIntervalSize / 2.0f);
            return new Range<Integer>(pos - delta, pos - (this.mIntervalSize + 1) % 2 + delta);
        }
        return Range.empty();
    }

    public Price getPriceAtPosition(int position) {
        if (this.mPlotRange.isEmpty()) {
            Log.e(TAG, "getScaleIndexAtPosition(), Plot range not set.");
            return Price.Zero;
        }
        int plotCenter = (int)Math.ceil((float)(this.mPlotRange.start() + this.mPlotRange.end()) / 2.0f);
        int scaleIndex = this.mScaleCenter + (int)Math.ceil(((double)(plotCenter + this.mScrollOffset - position) - Math.floor((double)this.mIntervalSize / 2.0)) / (double)this.mIntervalSize);
        return this.getPriceForScaleIndex(scaleIndex);
    }

    public int getPriceIncrementsAtPosition(int position) {
        if (this.mPlotRange.isEmpty()) {
            Log.e(TAG, "getScaleIndexAtPosition(), Plot range not set.");
            return 0;
        }
        int plotCenter = (int)Math.ceil((float)(this.mPlotRange.start() + this.mPlotRange.end()) / 2.0f);
        int scaleIndex = this.mScaleCenter + (int)Math.ceil(((double)(plotCenter + this.mScrollOffset - position) - Math.floor((double)this.mIntervalSize / 2.0)) / (double)this.mIntervalSize);
        return this.getPriceIncrementForScaleIndex(scaleIndex);
    }

    protected final void setScaleCenter(int value) {
        this.mScaleCenter = value;
    }

    protected final int getScrollOffset() {
        return this.mScrollOffset;
    }

    protected final void setScrollOffset(int value) {
        this.mScrollOffset = value;
    }

    protected Integer getIndexPosition(Integer scaleIndex) {
        if (this.mPlotRange.isEmpty()) {
            Log.e(TAG, "getIndexPosition(), Plot range not set.");
            return 0;
        }
        if (scaleIndex != null) {
            int plotcenter = (int)Math.ceil((float)(this.mPlotRange.start() + this.mPlotRange.end()) / 2.0f);
            return plotcenter - (scaleIndex - this.mScaleCenter) * this.mIntervalSize + this.mScrollOffset;
        }
        return null;
    }

    protected int getScaleIndexAtPosition(int pos) {
        if (this.mPlotRange.isEmpty()) {
            Log.e(TAG, "getScaleIndexAtPosition(), Plot range not set.");
            return 0;
        }
        int plotCenter = (int)Math.ceil((float)(this.mPlotRange.start() + this.mPlotRange.end()) / 2.0f);
        return this.mScaleCenter + (int)Math.ceil(((double)(plotCenter + this.mScrollOffset - pos) - Math.floor((double)this.mIntervalSize / 2.0)) / (double)this.mIntervalSize);
    }

    private Range<Integer> getPositionRangeForValue(Integer val) {
        if (this.mPlotRange.isEmpty()) {
            Log.e(TAG, "getPositionRangeForValue(), Plot range not set.");
            return Range.empty();
        }
        Integer pos = this.getIndexPosition(val);
        if (pos != null) {
            int delta = (int)Math.floor((float)this.mIntervalSize / 2.0f);
            return new Range<Integer>(pos - delta, pos - (this.mIntervalSize + 1) % 2 + delta);
        }
        return Range.empty();
    }

    public abstract boolean getIsDepthScale();

    public abstract Price getPriceForScaleIndex(int var1);

    public abstract int getPriceIncrementForScaleIndex(int var1);

    public abstract Integer getPriceIndex(Price var1);

    public Range<Integer> getIndexPositionRange(Integer scaleIndex) {
        if (this.mPlotRange.isEmpty()) {
            Log.e(TAG, "getIndexPositionRange(), Plot range not set.");
            return Range.empty();
        }
        Integer pos = this.getIndexPosition(scaleIndex);
        if (pos != null) {
            int delta = (int)Math.floor((float)this.mIntervalSize / 2.0f);
            return new Range<Integer>(pos - delta, pos - (this.mIntervalSize + 1) % 2 + delta);
        }
        return Range.empty();
    }

    public Range<Integer> getPositionRangeForValueRange(Range<Integer> indexRange) {
        if (this.mPlotRange.isEmpty()) {
            Log.e(TAG, "getPositionRangeForValueRange(), Plot range not set.");
            return Range.empty();
        }
        Range<Integer> rng1 = this.getPositionRangeForValue(indexRange.end());
        Range<Integer> rng2 = this.getPositionRangeForValue(indexRange.start());
        return rng1.expanded(rng2);
    }

    public void commitScrollPosition() {
        int centerIndex;
        int dir = this.mScrollOffset < 0 ? -1 : 1;
        this.mScaleCenter = centerIndex = this.mScaleCenter + (int)(Math.floor((float)Math.abs(this.mScrollOffset) / (float)this.mIntervalSize) * (double)dir);
        this.mScrollOffset %= this.mIntervalSize;
    }

    public static enum ScrollUnit {
        Pixels,
        Rows,
        Pages;

    }
}

