/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.contract.ladder.pricescale;

import com.t4login.application.contract.ladder.pricescale.PriceScale;
import com.t4login.definitions.priceconversion.IMarketConversion;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.util.Range;

class LadderPriceScale
extends PriceScale {
    LadderPriceScale(boolean isPlaceHolder, IMarketConversion market, Range<Integer> plotRange, int intervalSize) {
        super(isPlaceHolder, market, plotRange, intervalSize);
    }

    @Override
    public boolean getIsDepthScale() {
        return false;
    }

    @Override
    public Price getPriceForScaleIndex(int scaleIndex) {
        return Price.fromIncrements(this.getMarket(), scaleIndex);
    }

    @Override
    public int getPriceIncrementForScaleIndex(int scaleIndex) {
        return scaleIndex;
    }

    @Override
    public Integer getPriceIndex(Price price) {
        return price.toIncrements(this.getMarket()).intValue();
    }
}

