/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.contract.ladder.pricescale;

import com.t4login.api.PriceVolume;
import com.t4login.api.accounts.PositionWorkingOrders;
import com.t4login.application.contract.ladder.DepthRowChange;
import com.t4login.application.contract.ladder.DepthSnapshot;
import com.t4login.application.contract.ladder.LadderRowData;
import com.t4login.application.contract.ladder.PriceDepth;
import com.t4login.application.contract.ladder.PriceHighlight;
import com.t4login.application.contract.ladder.pricescale.PriceScale;
import com.t4login.definitions.ImpliedPriceType;
import com.t4login.definitions.priceconversion.IMarketConversion;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.util.Range;
import com.t4login.util.ValueCompare;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;

public class DepthPriceScale
extends PriceScale {
    private HashMap<Integer, Price> mScalePrices = new HashMap();
    private HashMap<Price, Integer> mPriceIndexes = new HashMap();

    public DepthPriceScale(boolean isPlaceHolder, IMarketConversion market, Range<Integer> plotRange, int intervalSize) {
        super(isPlaceHolder, market, plotRange, intervalSize);
    }

    @Override
    public boolean getIsDepthScale() {
        return true;
    }

    @Override
    public int centerOnPrice(Price price) {
        Integer scaleIndex = this.getPriceIndex(price);
        int scrollAmt = 0;
        if (scaleIndex != null) {
            scrollAmt = -1 * ((this.getScaleCenter() - scaleIndex) * this.getIntervalSize() + this.getScrollOffset());
            this.setScaleCenter(scaleIndex);
            this.setScrollOffset(0);
        } else if (this.mScalePrices.size() > 0) {
            ArrayList<Price> scalePrices = new ArrayList<Price>(this.mPriceIndexes.keySet());
            Collections.sort(scalePrices);
            Price closestPrice = Price.Zero;
            if (price.compareTo((Price)scalePrices.get(0)) < 0) {
                closestPrice = (Price)scalePrices.get(0);
            } else if (price.compareTo((Price)scalePrices.get(scalePrices.size() - 1)) > 0) {
                closestPrice = (Price)scalePrices.get(scalePrices.size() - 1);
            } else {
                for (int i = 1; i < scalePrices.size(); ++i) {
                    if (price.compareTo((Price)scalePrices.get(i)) >= 0) continue;
                    closestPrice = ((Price)scalePrices.get(i)).subtract(price).compareTo(price.subtract((Price)scalePrices.get(i - 1))) < 0 ? (Price)scalePrices.get(i) : (Price)scalePrices.get(i - 1);
                    break;
                }
            }
            Integer ci = this.mPriceIndexes.get(closestPrice);
            if (ci != null) {
                scrollAmt = -1 * ((this.getScaleCenter() - ci) * this.getIntervalSize() + this.getScrollOffset());
                this.setScaleCenter(ci);
                this.setScaleCenter(0);
            } else {
                scrollAmt = -1 * ((this.getScaleCenter() - 0) * this.getIntervalSize() + this.getScrollOffset());
                this.setScaleCenter(0);
                this.setScrollOffset(0);
            }
        } else {
            scrollAmt = -1 * ((this.getScaleCenter() - 0) * this.getIntervalSize() + this.getScrollOffset());
            this.setScaleCenter(0);
            this.setScaleCenter(0);
        }
        return scrollAmt;
    }

    @Override
    public boolean updateDepthPrices(DepthSnapshot depth, PositionWorkingOrders working, PriceHighlight priceHighlight, ImpliedPriceType impiedPriceType) {
        Object price;
        DepthPrice price2;
        HashMap<Price, Object> prices = new HashMap<Price, Object>();
        for (LadderRowData row : depth.getLadderRows()) {
            Price rowPrice = Price.fromIncrements(this.getMarket(), row.PriceIncrements);
            price2 = new DepthPrice(this, rowPrice);
            price2.TradeableBidVolume = row.getDisplayableBids(impiedPriceType);
            price2.TradeableOfferVolume = row.getDisplayableOffers(impiedPriceType);
            if (price2.TradeableBidVolume > 0) {
                price2.Flags.add(DepthRowChange.Bid);
            }
            if (price2.TradeableOfferVolume > 0) {
                price2.Flags.add(DepthRowChange.Offer);
            }
            if (price2.TradeableBidVolume > 0 || price2.TradeableOfferVolume > 0) {
                prices.put(price2.Price, price2);
                continue;
            }
            if ((row.Flags & 2) != 0) {
                prices.put(price2.Price, price2);
            }
            if ((row.Flags & 4) != 0) {
                prices.put(price2.Price, price2);
            }
            if ((row.Flags & 8) != 0) {
                prices.put(price2.Price, price2);
            }
            if ((row.Flags & 0x10) != 0) {
                prices.put(price2.Price, price2);
            }
            if ((row.Flags & 0x20) == 0) continue;
            prices.put(price2.Price, price2);
        }
        PriceDepth lastTrade = depth.getLastTrade();
        if (!lastTrade.isEmpty() && lastTrade.Volume > 0) {
            price = (DepthPrice)prices.get(lastTrade.Price);
            if (price != null) {
                ((DepthPrice)price).Flags.add(DepthRowChange.Trade);
            } else {
                price = new DepthPrice(this, lastTrade.Price);
                ((DepthPrice)price).Flags.add(DepthRowChange.Trade);
                prices.put(((DepthPrice)price).Price, price);
            }
        }
        if (working != null) {
            for (PriceVolume d : working.getBidVolumes()) {
                price2 = (DepthPrice)prices.get(d.Price);
                if (price2 != null) {
                    price2.Flags.add(DepthRowChange.MyBid);
                    continue;
                }
                price2 = new DepthPrice(this, d.Price);
                price2.Flags.add(DepthRowChange.MyBid);
                prices.put(price2.Price, price2);
            }
            price = working.getOfferVolumes().iterator();
            while (price.hasNext()) {
                PriceVolume d;
                d = (PriceVolume)price.next();
                price2 = (DepthPrice)prices.get(d.Price);
                if (price2 != null) {
                    price2.Flags.add(DepthRowChange.MyOffer);
                    continue;
                }
                price2 = new DepthPrice(this, d.Price);
                price2.Flags.add(DepthRowChange.MyOffer);
                prices.put(price2.Price, price2);
            }
        }
        if (priceHighlight.HighlightBidOffer) {
            if (priceHighlight.BidHighlightPrice != null && (price = (DepthPrice)prices.get(priceHighlight.BidHighlightPrice)) != null) {
                price = new DepthPrice(this, priceHighlight.BidHighlightPrice);
                prices.put(((DepthPrice)price).Price, price);
            }
            if (priceHighlight.OfferHighlightPrice != null && (price = (DepthPrice)prices.get(priceHighlight.OfferHighlightPrice)) != null) {
                price = new DepthPrice(this, priceHighlight.OfferHighlightPrice);
                prices.put(((DepthPrice)price).Price, price);
            }
        }
        HashMap<Integer, Price> prevScalePrices = this.mScalePrices;
        HashMap<Price, Integer> prevPriceIndexes = this.mPriceIndexes;
        this.mScalePrices = new HashMap();
        this.mPriceIndexes = new HashMap();
        ArrayList<DepthPrice> priceList = new ArrayList<DepthPrice>(prices.values());
        this.UpdateDepthPrices(priceList);
        if (prevScalePrices.size() != this.mScalePrices.size() || prevPriceIndexes.size() != this.mPriceIndexes.size()) {
            return true;
        }
        for (Integer idx : this.mScalePrices.keySet()) {
            Price prc = prevScalePrices.get(idx);
            if (prc != null && prc.equals(this.mScalePrices.get(idx))) continue;
            return true;
        }
        for (Price prc : this.mPriceIndexes.keySet()) {
            Integer idx = prevPriceIndexes.get(prc);
            if (idx != null && ValueCompare.Equals(idx, this.mPriceIndexes.get(prc))) continue;
            return true;
        }
        return false;
    }

    private void UpdateDepthPrices(List<DepthPrice> prices) {
        int i;
        Collections.sort(prices, new Comparator<DepthPrice>(this){

            @Override
            public int compare(DepthPrice a, DepthPrice b) {
                return b.Price.compareTo(a.Price);
            }
        });
        int bi = -1;
        int oi = prices.size();
        int bbv = 0;
        int bov = 0;
        int split = prices.size() - 1;
        IndexVolume nbp = this.FindNextBidPrice(prices, bi, bbv);
        bi = nbp.Index;
        bbv = nbp.Volume;
        IndexVolume nop = this.FindNextOfferPrice(prices, oi, bov);
        oi = nop.Index;
        bov = nop.Volume;
        while (bi <= oi && bi < prices.size() && oi >= 0) {
            if (bbv == bov) {
                nbp = this.FindNextBidPrice(prices, bi, bbv);
                bi = nbp.Index;
                bbv = nbp.Volume;
                nop = this.FindNextOfferPrice(prices, oi, bov);
                oi = nop.Index;
                bov = nop.Volume;
                continue;
            }
            if (bbv > bov) {
                bbv -= bov;
                nop = this.FindNextOfferPrice(prices, oi, bov);
                oi = nop.Index;
                bov = nop.Volume;
                continue;
            }
            bov -= bbv;
            nbp = this.FindNextBidPrice(prices, bi, bbv);
            bi = nbp.Index;
            bbv = nbp.Volume;
        }
        split = oi;
        int ti = 0;
        this.mScalePrices.clear();
        this.mPriceIndexes.clear();
        for (i = 0; i < prices.size(); ++i) {
            if (i <= oi || i >= bi || prices.get((int)i).Flags.size() != 1 || !prices.get((int)i).Flags.contains((Object)DepthRowChange.Trade)) continue;
            split = i - 1;
            ti = 1;
            break;
        }
        for (i = 0; i < prices.size(); ++i) {
            int priceIndex;
            if (i <= split) {
                priceIndex = split - i + 1;
                this.mScalePrices.put(priceIndex, prices.get((int)i).Price);
                this.mPriceIndexes.put(prices.get((int)i).Price, priceIndex);
                continue;
            }
            priceIndex = split - i + ti;
            this.mScalePrices.put(priceIndex, prices.get((int)i).Price);
            this.mPriceIndexes.put(prices.get((int)i).Price, priceIndex);
        }
    }

    private IndexVolume FindNextBidPrice(List<DepthPrice> prices, int bi, int bbv) {
        bbv = 0;
        if (bi < prices.size()) {
            do {
                if (++bi >= prices.size() || prices.get((int)bi).TradeableBidVolume <= 0) continue;
                bbv = prices.get((int)bi).TradeableBidVolume;
            } while (bbv == 0 && bi < prices.size());
        }
        return new IndexVolume(bi, bbv);
    }

    private IndexVolume FindNextOfferPrice(List<DepthPrice> prices, int oi, int bov) {
        bov = 0;
        if (oi >= 0) {
            do {
                if (--oi < 0 || prices.get((int)oi).TradeableOfferVolume <= 0) continue;
                bov = prices.get((int)oi).TradeableOfferVolume;
            } while (bov == 0 && oi >= 0);
        }
        return new IndexVolume(oi, bov);
    }

    @Override
    public Price getPriceForScaleIndex(int scaleIndex) {
        return this.mScalePrices.get(scaleIndex);
    }

    @Override
    public int getPriceIncrementForScaleIndex(int scaleIndex) {
        Price price = this.getPriceForScaleIndex(scaleIndex);
        if (price != null) {
            return price.toWholeIncrements(this.getMarket());
        }
        return 0;
    }

    @Override
    public Integer getPriceIndex(Price price) {
        return this.mPriceIndexes.get(price);
    }

    private class DepthPrice {
        public final Price Price;
        public EnumSet<DepthRowChange> Flags = EnumSet.noneOf(DepthRowChange.class);
        public int TradeableBidVolume = 0;
        public int TradeableOfferVolume = 0;

        public DepthPrice(DepthPriceScale depthPriceScale, Price price) {
            this.Price = price;
        }
    }

    public static class IndexVolume {
        public final int Index;
        public final int Volume;

        public IndexVolume(int index, int volume) {
            this.Index = index;
            this.Volume = volume;
        }
    }
}

