/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.contract.ladder;

import com.t4login.Log;
import com.t4login.application.contract.ladder.PriceDepth;
import com.t4login.definitions.priceconversion.Price;
import java.util.Collection;
import java.util.HashMap;

public class WorkingData {
    private static final String TAG = "WorkingData";
    private HashMap<Price, PriceDepth> mWorkingBids = new HashMap();
    private HashMap<Price, PriceDepth> mWorkingOffers = new HashMap();
    private HashMap<Price, Price> mWorkingBidUpdates = new HashMap();
    private HashMap<Price, Price> mWorkingOfferUpdates = new HashMap();
    private WorkingUpdateType mUpdateType;

    public WorkingData() {
        this.mUpdateType = WorkingUpdateType.None;
    }

    public WorkingData(WorkingUpdateType updatetype) {
        this.mUpdateType = updatetype;
    }

    public Collection<PriceDepth> getBids() {
        return this.mWorkingBids.values();
    }

    public Collection<PriceDepth> getOffers() {
        return this.mWorkingOffers.values();
    }

    public void Update(WorkingData update) {
        if (update.mUpdateType == WorkingUpdateType.Refresh) {
            for (Price price : this.mWorkingBids.keySet()) {
                this.mWorkingBidUpdates.put(price, price);
            }
            for (Price price : this.mWorkingOffers.keySet()) {
                this.mWorkingOfferUpdates.put(price, price);
            }
            this.mWorkingBids.clear();
            this.mWorkingOffers.clear();
        }
        for (PriceDepth upbid : update.mWorkingBids.values()) {
            if (upbid.Volume > 0) {
                this.mWorkingBids.put(upbid.Price, upbid);
                this.mWorkingBidUpdates.put(upbid.Price, upbid.Price);
                continue;
            }
            if (!this.mWorkingBids.containsKey(upbid.Price)) continue;
            this.mWorkingBids.remove(upbid.Price);
            this.mWorkingBidUpdates.put(upbid.Price, upbid.Price);
        }
        for (PriceDepth upoffer : update.mWorkingOffers.values()) {
            if (upoffer.Volume > 0) {
                this.mWorkingOffers.put(upoffer.Price, upoffer);
                this.mWorkingOfferUpdates.put(upoffer.Price, upoffer.Price);
                continue;
            }
            if (!this.mWorkingOffers.containsKey(upoffer.Price)) continue;
            this.mWorkingOffers.remove(upoffer.Price);
            this.mWorkingOfferUpdates.put(upoffer.Price, upoffer.Price);
        }
    }

    public void ClearUpdates() {
        this.mWorkingBidUpdates.clear();
        this.mWorkingOfferUpdates.clear();
    }

    public boolean BidUpdated(Integer price) {
        return this.mWorkingBidUpdates.containsKey(price);
    }

    public boolean OfferUpdated(Integer price) {
        return this.mWorkingOfferUpdates.containsKey(price);
    }

    public PriceDepth GetWorkingBids(Integer price) {
        return this.mWorkingBids.get(price);
    }

    public PriceDepth GetWorkingOffers(Integer price) {
        return this.mWorkingOffers.get(price);
    }

    public void Dump() {
        Log.d(TAG, "WorkingData.Dump():  " + String.valueOf((Object)this.mUpdateType));
        for (PriceDepth bid : this.mWorkingBids.values()) {
            Log.d(TAG, "     " + String.valueOf(bid));
        }
        for (PriceDepth offer : this.mWorkingOffers.values()) {
            Log.d(TAG, "     " + String.valueOf(offer));
        }
        for (Price upprc : this.mWorkingBidUpdates.values()) {
            Log.d(TAG, "     * " + String.valueOf(upprc) + " (bid)");
        }
        for (Price upprc : this.mWorkingOfferUpdates.values()) {
            Log.d(TAG, "     * " + String.valueOf(upprc) + " (offer)");
        }
    }

    public static enum WorkingUpdateType {
        None,
        Refresh,
        Update;

    }
}

