/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.contract.ladder;

import com.t4login.Log;
import com.t4login.api.Market;
import com.t4login.application.contract.ladder.DepthRowChange;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.ImpliedPriceType;
import com.t4login.definitions.OrderType;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.util.ValueCompare;
import java.util.EnumSet;
import java.util.Locale;

public final class LadderRowData {
    public static final String TAG = "LadderRowData";
    public static final LadderRowData empty = new LadderRowData(null, Price.Zero, 0);
    private final Market mMarket;
    public final Price RowPrice;
    public final int PriceIncrements;
    public Integer Bids = null;
    public Integer ImpliedBids = null;
    public Integer Offers = null;
    public Integer ImpliedOffers = null;
    public Integer TradeVolume = null;
    public Integer LastTradeVolume = null;
    public NDateTime LastTradeTime = NDateTime.MinValue;
    public int Flags = 0;

    public static EnumSet<DepthRowChange> compareRows(LadderRowData a, LadderRowData b) {
        EnumSet<DepthRowChange> change = EnumSet.noneOf(DepthRowChange.class);
        if (a.isEmpty() || b.isEmpty()) {
            if (a.isEmpty() && b.isEmpty()) {
                return EnumSet.noneOf(DepthRowChange.class);
            }
            return EnumSet.allOf(DepthRowChange.class);
        }
        if (a.PriceIncrements != b.PriceIncrements) {
            Log.e(TAG, "CompareRows(), Row prices are different. a: #" + a.PriceIncrements + ", b: #" + b.PriceIncrements);
            return EnumSet.allOf(DepthRowChange.class);
        }
        int atmp = a.Flags & 0xFFFFFFBF;
        int btmp = b.Flags & 0xFFFFFFBF;
        if (atmp == btmp) {
            change.add(DepthRowChange.Price);
        }
        if (!a.Bids.equals(b.Bids) || !a.ImpliedBids.equals(b.ImpliedBids)) {
            change.add(DepthRowChange.Bid);
        }
        if (!a.Offers.equals(b.Offers) || !a.ImpliedOffers.equals(b.ImpliedOffers)) {
            change.add(DepthRowChange.Offer);
        }
        if ((a.Flags & 1) != 0 != ((b.Flags & 1) != 0) || ValueCompare.Compare(a.TradeVolume, b.TradeVolume) != 0) {
            change.add(DepthRowChange.Trade);
        }
        if (ValueCompare.Compare(a.TradeVolume, b.TradeVolume) != 0) {
            change.add(DepthRowChange.Total);
        }
        return change;
    }

    public LadderRowData(Market market, Price price, int priceIncrements) {
        this.RowPrice = price;
        this.mMarket = market;
        this.PriceIncrements = priceIncrements;
    }

    public String toString() {
        return String.format(Locale.US, "Price: #%d, Displayable Bids: %s, Displayable Offers: %s, BidVolume: %d, OfferVolume: %d", this.RowPrice, this.hasDisplayableBids(ImpliedPriceType.All), this.hasDisplayableOffers(ImpliedPriceType.All), this.getTotalBidVolume(), this.getTotalOfferVolume());
    }

    public boolean isEmpty() {
        return this.Bids == null && this.Offers == null && this.ImpliedBids == null && this.ImpliedOffers == null && this.TradeVolume == null && this.Flags == 0;
    }

    public Market getMarket() {
        return this.mMarket;
    }

    public int getTotalBidVolume() {
        int impbidvol;
        int bidvol = this.Bids != null ? this.Bids : 0;
        int n = impbidvol = this.ImpliedBids != null ? this.ImpliedBids : 0;
        int totalvol = impbidvol > 0 ? bidvol + impbidvol : (bidvol > 0 ? bidvol : Math.abs(impbidvol));
        return totalvol;
    }

    public int getTotalOfferVolume() {
        int impoffervol;
        int offervol = this.Offers != null ? this.Offers : 0;
        int n = impoffervol = this.ImpliedOffers != null ? this.ImpliedOffers : 0;
        int totalvol = impoffervol > 0 ? offervol + impoffervol : (offervol > 0 ? offervol : Math.abs(impoffervol));
        return totalvol;
    }

    public int getDisplayableBids(ImpliedPriceType impliedPriceType) {
        if (this.ImpliedBids != null && (impliedPriceType == ImpliedPriceType.All || this.mMarket != null && this.mMarket.isOrderTypeSupported(OrderType.ImpliedMatching) && impliedPriceType != ImpliedPriceType.None)) {
            return this.getTotalBidVolume();
        }
        return this.Bids != null ? this.Bids : 0;
    }

    public int getDisplayableOffers(ImpliedPriceType impliedPriceType) {
        if (this.ImpliedOffers != null && (impliedPriceType == ImpliedPriceType.All || this.mMarket != null && this.mMarket.isOrderTypeSupported(OrderType.ImpliedMatching) && impliedPriceType != ImpliedPriceType.None)) {
            return this.getTotalOfferVolume();
        }
        return this.Offers != null ? this.Offers : 0;
    }

    public boolean hasDisplayableBids(ImpliedPriceType impliedPriceType) {
        if (this.Bids != null) {
            return true;
        }
        return this.ImpliedBids != null && (impliedPriceType == ImpliedPriceType.All || this.mMarket != null && this.mMarket.isOrderTypeSupported(OrderType.ImpliedMatching) && impliedPriceType != ImpliedPriceType.None);
    }

    public boolean hasDisplayableOffers(ImpliedPriceType impliedPriceType) {
        if (this.Offers != null) {
            return true;
        }
        return this.ImpliedOffers != null && (impliedPriceType == ImpliedPriceType.All || this.mMarket != null && this.mMarket.isOrderTypeSupported(OrderType.ImpliedMatching) && impliedPriceType != ImpliedPriceType.None);
    }
}

