/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.contract.ladder;

import com.t4login.Log;
import com.t4login.application.contract.ladder.GradientDirection;
import com.t4login.application.contract.ladder.LadderColumnId;
import com.t4login.application.contract.ladder.LadderPriceDisplayMode;
import com.t4login.util.Xml;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class LadderProperties {
    private static final String TAG = "LadderProperties";
    public LadderPriceDisplayMode PriceDisplay = LadderPriceDisplayMode.Price;
    public GradientDirection BidColumnGradientDirection = GradientDirection.RightToLeft;
    public GradientDirection OfferColumnGradientDirection = GradientDirection.LefToRight;
    public GradientDirection TotalColumnGradientDirection = GradientDirection.LefToRight;
    public GradientDirection TradeColumnGradientDirection = GradientDirection.LefToRight;
    public GradientDirection HistoryColumnGradientDirection = GradientDirection.LefToRight;
    private List<LadderColumnId> ColumnOrder = new ArrayList<LadderColumnId>();

    private void initColumns() {
        if (this.ColumnOrder.size() == 0) {
            this.ColumnOrder.add(LadderColumnId.Total);
            this.ColumnOrder.add(LadderColumnId.History);
            this.ColumnOrder.add(LadderColumnId.Trade);
            this.ColumnOrder.add(LadderColumnId.MyBid);
            this.ColumnOrder.add(LadderColumnId.Bid);
            this.ColumnOrder.add(LadderColumnId.Price);
            this.ColumnOrder.add(LadderColumnId.Offer);
            this.ColumnOrder.add(LadderColumnId.MyOffer);
        }
    }

    public Iterable<LadderColumnId> getColumnOrder() {
        if (this.ColumnOrder.size() == 0) {
            this.initColumns();
        }
        return this.ColumnOrder;
    }

    public void setColumnOrder(List<LadderColumnId> sortedIDs) {
        if (this.ColumnOrder.size() == 0) {
            this.initColumns();
        }
        for (int i = 0; i < sortedIDs.size(); ++i) {
            LadderColumnId id = sortedIDs.get(i);
            while (this.ColumnOrder.remove((Object)id)) {
            }
            this.ColumnOrder.add(i, id);
        }
    }

    public String toConfigString() {
        if (this.ColumnOrder.size() == 0) {
            this.initColumns();
        }
        XmlSerializer s = Xml.newSerializer();
        StringWriter w = new StringWriter();
        try {
            s.setOutput(w);
            s.startDocument("UTF-8", true);
            s.startTag("", "ladderProperties");
            s.startTag("", "PriceDisplay");
            s.text(this.PriceDisplay.toString());
            s.endTag("", "PriceDisplay");
            s.startTag("", "BidColumnGradientDirection");
            s.text(this.BidColumnGradientDirection.toString());
            s.endTag("", "BidColumnGradientDirection");
            s.startTag("", "OfferColumnGradientDirection");
            s.text(this.OfferColumnGradientDirection.toString());
            s.endTag("", "OfferColumnGradientDirection");
            s.startTag("", "TotalColumnGradientDirection");
            s.text(this.TotalColumnGradientDirection.toString());
            s.endTag("", "TotalColumnGradientDirection");
            s.startTag("", "TradeColumnGradientDirection");
            s.text(this.TradeColumnGradientDirection.toString());
            s.endTag("", "TradeColumnGradientDirection");
            s.startTag("", "HistoryColumnGradientDirection");
            s.text(this.HistoryColumnGradientDirection.toString());
            s.endTag("", "HistoryColumnGradientDirection");
            s.startTag("", "ColumnOrder");
            s.attribute("", "class", "java.util.ArrayList");
            for (LadderColumnId cid : this.ColumnOrder) {
                s.startTag("", "ladderColumnID");
                s.text(cid.toString());
                s.endTag("", "ladderColumnID");
            }
            s.endTag("", "ColumnOrder");
            s.endTag("", "ladderProperties");
            s.endDocument();
        }
        catch (Exception ex) {
            Log.e(TAG, "toConfigString(), Error.", ex);
        }
        return w.toString();
    }

    public void fromConfigString(String config) {
        if (this.ColumnOrder.size() == 0) {
            this.initColumns();
        }
        if (config == null || config.isEmpty()) {
            return;
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(config.getBytes("UTF8"));
            try {
                XmlPullParser parser = Xml.newPullParser();
                parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
                parser.setInput(in, null);
                parser.nextTag();
                parser.require(2, "", "ladderProperties");
                while (parser.next() != 3) {
                    if (parser.getEventType() != 2) continue;
                    String name = parser.getName();
                    if (name.equalsIgnoreCase("PriceDisplay")) {
                        this.PriceDisplay = LadderPriceDisplayMode.valueOf(LadderProperties.readText(parser));
                        continue;
                    }
                    if (name.equalsIgnoreCase("BidColumnGradientDirection")) {
                        this.BidColumnGradientDirection = GradientDirection.valueOf(LadderProperties.readText(parser));
                        continue;
                    }
                    if (name.equalsIgnoreCase("OfferColumnGradientDirection")) {
                        this.OfferColumnGradientDirection = GradientDirection.valueOf(LadderProperties.readText(parser));
                        continue;
                    }
                    if (name.equalsIgnoreCase("TotalColumnGradientDirection")) {
                        this.TotalColumnGradientDirection = GradientDirection.valueOf(LadderProperties.readText(parser));
                        continue;
                    }
                    if (name.equalsIgnoreCase("TradeColumnGradientDirection")) {
                        this.TradeColumnGradientDirection = GradientDirection.valueOf(LadderProperties.readText(parser));
                        continue;
                    }
                    if (name.equalsIgnoreCase("HistoryColumnGradientDirection")) {
                        this.HistoryColumnGradientDirection = GradientDirection.valueOf(LadderProperties.readText(parser));
                        continue;
                    }
                    if (name.equalsIgnoreCase("ColumnOrder")) {
                        ArrayList<LadderColumnId> restoreOrder = new ArrayList<LadderColumnId>();
                        while (parser.next() != 3) {
                            String nm;
                            if (parser.getEventType() != 2 || !(nm = parser.getName()).equalsIgnoreCase("ladderColumnID")) continue;
                            restoreOrder.add(LadderColumnId.valueOf(LadderProperties.readText(parser)));
                        }
                        for (int i = 0; i < restoreOrder.size(); ++i) {
                            LadderColumnId id = (LadderColumnId)((Object)restoreOrder.get(i));
                            this.ColumnOrder.remove((Object)id);
                            this.ColumnOrder.add(i, id);
                        }
                        continue;
                    }
                    Log.e(TAG, "Unexpected config tag: '" + name + "'");
                }
            }
            catch (XmlPullParserException pex) {
                Log.e(TAG, "parseConfigSettings(), Parser error.", pex);
            }
            catch (Exception ex) {
                Log.e(TAG, "parseConfigSettings(), Error.", ex);
            }
        }
        catch (UnsupportedEncodingException encex) {
            Log.e(TAG, "parseConfigSettings(), Encoding error.", encex);
        }
    }

    public static String readText(XmlPullParser parser) throws IOException, XmlPullParserException {
        String result = "";
        int event = parser.next();
        if (event == 4) {
            result = parser.getText();
            parser.nextTag();
        } else if (event == 5) {
            result = parser.getText();
        }
        return result;
    }
}

