/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.contract.ladder;

import com.t4login.Resource;
import java.util.HashMap;
import java.util.Map;

public enum LadderColumnId {
    Total(0, "ladder_column_total"),
    Price(1, "ladder_column_price"),
    History(2, "ladder_column_history"),
    Trade(3, "ladder_column_trade"),
    MyBid(4, "ladder_column_mybid"),
    Bid(5, "ladder_column_bid"),
    Offer(6, "ladder_column_offer"),
    MyOffer(7, "ladder_column_myoffer");

    private final int value;
    private final String descr_loc;
    private static Map<Integer, LadderColumnId> map;

    private LadderColumnId(int value, String descr) {
        this.value = value;
        this.descr_loc = descr;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return Resource.localizeString(this.descr_loc);
    }

    public static LadderColumnId get(int value) {
        return map.get(value);
    }

    public String toString() {
        return this.name();
    }

    static {
        map = new HashMap<Integer, LadderColumnId>();
        for (LadderColumnId t : LadderColumnId.values()) {
            map.put(t.getValue(), t);
        }
    }
}

