/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.contract.ladder;

import com.t4login.api.Market;
import com.t4login.api.MarketDataSnapshot;
import com.t4login.application.settings.AppSettings;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.messages.MsgAccountPosition2;
import com.t4login.util.ValueCompare;
import java.math.BigDecimal;

public final class DepthUpdateArgs {
    public final Market Market;
    public final MarketDataSnapshot MarketDataSnapshot;
    public final AppSettings Settings;
    private final MsgAccountPosition2 mPositionUpdate;
    public final Price AverageFillPrice;
    public final int maxTradeHistory;

    public DepthUpdateArgs(Market market, MarketDataSnapshot marketDataSnapshot, MsgAccountPosition2 positionUpdate, AppSettings settings) {
        this.Market = market;
        this.MarketDataSnapshot = marketDataSnapshot;
        this.Settings = settings;
        this.maxTradeHistory = settings.Contract.MaxTradeHistoryBars;
        this.mPositionUpdate = positionUpdate;
        if (positionUpdate != null) {
            switch (settings.Contract.AverageFillPriceDisplay) {
                case AvgOpenFill: {
                    this.AverageFillPrice = positionUpdate.AverageOpenPrice;
                    break;
                }
                case AvgTotalFill: {
                    BigDecimal net = new BigDecimal(positionUpdate.Buys - positionUpdate.Sells);
                    if (!ValueCompare.Equals(net, BigDecimal.ZERO)) {
                        this.AverageFillPrice = positionUpdate.TotalBuyFillPrice.subtract(positionUpdate.TotalSellFillPrice).divide(net);
                        break;
                    }
                    this.AverageFillPrice = null;
                    break;
                }
                case AvgOpenUntilClosed: {
                    if (positionUpdate.TotalOpenVolume > 0) {
                        this.AverageFillPrice = positionUpdate.TotalOpenPrice.divide(new BigDecimal(positionUpdate.TotalOpenVolume));
                        break;
                    }
                    this.AverageFillPrice = null;
                    break;
                }
                default: {
                    this.AverageFillPrice = null;
                    break;
                }
            }
        } else {
            this.AverageFillPrice = null;
        }
    }

    public int getNetPosition() {
        return this.mPositionUpdate.Buys - this.mPositionUpdate.Sells;
    }

    public String toString() {
        return "Market: " + this.Market.getMarketID();
    }
}

