/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.contract.ladder;

import com.t4login.Log;
import com.t4login.api.Market;
import com.t4login.api.MarketDataSnapshot;
import com.t4login.api.PriceIncrementVolume;
import com.t4login.api.PriceVolume;
import com.t4login.application.contract.ladder.DepthType;
import com.t4login.application.contract.ladder.DepthUpdateArgs;
import com.t4login.application.contract.ladder.LadderRowData;
import com.t4login.application.contract.ladder.PriceDepth;
import com.t4login.application.settings.AppSettings;
import com.t4login.definitions.ImpliedPriceType;
import com.t4login.definitions.MarketMode;
import com.t4login.definitions.priceconversion.IMarketConversion;
import com.t4login.definitions.priceconversion.IPriceFormatArgs;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.definitions.priceconversion.PriceFormat;
import com.t4login.messages.MsgMarketDepthD;
import com.t4login.messages.MsgMarketTradeHistoryD;
import com.t4login.messages.MsgMarketTradeVolumeD;
import com.t4login.util.SparseArray;
import java.math.BigDecimal;
import java.util.List;

public final class DepthSnapshot {
    private static final String TAG = "DepthSnapshot";
    private DepthUpdateArgs mDepthargs;
    private PriceDepth mLastTrade;
    private Price mSettlementPrice;
    private Integer mSettlementPriceIncrements = null;
    private SparseArray<LadderRowData> mPriceData = new SparseArray();
    private Integer mHighPriceIncrements;
    private Integer mLowPriceIncrements;
    private Price mNetChange;
    private BigDecimal mNetChangePercent;
    private String mNetChangeText;
    private PriceVolume mBestBidNoImplied;
    private PriceVolume mBestOfferNoImplied;
    private PriceVolume mBestBid;
    private PriceVolume mBestOffer;
    private Integer mMaxBidOfferVolume = null;
    private int mMaxRowVolume = 0;
    private Price mCenterPrice = null;

    public DepthSnapshot(DepthUpdateArgs e) {
        MsgMarketDepthD.DepthData depth;
        LadderRowData rowData;
        this.mDepthargs = e;
        PriceVolume snapshotBestBid = e.MarketDataSnapshot.bestBid();
        PriceVolume snapshotBestOffer = e.MarketDataSnapshot.bestOffer();
        PriceVolume displayBestBid = e.MarketDataSnapshot.getDisplayBestBid(e.Market, e.Settings.MarketData.ImpliedPriceDisplay);
        PriceVolume displayBestOffer = e.MarketDataSnapshot.getDisplayBestOffer(e.Market, e.Settings.MarketData.ImpliedPriceDisplay);
        this.mBestBidNoImplied = snapshotBestBid.roundDown(e.Market);
        this.mBestOfferNoImplied = snapshotBestOffer.roundUp(e.Market);
        this.mBestBid = displayBestBid.roundDown(e.Market);
        this.mBestOffer = displayBestOffer.roundUp(e.Market);
        PriceVolume lastTrade = e.MarketDataSnapshot.getDisplayLastTrade(e.Settings.MarketData.LastTradeCumulativeVolume, e.Settings.MarketData.LastTradeIncludesSpreads);
        if (lastTrade.Volume > 0) {
            this.mLastTrade = new PriceDepth(DepthType.LastTrade, lastTrade.Price.roundDown(e.Market), lastTrade.Volume);
            if (!this.mLastTrade.isEmpty()) {
                int lastTradePriceIncrements = this.mLastTrade.Price.toWholeIncrements(e.Market);
                Object rowData2 = this.mPriceData.get(lastTradePriceIncrements);
                if (rowData2 != null) {
                    ((LadderRowData)rowData2).LastTradeVolume = this.mLastTrade.Volume;
                    ((LadderRowData)rowData2).Flags |= 1;
                } else {
                    rowData2 = new LadderRowData(e.Market, this.mLastTrade.Price.roundDown(e.Market), lastTradePriceIncrements);
                    this.mPriceData.put(lastTradePriceIncrements, (LadderRowData)rowData2);
                    ((LadderRowData)rowData2).LastTradeVolume = this.mLastTrade.Volume;
                    ((LadderRowData)rowData2).Flags |= 1;
                }
            }
        } else {
            this.mLastTrade = new PriceDepth(DepthType.LastTrade, null, 0);
        }
        this.mSettlementPrice = e.MarketDataSnapshot.getDisplaySettlement(e.Settings.MarketData.UseHeldSettlement);
        if (this.mSettlementPrice != null) {
            this.mSettlementPriceIncrements = this.mSettlementPrice.toWholeIncrements(e.Market, Price.RoundingDirection.Down);
        }
        if (this.mSettlementPriceIncrements != null) {
            LadderRowData rowData3 = this.mPriceData.get(this.mSettlementPriceIncrements);
            if (rowData3 != null) {
                rowData3.Flags |= 2;
            } else {
                rowData3 = new LadderRowData(e.Market, this.mSettlementPrice.roundDown(e.Market), this.mSettlementPriceIncrements);
                this.mPriceData.put(this.mSettlementPriceIncrements, rowData3);
                rowData3.Flags |= 2;
            }
        }
        Integer n = this.mHighPriceIncrements = e.MarketDataSnapshot.getHighPrice() != null ? Integer.valueOf(e.MarketDataSnapshot.getHighPrice().toWholeIncrements(e.Market, Price.RoundingDirection.Down)) : null;
        if (this.mHighPriceIncrements != null) {
            LadderRowData rowData4 = this.mPriceData.get(this.mHighPriceIncrements);
            if (rowData4 != null) {
                rowData4.Flags |= 4;
            } else {
                rowData4 = new LadderRowData(e.Market, e.MarketDataSnapshot.getHighPrice().roundDown(e.Market), this.mHighPriceIncrements);
                this.mPriceData.put(this.mHighPriceIncrements, rowData4);
                rowData4.Flags |= 4;
            }
        }
        Integer n2 = this.mLowPriceIncrements = e.MarketDataSnapshot.getLowPrice() != null ? Integer.valueOf(e.MarketDataSnapshot.getLowPrice().toWholeIncrements(e.Market, Price.RoundingDirection.Up)) : null;
        if (this.mLowPriceIncrements != null) {
            LadderRowData rowData5 = this.mPriceData.get(this.mLowPriceIncrements);
            if (rowData5 != null) {
                rowData5.Flags |= 8;
            } else {
                rowData5 = new LadderRowData(e.Market, e.MarketDataSnapshot.getLowPrice().roundUp(e.Market), this.mLowPriceIncrements);
                this.mPriceData.put(this.mLowPriceIncrements, rowData5);
                rowData5.Flags |= 8;
            }
        }
        this.mNetChange = e.MarketDataSnapshot.getNetChange(e.Settings.MarketData.LastTradeIncludesSpreads, e.Settings.MarketData.UseHeldSettlement);
        this.mNetChangePercent = e.MarketDataSnapshot.getNetChangePercent(e.Settings.MarketData.LastTradeIncludesSpreads, e.Settings.MarketData.UseHeldSettlement);
        if (e.MarketDataSnapshot.tradeVolumeMessage() != null) {
            MsgMarketTradeVolumeD volMsg = e.MarketDataSnapshot.tradeVolumeMessage();
            for (MsgMarketTradeVolumeD.TradeVolume vol : volMsg.Volume) {
                int volPriceIncrements = vol.Price.toWholeIncrements(e.Market, Price.RoundingDirection.Down);
                rowData = this.mPriceData.get(volPriceIncrements);
                this.mMaxRowVolume = Math.max(this.mMaxRowVolume, vol.Volume);
                if (rowData != null) {
                    rowData.TradeVolume = vol.Volume;
                    rowData.LastTradeTime = vol.Time;
                    continue;
                }
                rowData = new LadderRowData(e.Market, vol.Price, volPriceIncrements);
                this.mPriceData.put(volPriceIncrements, rowData);
                rowData.TradeVolume = vol.Volume;
                rowData.LastTradeTime = vol.Time;
            }
        }
        if ((depth = e.MarketDataSnapshot.marketDepthMessage().Depth) != null) {
            for (MsgMarketDepthD.DepthLine d : depth.Bids) {
                PriceIncrementVolume bid = new PriceIncrementVolume(d.Price.toWholeIncrements(e.Market, Price.RoundingDirection.Down), d.Volume);
                rowData = this.mPriceData.get(bid.PriceIncrements);
                if (rowData != null) {
                    rowData.Bids = bid.Volume;
                    continue;
                }
                rowData = new LadderRowData(e.Market, d.Price.roundDown(e.Market), bid.PriceIncrements);
                this.mPriceData.put(bid.PriceIncrements, rowData);
                rowData.Bids = bid.Volume;
            }
            for (MsgMarketDepthD.DepthLine d : depth.Offers) {
                PriceIncrementVolume offer = new PriceIncrementVolume(d.Price.toWholeIncrements(e.Market, Price.RoundingDirection.Up), d.Volume);
                rowData = this.mPriceData.get(offer.PriceIncrements);
                if (rowData != null) {
                    rowData.Offers = offer.Volume;
                    continue;
                }
                rowData = new LadderRowData(e.Market, d.Price.roundUp(e.Market), offer.PriceIncrements);
                this.mPriceData.put(offer.PriceIncrements, rowData);
                rowData.Offers = offer.Volume;
            }
            for (MsgMarketDepthD.DepthLine d : depth.ImpliedBids) {
                PriceIncrementVolume impliedBid = new PriceIncrementVolume(d.Price.toWholeIncrements(e.Market, Price.RoundingDirection.Down), d.Volume);
                rowData = this.mPriceData.get(impliedBid.PriceIncrements);
                if (rowData != null) {
                    rowData.ImpliedBids = impliedBid.Volume;
                    continue;
                }
                rowData = new LadderRowData(e.Market, d.Price.roundDown(e.Market), impliedBid.PriceIncrements);
                this.mPriceData.put(impliedBid.PriceIncrements, rowData);
                rowData.ImpliedBids = impliedBid.Volume;
            }
            for (MsgMarketDepthD.DepthLine d : depth.ImpliedOffers) {
                PriceIncrementVolume impliedOffer = new PriceIncrementVolume(d.Price.toWholeIncrements(e.Market, Price.RoundingDirection.Up), d.Volume);
                rowData = this.mPriceData.get(impliedOffer.PriceIncrements);
                if (rowData != null) {
                    rowData.ImpliedOffers = impliedOffer.Volume;
                    continue;
                }
                rowData = new LadderRowData(e.Market, d.Price.roundUp(e.Market), impliedOffer.PriceIncrements);
                this.mPriceData.put(impliedOffer.PriceIncrements, rowData);
                rowData.ImpliedOffers = impliedOffer.Volume;
            }
        }
        if (e.AverageFillPrice != null) {
            int addFlag = 0;
            if (e.getNetPosition() > 0) {
                addFlag = 16;
            } else if (e.getNetPosition() < 0) {
                addFlag = 32;
            }
            if (addFlag != 0) {
                Price avgFillRounded = e.AverageFillPrice.roundToNearest(e.Market);
                int avgFillPriceIncrements = avgFillRounded.toWholeIncrements(e.Market, Price.RoundingDirection.Down);
                rowData = this.mPriceData.get(avgFillPriceIncrements);
                if (rowData != null) {
                    rowData.Flags |= addFlag;
                } else {
                    rowData = new LadderRowData(e.Market, avgFillRounded, avgFillPriceIncrements);
                    this.mPriceData.put(avgFillPriceIncrements, rowData);
                    rowData.Flags |= addFlag;
                }
            }
        }
    }

    public DepthUpdateArgs getArgs() {
        return this.mDepthargs;
    }

    public Market getMarket() {
        return this.mDepthargs.Market;
    }

    public MarketMode getMarketMode() {
        return this.mDepthargs.MarketDataSnapshot.getMarketMode();
    }

    public PriceVolume getBestBid() {
        return this.mBestBid;
    }

    public PriceVolume getBestOffer() {
        return this.mBestOffer;
    }

    public PriceDepth getLastTrade() {
        return this.mLastTrade;
    }

    public Integer getHighPriceIncrements() {
        return this.mHighPriceIncrements;
    }

    public Integer getLowPriceIncrements() {
        return this.mLowPriceIncrements;
    }

    public Integer getSettlementPriceIncrements() {
        return this.mSettlementPriceIncrements;
    }

    public List<MsgMarketTradeHistoryD.TradeHistory> getTradeHistory() {
        return this.mDepthargs.MarketDataSnapshot.tradeHistoryMessage().History;
    }

    public Price getNetChange() {
        return this.mNetChange;
    }

    public BigDecimal getNetChangePercent() {
        return this.mNetChangePercent;
    }

    public String getNetChangeDisplay() {
        if (this.mNetChangeText == null) {
            if (this.mNetChange != null) {
                this.mNetChangeText = PriceFormat.convertPriceToDisplayFormat(this.mNetChange, (IPriceFormatArgs)this.mDepthargs.Market, AppSettings.instance.MarketData.PriceDisplay);
                if (this.mNetChange.compareTo(Price.Zero) > 0) {
                    this.mNetChangeText = "+" + this.mNetChangeText;
                }
                return this.mNetChangeText;
            }
            return "";
        }
        return this.mNetChangeText;
    }

    public String getNetChangePercentDisplay() {
        if (this.mNetChangeText == null) {
            if (this.mNetChangePercent != null) {
                this.mNetChangeText = String.format("%01.2f%%", this.mNetChangePercent);
                if (this.mNetChangePercent.compareTo(BigDecimal.ZERO) > 0) {
                    this.mNetChangeText = "+" + this.mNetChangeText;
                }
                return this.mNetChangeText;
            }
            return "";
        }
        return this.mNetChangeText;
    }

    public Iterable<LadderRowData> getLadderRows() {
        return this.mPriceData;
    }

    public LadderRowData getLadderRowAtPriceIncrement(int priceIncrement) {
        LadderRowData rowData = this.mPriceData.get(priceIncrement);
        if (rowData != null) {
            return rowData;
        }
        return new LadderRowData(this.mDepthargs.Market, Price.fromIncrements((IMarketConversion)this.mDepthargs.Market, priceIncrement), priceIncrement);
    }

    public Price getHighPriceLimit() {
        return this.mDepthargs.MarketDataSnapshot.getHighPriceLimit();
    }

    public Price getLowPriceLimit() {
        return this.mDepthargs.MarketDataSnapshot.getLowPriceLimit();
    }

    public int getMaximalBidOfferVolume(ImpliedPriceType impliedPriceType) {
        if (this.mMaxBidOfferVolume == null) {
            int max = 0;
            for (LadderRowData row : this.mPriceData) {
                max = Math.max(max, row.getDisplayableBids(impliedPriceType));
                max = Math.max(max, row.getDisplayableOffers(impliedPriceType));
            }
            this.mMaxBidOfferVolume = max;
            return max;
        }
        return this.mMaxBidOfferVolume;
    }

    public int getMaximalRowVolume() {
        return this.mMaxRowVolume;
    }

    public MarketDataSnapshot getMarketDataSnapshot() {
        return this.mDepthargs.MarketDataSnapshot;
    }

    public Price getCenterPrice() {
        return this.getCenterPrice(false);
    }

    public Price getCenterPrice(boolean recalc) {
        block14: {
            if (recalc) {
                this.mCenterPrice = null;
            }
            if (this.mCenterPrice == null) {
                try {
                    if (this.mBestBid.Volume > 0 && this.mBestOffer.Volume > 0) {
                        this.mCenterPrice = this.mDepthargs.MarketDataSnapshot.getMarketMode() == MarketMode.PreOpen || this.mBestBid.Price.compareTo(this.mBestOffer.Price) > 0 ? (!this.mLastTrade.isEmpty() ? this.mLastTrade.Price : (this.mBestBidNoImplied.Volume > 0 && this.mBestOfferNoImplied.Volume > 0 ? this.mBestBidNoImplied.Price.add(this.mBestOfferNoImplied.Price).divide(2.0).roundDown(this.mDepthargs.Market) : this.mBestBid.Price.add(this.mBestOffer.Price).divide(2.0).roundDown(this.mDepthargs.Market))) : this.mBestBid.Price.add(this.mBestOffer.Price).divide(2.0).roundDown(this.mDepthargs.Market);
                    } else if (this.mBestBid.Volume > 0) {
                        this.mCenterPrice = this.mBestBid.Price;
                    } else if (this.mBestOffer.Volume > 0) {
                        this.mCenterPrice = this.mBestOffer.Price;
                    } else if (!this.mLastTrade.isEmpty()) {
                        this.mCenterPrice = this.mLastTrade.Price;
                    } else if (this.mSettlementPrice != null) {
                        this.mCenterPrice = this.mSettlementPrice;
                    }
                }
                catch (Exception ex) {
                    Log.e(TAG, "getCenterPrice(), Error computing center price.", ex);
                    if (!this.mLastTrade.isEmpty()) {
                        this.mCenterPrice = this.mLastTrade.Price;
                    }
                    if (this.mSettlementPrice == null) break block14;
                    this.mCenterPrice = this.mSettlementPrice;
                }
            }
        }
        return this.mCenterPrice;
    }
}

