/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.configuration.serialization;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlSerializer;

public class XmlSerializerDelayedWrapper
implements XmlSerializer {
    private final XmlSerializer mSer;
    private final List<DelayTag> mDelayedTags = new ArrayList<DelayTag>();

    public XmlSerializerDelayedWrapper(XmlSerializer serializer) {
        this.mSer = serializer;
    }

    public XmlSerializer delayStartTag(String namespace, String name) throws IOException, IllegalArgumentException, IllegalStateException {
        this.mDelayedTags.add(new DelayTag(namespace, name));
        return this;
    }

    public XmlSerializer delayAttribute(String namespace, String name, String value) throws IOException, IllegalArgumentException, IllegalStateException {
        if (this.mDelayedTags.size() > 0) {
            this.mDelayedTags.get((int)(this.mDelayedTags.size() - 1)).delayedAttributes.add(new DelayAttribute(namespace, name, value));
        } else {
            this.mSer.attribute(namespace, name, value);
        }
        return this;
    }

    private void cancelDelayedTag() {
        if (this.mDelayedTags.size() > 0) {
            this.mDelayedTags.remove(this.mDelayedTags.size() - 1);
        }
    }

    private void writeDelayedTags() throws IOException, IllegalArgumentException, IllegalStateException {
        for (DelayTag tag : this.mDelayedTags) {
            this.mSer.startTag(tag.namespace, tag.name);
            for (DelayAttribute attr : tag.delayedAttributes) {
                this.mSer.attribute(attr.namespace, attr.name, attr.value);
            }
        }
        this.mDelayedTags.clear();
    }

    @Override
    public void setFeature(String name, boolean state) throws IllegalArgumentException, IllegalStateException {
        this.mSer.setFeature(name, state);
    }

    @Override
    public boolean getFeature(String name) {
        return this.mSer.getFeature(name);
    }

    @Override
    public void setProperty(String name, Object value) throws IllegalArgumentException, IllegalStateException {
        this.mSer.setProperty(name, value);
    }

    @Override
    public Object getProperty(String name) {
        return this.mSer.getProperty(name);
    }

    @Override
    public void setOutput(OutputStream os, String encoding) throws IOException, IllegalArgumentException, IllegalStateException {
        this.mSer.setOutput(os, encoding);
    }

    @Override
    public void setOutput(Writer writer) throws IOException, IllegalArgumentException, IllegalStateException {
        this.mSer.setOutput(writer);
    }

    @Override
    public void startDocument(String encoding, Boolean standalone) throws IOException, IllegalArgumentException, IllegalStateException {
        this.mSer.startDocument(encoding, standalone);
    }

    @Override
    public void endDocument() throws IOException, IllegalArgumentException, IllegalStateException {
        this.mSer.endDocument();
    }

    @Override
    public void setPrefix(String prefix, String namespace) throws IOException, IllegalArgumentException, IllegalStateException {
        this.mSer.setProperty(prefix, namespace);
    }

    @Override
    public String getPrefix(String namespace, boolean generatePrefix) throws IllegalArgumentException {
        return this.mSer.getPrefix(namespace, generatePrefix);
    }

    @Override
    public int getDepth() {
        return this.mSer.getDepth();
    }

    @Override
    public String getNamespace() {
        if (this.mDelayedTags.size() > 0) {
            return this.mDelayedTags.get((int)(this.mDelayedTags.size() - 1)).namespace;
        }
        return this.mSer.getNamespace();
    }

    @Override
    public String getName() {
        if (this.mDelayedTags.size() > 0) {
            return this.mDelayedTags.get((int)(this.mDelayedTags.size() - 1)).name;
        }
        return this.mSer.getName();
    }

    @Override
    public XmlSerializer startTag(String namespace, String name) throws IOException, IllegalArgumentException, IllegalStateException {
        this.writeDelayedTags();
        return this.mSer.startTag(namespace, name);
    }

    @Override
    public XmlSerializer attribute(String namespace, String name, String value) throws IOException, IllegalArgumentException, IllegalStateException {
        this.writeDelayedTags();
        return this.mSer.attribute(namespace, name, value);
    }

    @Override
    public XmlSerializer endTag(String namespace, String name) throws IOException, IllegalArgumentException, IllegalStateException {
        if (this.mDelayedTags.size() > 0) {
            this.cancelDelayedTag();
            return this;
        }
        return this.mSer.endTag(namespace, name);
    }

    @Override
    public XmlSerializer text(String text) throws IOException, IllegalArgumentException, IllegalStateException {
        this.writeDelayedTags();
        return this.mSer.text(text);
    }

    @Override
    public XmlSerializer text(char[] buf, int start, int len) throws IOException, IllegalArgumentException, IllegalStateException {
        this.writeDelayedTags();
        return this.mSer.text(buf, start, len);
    }

    @Override
    public void cdsect(String text) throws IOException, IllegalArgumentException, IllegalStateException {
        this.writeDelayedTags();
        this.mSer.cdsect(text);
    }

    @Override
    public void entityRef(String text) throws IOException, IllegalArgumentException, IllegalStateException {
        this.mSer.entityRef(text);
    }

    @Override
    public void processingInstruction(String text) throws IOException, IllegalArgumentException, IllegalStateException {
        this.mSer.processingInstruction(text);
    }

    @Override
    public void comment(String text) throws IOException, IllegalArgumentException, IllegalStateException {
        this.writeDelayedTags();
        this.mSer.comment(text);
    }

    @Override
    public void docdecl(String text) throws IOException, IllegalArgumentException, IllegalStateException {
        this.mSer.docdecl(text);
    }

    @Override
    public void ignorableWhitespace(String text) throws IOException, IllegalArgumentException, IllegalStateException {
        this.mSer.ignorableWhitespace(text);
    }

    @Override
    public void flush() throws IOException {
        this.writeDelayedTags();
        this.mSer.flush();
    }

    private static class DelayTag {
        public final String namespace;
        public final String name;
        public final List<DelayAttribute> delayedAttributes = new ArrayList<DelayAttribute>();

        public DelayTag(String namespace, String name) {
            this.namespace = namespace;
            this.name = name;
        }
    }

    private static class DelayAttribute {
        public final String namespace;
        public final String name;
        public final String value;

        public DelayAttribute(String namespace, String name, String value) {
            this.namespace = namespace;
            this.name = name;
            this.value = value;
        }
    }
}

