/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.configuration.serialization;

import com.t4login.Host;
import com.t4login.Log;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.IncludeConfig;
import com.t4login.application.configuration.IncludeConfigs;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.RequiresAndroidSDKVersion;
import com.t4login.application.configuration.SaveConfig;
import com.t4login.application.configuration.Serialize;
import com.t4login.application.configuration.serialization.AnnotatedField;
import com.t4login.application.configuration.serialization.ConfigReader;
import com.t4login.application.configuration.serialization.ConfigSerializer;
import com.t4login.util.SortUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class ConfigUtil {
    private static final String TAG = "ConfigUtil";

    private ConfigUtil() {
    }

    public static List<AnnotatedField> extractAndSortFields(Configurable config) {
        Field[] configFields = config.getClass().getDeclaredFields();
        ArrayList<AnnotatedField> fields = new ArrayList<AnnotatedField>();
        for (Field f : configFields) {
            AnnotatedField af = AnnotatedField.getAnnotatedField(f);
            if (af == null) continue;
            boolean ommit = false;
            RequiresAndroidSDKVersion reqSDK = f.getAnnotation(RequiresAndroidSDKVersion.class);
            if (reqSDK != null) {
                int sdkVer = Host.getSDKVersion();
                if (reqSDK.equalOrGreaterThan() > 0 && sdkVer < reqSDK.equalOrGreaterThan()) {
                    ommit = true;
                }
                if (reqSDK.equalOrLessThan() > 0 && sdkVer > reqSDK.equalOrLessThan()) {
                    ommit = true;
                }
            }
            if (ommit) continue;
            fields.add(af);
        }
        Collections.sort(fields, new Comparator<AnnotatedField>(){

            @Override
            public int compare(AnnotatedField f1, AnnotatedField f2) {
                return SortUtil.compare(f1.SortIdx, f2.SortIdx);
            }
        });
        return fields;
    }

    public static void resetToDefaults(Configurable c) {
        ConfigUtil.resetToDefaults(c, "");
    }

    private static void resetToDefaults(Configurable c, String includeDefaults) {
        try {
            List<AnnotatedField> fields = ConfigUtil.extractAndSortFields(c);
            Map<String, String> fieldDefaults = ConfigSerializer.extractIncludeDefaults(includeDefaults);
            for (AnnotatedField f : fields) {
                if (f.Annotation instanceof PropertyConfig) {
                    DefaultValue d = f.Field.getAnnotation(DefaultValue.class);
                    String defaultVal = null;
                    if (fieldDefaults.containsKey(f.Field.getName())) {
                        defaultVal = fieldDefaults.get(f.Field.getName());
                    }
                    if ((defaultVal == null || defaultVal.isEmpty()) && d != null) {
                        defaultVal = d.value();
                    }
                    Serialize.As as = Serialize.As.None;
                    Serialize z = f.Field.getAnnotation(Serialize.class);
                    if (z != null) {
                        as = z.value();
                    }
                    if (defaultVal == null || Modifier.isFinal(f.Field.getModifiers())) continue;
                    Object fieldValue = ConfigReader.getSettingValue(defaultVal, f.Field, as);
                    f.Field.set(c, fieldValue);
                    continue;
                }
                if (f.Annotation instanceof IncludeConfig) {
                    Object cval = f.Field.get(c);
                    DefaultValue d = f.Field.getAnnotation(DefaultValue.class);
                    if (!(cval instanceof Configurable)) continue;
                    ConfigUtil.resetToDefaults((Configurable)cval, d != null ? d.value() : "");
                    continue;
                }
                if (f.Annotation instanceof IncludeConfigs) {
                    Object arr = f.Field.get(c);
                    if (f.Field.getType().isArray()) {
                        int len = Array.getLength(arr);
                        for (int i = 0; i < len; ++i) {
                            Object item = Array.get(arr, i);
                            if (!(item instanceof Configurable)) continue;
                            ConfigUtil.resetToDefaults((Configurable)item, "");
                        }
                        continue;
                    }
                    if (!(arr instanceof List)) continue;
                    for (Object item : (List)arr) {
                        if (!(item instanceof Configurable)) continue;
                        ConfigUtil.resetToDefaults((Configurable)item, "");
                    }
                    continue;
                }
                if (!(f.Annotation instanceof SaveConfig)) continue;
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "resetToDefaults(), Error resetting configurable: " + String.valueOf(ex));
        }
    }
}

