/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.configuration.serialization;

import com.t4login.Log;
import com.t4login.application.ConfigContext;
import com.t4login.application.chart.BarInterval;
import com.t4login.application.chart.SessionTime;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.IncludeConfig;
import com.t4login.application.configuration.IncludeConfigs;
import com.t4login.application.configuration.MaintainUID;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.SaveConfig;
import com.t4login.application.configuration.Serialize;
import com.t4login.application.configuration.serialization.AnnotatedField;
import com.t4login.application.configuration.serialization.ConfigUtil;
import com.t4login.application.configuration.serialization.XmlSerializerDelayedWrapper;
import com.t4login.util.TextUtils;
import com.t4login.util.Xml;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigSerializer {
    private static final String TAG = "ConfigSerializer";
    private ConfigContext configContext;

    public ConfigSerializer(ConfigContext ccontext) {
        this.configContext = ccontext;
    }

    public String serializeConfigSettings(Configurable config, String element) {
        XmlSerializerDelayedWrapper s = new XmlSerializerDelayedWrapper(Xml.newSerializer());
        StringWriter w = new StringWriter();
        try {
            s.setOutput(w);
            s.startDocument("UTF-8", true);
            this.serializeConfigSettings(s, config, element, false);
            s.endDocument();
        }
        catch (Exception ex) {
            Log.e(TAG, "serializeConfigSettings(), Error serializing configurable: " + String.valueOf(ex));
        }
        return w.toString();
    }

    public void serializeConfigSettings(XmlSerializerDelayedWrapper s, Configurable c, String element, boolean ommitIfEmpty) {
        this.serializeConfigSettings(s, c, element, ommitIfEmpty, "");
    }

    private void serializeConfigSettings(XmlSerializerDelayedWrapper s, Configurable c, String element, boolean ommitIfEmpty, String includeDefaults) {
        try {
            MaintainUID keepUID = c.getClass().getAnnotation(MaintainUID.class);
            if (ommitIfEmpty) {
                s.delayStartTag("", element);
                s.delayAttribute("", "cid", c.configID());
                if (keepUID != null) {
                    s.delayAttribute("", "uid", c.uid);
                }
            } else {
                s.startTag("", element);
                s.attribute("", "cid", c.configID());
                if (keepUID != null) {
                    s.attribute("", "uid", c.uid);
                }
            }
            List<AnnotatedField> fields = ConfigUtil.extractAndSortFields(c);
            Map<String, String> fieldDefaults = ConfigSerializer.extractIncludeDefaults(includeDefaults);
            for (AnnotatedField f : fields) {
                try {
                    if (f.Annotation instanceof PropertyConfig) {
                        DefaultValue d = f.Field.getAnnotation(DefaultValue.class);
                        String defaultVal = "";
                        if (fieldDefaults.containsKey(f.Field.getName())) {
                            defaultVal = fieldDefaults.get(f.Field.getName());
                        }
                        if (defaultVal.isEmpty()) {
                            defaultVal = d != null ? d.value() : "";
                        }
                        Serialize.As as = Serialize.As.None;
                        Serialize z = f.Field.getAnnotation(Serialize.class);
                        if (z != null) {
                            as = z.value();
                        }
                        String pname = f.Field.getName();
                        String pvalue = "";
                        Class<?> t = f.Field.getType();
                        try {
                            if (t.isEnum()) {
                                pvalue = ((Enum)f.Field.get(c)).name();
                            } else if (t.equals(EnumSet.class)) {
                                EnumSet v = (EnumSet)f.Field.get(c);
                                ArrayList<String> enVals = new ArrayList<String>();
                                for (Object enVal : v) {
                                    enVals.add(enVal.toString());
                                }
                                pvalue = TextUtils.join((CharSequence)";", enVals);
                            } else if (t.equals(Boolean.TYPE)) {
                                pvalue = Boolean.toString(f.Field.getBoolean(c));
                            } else if (t.equals(Integer.TYPE) && as == Serialize.As.Color) {
                                pvalue = String.format("#%06X", 0xFFFFFF & f.Field.getInt(c));
                            } else if (t.equals(Integer.TYPE)) {
                                pvalue = Integer.toString(f.Field.getInt(c));
                            } else if (t.equals(Long.TYPE)) {
                                pvalue = Long.toString(f.Field.getLong(c));
                            } else if (t.equals(Float.TYPE)) {
                                pvalue = Float.toString(f.Field.getFloat(c));
                            } else if (t.equals(String.class)) {
                                pvalue = f.Field.get(c).toString();
                            } else if (t.equals(BarInterval.class)) {
                                BarInterval intvl = (BarInterval)f.Field.get(c);
                                pvalue = BarInterval.toSerializationString(intvl);
                            } else if (t.equals(SessionTime.class)) {
                                SessionTime sess = (SessionTime)f.Field.get(c);
                                pvalue = sess.toString();
                            }
                        }
                        catch (IllegalAccessException illacex) {
                            Log.e(TAG, "serializeConfigSettings(), Unable to retrieve value of field '" + c.getClass().getName() + "." + f.Field.getName() + "'");
                            pname = "";
                        }
                        if (pname.isEmpty() || pvalue.equals(defaultVal)) continue;
                        s.attribute("", pname, pvalue);
                        continue;
                    }
                    if (f.Annotation instanceof IncludeConfig) {
                        Object cval = f.Field.get(c);
                        DefaultValue d = f.Field.getAnnotation(DefaultValue.class);
                        if (!(cval instanceof Configurable)) continue;
                        this.serializeConfigSettings(s, (Configurable)cval, f.Field.getName(), true, d != null ? d.value() : "");
                        continue;
                    }
                    if (f.Annotation instanceof IncludeConfigs) {
                        IncludeConfigs incls = (IncludeConfigs)f.Annotation;
                        String incName = f.Field.getName();
                        Object arr = f.Field.get(c);
                        if (f.Field.getType().isArray()) {
                            int len = Array.getLength(arr);
                            if (len <= 0) continue;
                            s.startTag("", incName);
                            for (int i = 0; i < len; ++i) {
                                Object item = Array.get(arr, i);
                                if (!(item instanceof Configurable)) continue;
                                this.serializeConfigSettings(s, (Configurable)item, incls.as(), false, "");
                            }
                            s.endTag("", incName);
                            continue;
                        }
                        if (!(arr instanceof List)) continue;
                        s.startTag("", incName);
                        for (Object item : (List)arr) {
                            if (!(item instanceof Configurable)) continue;
                            this.serializeConfigSettings(s, (Configurable)item, incls.as(), false, "");
                        }
                        s.endTag("", incName);
                        continue;
                    }
                    if (!(f.Annotation instanceof SaveConfig)) continue;
                    String pname = f.Field.getName();
                    Class<?> t = f.Field.getType();
                    Object fval = f.Field.get(c);
                    if (!(fval instanceof Map)) continue;
                    Map map = (Map)fval;
                    s.startTag("", pname);
                    for (Map.Entry entry : map.entrySet()) {
                        s.startTag("", "Entry");
                        s.attribute("", "key", (String)entry.getKey());
                        s.attribute("", "value", (String)entry.getValue());
                        s.endTag("", "Entry");
                    }
                    s.endTag("", pname);
                }
                catch (Exception ex) {
                    Log.e(TAG, "serializeConfigSettings(), Error serializing field (element: " + element + ", field: " + f.Field.getName() + "): " + String.valueOf(ex));
                }
            }
            s.endTag("", element);
        }
        catch (Exception ex) {
            Log.e(TAG, "serializeConfigSettings(), Error serializing configurable (" + c.configurableName() + ", element: " + element + "): " + String.valueOf(ex));
        }
    }

    public static Map<String, String> extractIncludeDefaults(String d) {
        String[] parts;
        HashMap<String, String> extracted = new HashMap<String, String>();
        for (String part : parts = d.split(",")) {
            String[] dparts = part.split("=");
            if (dparts.length != 2) continue;
            extracted.put(dparts[0], dparts[1]);
        }
        return extracted;
    }
}

