/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.configuration.serialization;

import com.t4login.Log;
import com.t4login.application.ConfigContext;
import com.t4login.application.chart.BarInterval;
import com.t4login.application.chart.SessionTime;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.IncludeConfigs;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.Serialize;
import com.t4login.util.ColorUtil;
import com.t4login.util.Xml;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ConfigReader {
    private static final String TAG = "ConfigReader";
    private ConfigContext configContext;
    private boolean dbg = false;

    public ConfigReader(ConfigContext ccontext) {
        this.configContext = ccontext;
    }

    public ConfigReader(ConfigContext ccontext, boolean debugLogging) {
        this.configContext = ccontext;
        this.dbg = debugLogging;
    }

    private void DBG(String format, Object ... args) {
        if (this.dbg) {
            String msg = String.format(format, args);
            Log.d(TAG, msg);
        }
    }

    public void parseConfigSettings(String xml, Configurable config) {
        this.DBG("parseConfigSettings(), Cfg: %s, XML: %s", config.getClass().getName(), xml);
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes("UTF8"));
            try {
                XmlPullParser parser = Xml.newPullParser();
                parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
                parser.setInput(in, null);
                parser.nextTag();
                this.parseConfigSettings(parser, config);
            }
            catch (XmlPullParserException pex) {
                Log.e(TAG, "parseConfigSettings(), Parser error.", pex);
            }
            catch (Exception ex) {
                Log.e(TAG, "parseConfigSettings(), Error.", ex);
            }
        }
        catch (UnsupportedEncodingException encex) {
            Log.e(TAG, "parseConfigSettings(), Encoding error.", encex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Configurable parseConfigSettings(XmlPullParser parser, Configurable config) {
        this.DBG("parseConfigSettings(), [parser], Cfg: %s", config != null ? config.getClass().getName() : "null");
        if (config == null) {
            String cid = parser.getAttributeValue(null, "cid");
            String uid = parser.getAttributeValue(null, "uid");
            if (cid != null && !cid.isEmpty()) {
                config = Configurable.createConfig(cid, uid);
                this.DBG("parseConfigSettings(), Created config object: %s", config != null ? config.getClass().getName() : "null");
            }
        }
        int n = parser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String pname = parser.getAttributeName(i);
            String pvalue = parser.getAttributeValue(i);
            if (pname.equals("cid")) continue;
            Field f = this.getField(pname, config);
            if (f != null) {
                PropertyConfig p = f.getAnnotation(PropertyConfig.class);
                if (p != null) {
                    Object value;
                    Serialize.As as = Serialize.As.None;
                    Serialize z = f.getAnnotation(Serialize.class);
                    if (z != null) {
                        as = z.value();
                    }
                    if ((value = ConfigReader.getSettingValue(pvalue, f, as)) == null) continue;
                    try {
                        f.set(config, ConfigReader.getSettingValue(pvalue, f, as));
                        this.DBG("parseConfigSettings(), Restored field %s.%s value to %s", config.getClass().getName(), f.getName(), pvalue);
                    }
                    catch (IllegalAccessException accex) {
                        Log.e(TAG, "parseConfigSettings(), Error setting field value " + config.getClass().getName() + "." + pname + "." + String.valueOf(accex));
                    }
                    continue;
                }
                Log.e(TAG, "parseConfigSettings(), Field " + config.getClass().getName() + "." + pname + " does not have a PropertyConfig annotation.");
                continue;
            }
            Log.e(TAG, "parseConfigSettings(), Unable to locate field " + config.getClass().getName() + "." + pname);
        }
        try {
            while (parser.next() != 3) {
                ArrayList<Configurable> nestedListItems;
                Class<?> nestedType;
                Field f;
                String nestedConfigName;
                block28: {
                    if (parser.getEventType() != 2) continue;
                    nestedConfigName = parser.getName();
                    f = this.getField(nestedConfigName, config);
                    if (f != null) {
                        nestedType = f.getType();
                        if (Configurable.class.isAssignableFrom(nestedType)) {
                            Object nestedConfigObject = f.get(config);
                            if (nestedConfigObject != null) {
                                Configurable nestedConfig = (Configurable)nestedConfigObject;
                                this.DBG("parseConfigSettings(), Parsing nested condifgurable field %s.%s", config.getClass().getName(), f.getName());
                                this.parseConfigSettings(parser, nestedConfig);
                                continue;
                            }
                            this.DBG("parseConfigSettings(), Creating nested condifgurable field %s.%s", config.getClass().getName(), f.getName());
                            nestedConfigObject = this.parseConfigSettings(parser, null);
                            if (nestedConfigObject != null) {
                                f.set(config, nestedConfigObject);
                                continue;
                            }
                            Log.e(TAG, "parseConfigSettings(), Field " + config.getClass().getName() + "." + nestedConfigName + " not assigned.");
                            continue;
                        }
                        if (f.getType().isArray() || List.class.isAssignableFrom(nestedType)) {
                            nestedListItems = new ArrayList<Configurable>();
                            this.DBG("parseConfigSettings(), Parsing configurable array in field %s.%s", config.getClass().getName(), f.getName());
                            break block28;
                        } else {
                            Object fval = f.get(config);
                            if (!(fval instanceof Map)) continue;
                            try {
                                Map map = (Map)fval;
                                map.clear();
                                String tagName = parser.getName();
                                while (parser.next() != 3) {
                                    if (parser.getEventType() != 2) continue;
                                    String key = parser.getAttributeValue("", "key");
                                    String val = parser.getAttributeValue("", "value");
                                    map.put(key, val);
                                }
                                continue;
                            }
                            catch (Exception ex) {
                                Log.e(TAG, "parseConfigSettings(), Error parsing SaveConfig for field: " + f.getName(), ex);
                                continue;
                            }
                        }
                    }
                    Log.e(TAG, "parseConfigSettings(), Unable to locate field " + config.getClass().getName() + "." + nestedConfigName + " for nested config.");
                    continue;
                }
                while (parser.next() != 3) {
                    if (parser.getEventType() != 2) continue;
                    String listCID = parser.getAttributeValue(null, "cid");
                    String listUID = parser.getAttributeValue(null, "uid");
                    if (listCID == null || listCID.isEmpty()) continue;
                    Configurable listConfig = Configurable.createConfig(listCID, listUID);
                    if (listConfig != null) {
                        this.parseConfigSettings(parser, listConfig);
                        nestedListItems.add(listConfig);
                        continue;
                    }
                    Log.e(TAG, "parseConfigSettings(), Configurable.createConfig() returned null for CID: " + listCID + ", UID: " + listUID);
                }
                if (List.class.isAssignableFrom(nestedType)) {
                    List configList = (List)f.get(config);
                    configList.clear();
                    try {
                        ParameterizedType listTypeParams = (ParameterizedType)f.getGenericType();
                        Type[] listTypeArgs = listTypeParams.getActualTypeArguments();
                        Class listType = (Class)listTypeArgs[0];
                        for (Configurable lc : nestedListItems) {
                            if (listType.isAssignableFrom(lc.getClass())) {
                                configList.add(lc);
                                continue;
                            }
                            Log.e(TAG, "parseConfigSettings(), List element is of wrong type. Field: " + String.valueOf(f) + ", type to add: " + String.valueOf(lc.getClass()));
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        Log.e(TAG, "parseConfigSettings(), Unable to verify nested list item type " + config.getClass().getName() + "." + nestedConfigName + " for nested config. ", ex);
                        ex.printStackTrace();
                        continue;
                    }
                }
                if (!nestedType.isArray()) continue;
                Object arr = Array.newInstance(nestedType.getComponentType(), 1);
                for (int i = 0; i < nestedListItems.size(); ++i) {
                    Array.set(arr, i, nestedListItems.get(i));
                }
                f.set(config, arr);
            }
            return config;
        }
        catch (Exception ex) {
            Log.e(TAG, "Error restoring saved settings.", ex);
        }
        return config;
    }

    private Field getField(String name, Configurable config) {
        Class<?> clazz = config.getClass();
        try {
            return clazz.getField(name);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Field[] fields;
            if (name.equals("Alerts")) {
                try {
                    return clazz.getField("Sounds");
                }
                catch (NoSuchFieldException noSuchFieldException2) {
                    // empty catch block
                }
            }
            if (name.equals("Sounds")) {
                try {
                    return clazz.getField("Alerts");
                }
                catch (NoSuchFieldException noSuchFieldException3) {
                    // empty catch block
                }
            }
            if (name.equals("Display")) {
                try {
                    return clazz.getField("DisplayLight");
                }
                catch (NoSuchFieldException noSuchFieldException4) {
                    // empty catch block
                }
            }
            for (Field f : fields = clazz.getDeclaredFields()) {
                IncludeConfigs incls = f.getAnnotation(IncludeConfigs.class);
                if (incls == null || !incls.as().equals(name)) continue;
                return f;
            }
            return null;
        }
    }

    public static Object getSettingValue(String pval, Field f, Serialize.As as) {
        Class<?> t = f.getType();
        if (t.isEnum()) {
            return Enum.valueOf(t, pval);
        }
        if (t.equals(EnumSet.class)) {
            try {
                Class enType = (Class)((ParameterizedType)f.getGenericType()).getActualTypeArguments()[0];
                String[] parts = pval.split(";");
                EnumSet valSet = EnumSet.noneOf(enType);
                for (String v : parts) {
                    valSet.add(Enum.valueOf(enType, v));
                }
                return valSet;
            }
            catch (Exception ex) {
                Log.e(TAG, "getSettingValue(), Error decoding EnumSet value '" + pval + "', for field '" + f.getName() + "'", ex);
            }
        } else {
            if ((t == Integer.TYPE || t == Integer.class) && as == Serialize.As.Color) {
                return ColorUtil.parseColor(pval);
            }
            if (t == Integer.TYPE) {
                return Integer.valueOf(pval);
            }
            if (t == Integer.class) {
                if (!pval.isEmpty()) {
                    return Integer.valueOf(pval);
                }
                return null;
            }
            if (t == Long.TYPE || t == Long.class) {
                return Long.valueOf(pval);
            }
            if (t == Float.TYPE || t == Float.class) {
                return Float.valueOf(pval);
            }
            if (t == String.class) {
                return pval;
            }
            if (t == Boolean.TYPE || t == Boolean.class) {
                return Boolean.valueOf(pval);
            }
            if (t == BarInterval.class) {
                return BarInterval.fromSerializationString(pval);
            }
            if (t == SessionTime.class) {
                return SessionTime.valueOf(pval);
            }
        }
        return null;
    }
}

