/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.configuration;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import com.t4login.Resource;
import com.t4login.application.ConfigContext;
import com.t4login.application.configuration.Description;
import com.t4login.application.configuration.DescriptionResId;
import com.t4login.application.configuration.IEnum;
import com.t4login.application.configuration.RequiresRole;
import com.t4login.application.configuration.UserRole;
import com.t4login.util.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class PreferenceUtil {
    private static final String TAG = "PreferenceUtil";

    private PreferenceUtil() {
    }

    public static Pair<CharSequence[], CharSequence[]> getEnumValues(Class t, ConfigContext cc) {
        ArrayList<String> descriptions = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        if (t.isEnum()) {
            for (Object c : t.getEnumConstants()) {
                String name;
                Enum enval = (Enum)c;
                String value = name = enval.name();
                try {
                    DescriptionResId descrres;
                    Description descr;
                    Field f = t.getField(name);
                    RequiresRole role = f.getAnnotation(RequiresRole.class);
                    if (role != null && (role.value() == UserRole.NotAllowed || cc.mUserRole == UserRole.Basic && role.value() == UserRole.Standard)) continue;
                    if (c instanceof IEnum) {
                        name = ((IEnum)c).getDescription();
                    }
                    if ((descr = f.getAnnotation(Description.class)) != null) {
                        name = descr.value();
                    }
                    if ((descrres = f.getAnnotation(DescriptionResId.class)) != null) {
                        name = Resource.localizeString(descrres.value());
                    }
                }
                catch (NoSuchFieldException ex) {
                    Log.e(TAG, "getEnumValues(), Field " + name + " does not exist in enum class " + t.getName());
                }
                descriptions.add(name);
                values.add(value);
            }
        }
        CharSequence[] descrs = new CharSequence[descriptions.size()];
        CharSequence[] vals = new CharSequence[values.size()];
        return Pair.create(descriptions.toArray(descrs), values.toArray(vals));
    }

    public static Pair<CharSequence[], CharSequence[]> getEnumClassValues(Class t, ConfigContext cc) {
        class EnumValueDef {
            public final CharSequence Description;
            public final CharSequence Value;
            public final Integer Sortidx;

            public EnumValueDef(CharSequence description, CharSequence value, Integer sortIdx) {
                this.Description = description;
                this.Value = value;
                this.Sortidx = sortIdx;
            }
        }
        ArrayList<EnumValueDef> values = new ArrayList<EnumValueDef>();
        if (t.getAnnotation(AsEnum.class) != null) {
            Field[] declaredFields;
            Method _getDescription;
            try {
                _getDescription = t.getDeclaredMethod("getDescription", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                Log.e(TAG, "getEnumClassValues(), Class " + t.getName() + " must implement a method called getDescription()");
                return Pair.create(new CharSequence[0], new CharSequence[0]);
            }
            for (Field f : declaredFields = t.getDeclaredFields()) {
                Description descr;
                RequiresRole role;
                int modifiers = f.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers) || f.getAnnotation(Constant.class) == null || (role = f.getAnnotation(RequiresRole.class)) != null && (role.value() == UserRole.NotAllowed || cc.mUserRole == UserRole.Basic && role.value() == UserRole.Standard)) continue;
                String fieldDescription = "";
                DescriptionResId descrres = f.getAnnotation(DescriptionResId.class);
                if (descrres != null) {
                    fieldDescription = Resource.localizeString(descrres.value());
                }
                if (fieldDescription.isEmpty() && (descr = f.getAnnotation(Description.class)) != null) {
                    fieldDescription = descr.value();
                }
                if (fieldDescription.isEmpty()) {
                    Object fieldValue;
                    try {
                        fieldValue = f.get(null);
                    }
                    catch (IllegalAccessException e) {
                        Log.e(TAG, "getEnumClassValues(), Class " + t.getName() + " getting value of static field '" + f.getName() + "'", e);
                        continue;
                    }
                    try {
                        fieldDescription = (String)_getDescription.invoke(fieldValue, new Object[0]);
                    }
                    catch (IllegalAccessException e) {
                        Log.e(TAG, "getEnumClassValues(), Class " + t.getName() + " error invoking the getDescription() method.", e);
                        return Pair.create(new CharSequence[0], new CharSequence[0]);
                    }
                    catch (InvocationTargetException e) {
                        Log.e(TAG, "getEnumClassValues(), Class " + t.getName() + " error invoking the getDescription() method.", e);
                        return Pair.create(new CharSequence[0], new CharSequence[0]);
                    }
                }
                if (fieldDescription.isEmpty()) {
                    fieldDescription = f.getName();
                }
                Constant constant = f.getAnnotation(Constant.class);
                values.add(new EnumValueDef(fieldDescription, f.getName(), constant.value()));
            }
        }
        Collections.sort(values, new Comparator<EnumValueDef>(){

            @Override
            public int compare(EnumValueDef a, EnumValueDef b) {
                return a.Sortidx.compareTo(b.Sortidx);
            }
        });
        CharSequence[] descrs = new CharSequence[values.size()];
        CharSequence[] vals = new CharSequence[values.size()];
        for (int i = 0; i < descrs.length; ++i) {
            descrs[i] = ((EnumValueDef)values.get((int)i)).Description;
            vals[i] = ((EnumValueDef)values.get((int)i)).Value;
        }
        return Pair.create(descrs, vals);
    }

    public static Object resolveEnumClassValue(Class t, String valueName) {
        if (t.getAnnotation(AsEnum.class) != null) {
            Field f = null;
            try {
                f = t.getDeclaredField(valueName);
                int modifiers = f.getModifiers();
                if (Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && f.getAnnotation(Constant.class) != null) {
                    return f.get(null);
                }
            }
            catch (NoSuchFieldException e) {
                Log.e(TAG, "resolveEnumClassValue(), Unable to locate a field named '" + valueName + "' on class '" + t.getName() + "'", e);
            }
            catch (IllegalAccessException e) {
                Log.e(TAG, "resolveEnumClassValue(), Unable to access a field named '" + valueName + "' on class '" + t.getName() + "'", e);
            }
        }
        return null;
    }

    public static String resolveEnumClassValueName(Class t, Object value) {
        if (t.getAnnotation(AsEnum.class) != null) {
            Field[] declaredFields;
            for (Field f : declaredFields = t.getDeclaredFields()) {
                int modifiers = f.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers) || f.getAnnotation(Constant.class) == null) continue;
                try {
                    if (!f.get(null).equals(value)) continue;
                    return f.getName();
                }
                catch (IllegalAccessException e) {
                    return null;
                }
            }
        }
        return null;
    }
}

