/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.configuration;

import com.t4login.Host;
import com.t4login.Log;
import com.t4login.application.ConfigContext;
import com.t4login.application.configuration.Beta;
import com.t4login.application.configuration.Category;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.IncludeConfig;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.serialization.AnnotatedField;
import com.t4login.application.configuration.serialization.ConfigUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PreferenceModel
implements Iterable<PrefField> {
    private static final String TAG = "PreferenceModel";
    private List<PrefCategory> mCategories = new ArrayList<PrefCategory>();
    private Map<String, PrefCategory> mCreatedCategories = new HashMap<String, PrefCategory>();

    public boolean usesCategories() {
        return this.mCategories.size() > 0 && this.mCategories.get((int)0).Category != null;
    }

    public List<PrefCategory> getCategories() {
        return this.mCategories;
    }

    @Override
    public Iterator<PrefField> iterator() {
        return new Iterator<PrefField>(){
            int currCategory = -1;
            int currPref = -1;

            @Override
            public boolean hasNext() {
                if (PreferenceModel.this.mCategories.size() > 0) {
                    int nextCategory;
                    int nextPref = this.currPref + 1;
                    for (nextCategory = this.currCategory; nextCategory < 0 || nextCategory < PreferenceModel.this.mCategories.size() && nextPref >= PreferenceModel.this.mCategories.get((int)nextCategory).Fields.size(); ++nextCategory) {
                        nextPref = 0;
                    }
                    return nextCategory < PreferenceModel.this.mCategories.size() && nextPref < PreferenceModel.this.mCategories.get((int)nextCategory).Fields.size();
                }
                return false;
            }

            @Override
            public PrefField next() {
                ++this.currPref;
                while (this.currCategory < 0 || this.currCategory < PreferenceModel.this.mCategories.size() && this.currPref >= PreferenceModel.this.mCategories.get((int)this.currCategory).Fields.size()) {
                    ++this.currCategory;
                    this.currPref = 0;
                }
                return PreferenceModel.this.mCategories.get((int)this.currCategory).Fields.get(this.currPref);
            }

            @Override
            public void remove() {
            }
        };
    }

    public void updateModelFilters(ConfigContext cc) {
        for (PrefField prefField : this) {
            prefField.Filtered = cc.isFiltered(prefField.Configurable, prefField.Field);
            Beta beta = prefField.Field.getAnnotation(Beta.class);
            boolean debugMode = Host.isDebugMode();
            if (beta != null) {
                prefField.Filtered = !debugMode;
            }
            prefField.Enabled = prefField.Configurable.isEnabled(prefField.Field.getName());
        }
    }

    public void buildModel(Configurable configurable) {
        Category configurableCategory = configurable.getClass().getAnnotation(Category.class);
        if (configurableCategory != null) {
            String catID = "category_" + configurableCategory.value();
            PrefCategory defaultPrefCategory = new PrefCategory(configurableCategory, catID, 0);
            this.mCategories.add(defaultPrefCategory);
            this.mCreatedCategories.put(configurableCategory.value(), defaultPrefCategory);
            this.buildFromConfigurable(configurable, defaultPrefCategory, "", 0);
        } else {
            PrefCategory defaultPrefCategory = new PrefCategory(null, "category_default", 0);
            this.mCategories.add(defaultPrefCategory);
            this.buildFromConfigurableNoCategories(configurable, "", 0);
        }
    }

    private int buildFromConfigurable(Configurable configurable, PrefCategory defaultPrefCategory, String parentFieldID, int baseSortIndex) {
        List<AnnotatedField> fields = ConfigUtil.extractAndSortFields(configurable);
        for (int i = 0; i < fields.size(); ++i) {
            AnnotatedField f = fields.get(i);
            if (f.Annotation instanceof PropertyConfig) {
                Category fieldCategory;
                String prefID = parentFieldID.isEmpty() ? configurable.uid + ";" + f.Field.getName() : parentFieldID + ";" + configurable.uid + ";" + f.Field.getName();
                PrefField pfield = new PrefField(f.Field, configurable, prefID, baseSortIndex + i);
                pfield.Filtered = configurable.filterProperty(f.Field.getName());
                pfield.Enabled = configurable.isEnabled(f.Field.getName());
                Beta beta = f.Field.getAnnotation(Beta.class);
                boolean debugMode = Host.isDebugMode();
                if (beta != null) {
                    boolean bl = pfield.Filtered = !debugMode;
                }
                if ((fieldCategory = f.Field.getAnnotation(Category.class)) == null) {
                    defaultPrefCategory.Fields.add(pfield);
                    pfield.CategoryID = defaultPrefCategory.PreferenceID;
                    continue;
                }
                PrefCategory pcat = this.mCreatedCategories.get(fieldCategory.value());
                if (pcat != null) {
                    pcat.Fields.add(pfield);
                    pfield.CategoryID = pcat.PreferenceID;
                    continue;
                }
                String pCatID = "category_" + fieldCategory.value();
                pcat = new PrefCategory(fieldCategory, pCatID, this.mCategories.size());
                this.mCategories.add(pcat);
                this.mCreatedCategories.put(fieldCategory.value(), pcat);
                pcat.Fields.add(pfield);
                pfield.CategoryID = pcat.PreferenceID;
                continue;
            }
            if (!(f.Annotation instanceof IncludeConfig)) continue;
            Category fieldCategory = f.Field.getAnnotation(Category.class);
            PrefCategory pcat = defaultPrefCategory;
            if (fieldCategory != null && (pcat = this.mCreatedCategories.get(fieldCategory.value())) == null) {
                String pCatID = "category_" + fieldCategory.value();
                pcat = new PrefCategory(fieldCategory, pCatID, this.mCategories.size(), f.Field);
                this.mCategories.add(pcat);
                this.mCreatedCategories.put(fieldCategory.value(), pcat);
            }
            String prefID = parentFieldID.isEmpty() ? configurable.uid + ";" + f.Field.getName() : parentFieldID + ";" + configurable.uid + ";" + f.Field.getName();
            try {
                baseSortIndex = this.buildFromConfigurable((Configurable)f.Field.get(configurable), pcat, prefID, baseSortIndex + i);
                continue;
            }
            catch (IllegalAccessException e) {
                Log.e(TAG, "buildFromConfigurable(), Error processing IncludeConfig.", e);
            }
        }
        return baseSortIndex + fields.size();
    }

    private int buildFromConfigurableNoCategories(Configurable configurable, String parentFieldID, int baseSortIndex) {
        PrefCategory defaultPrefCategory = this.mCategories.get(0);
        List<AnnotatedField> fields = ConfigUtil.extractAndSortFields(configurable);
        for (int i = 0; i < fields.size(); ++i) {
            String prefID;
            AnnotatedField f = fields.get(i);
            if (f.Annotation instanceof PropertyConfig) {
                prefID = parentFieldID.isEmpty() ? configurable.uid + ";" + f.Field.getName() : parentFieldID + ";" + configurable.uid + ";" + f.Field.getName();
                PrefField pfield = new PrefField(f.Field, configurable, prefID, baseSortIndex + i);
                pfield.Filtered = configurable.filterProperty(f.Field.getName());
                pfield.Enabled = configurable.isEnabled(f.Field.getName());
                Beta beta = f.Field.getAnnotation(Beta.class);
                boolean debugMode = Host.isDebugMode();
                if (beta != null) {
                    pfield.Filtered = !debugMode;
                }
                defaultPrefCategory.Fields.add(pfield);
                continue;
            }
            if (!(f.Annotation instanceof IncludeConfig) || !Configurable.class.isAssignableFrom(f.Field.getType())) continue;
            prefID = parentFieldID.isEmpty() ? configurable.uid + ";" + f.Field.getName() : parentFieldID + ";" + configurable.uid + ";" + f.Field.getName();
            try {
                baseSortIndex = this.buildFromConfigurableNoCategories((Configurable)f.Field.get(configurable), prefID, baseSortIndex + i);
                continue;
            }
            catch (IllegalAccessException e) {
                Log.e(TAG, "buildFromConfigurableNoCategories(), Error processing IncludeConfig.", e);
            }
        }
        return baseSortIndex + fields.size();
    }

    public static class PrefCategory {
        public final Category Category;
        public final String PreferenceID;
        public final int SortIndex;
        public final Field ParentField;
        public final List<PrefField> Fields = new ArrayList<PrefField>();

        public PrefCategory(Category c, String id, int idx) {
            this.Category = c;
            this.PreferenceID = id;
            this.SortIndex = idx;
            this.ParentField = null;
        }

        public PrefCategory(Category c, String id, int idx, Field parentField) {
            this.Category = c;
            this.PreferenceID = id;
            this.SortIndex = idx;
            this.ParentField = parentField;
        }

        public boolean isVisible() {
            for (PrefField pf : this.Fields) {
                if (pf.Filtered) continue;
                return true;
            }
            return false;
        }
    }

    public static class PrefField {
        public final Field Field;
        public final Field ParentField;
        public final Configurable Configurable;
        public final String PreferenceID;
        public final int SortIndex;
        public String CategoryID = "";
        public boolean Filtered = false;
        public boolean Enabled = true;

        public PrefField(Field f, Configurable c, String id, int idx) {
            this.Field = f;
            this.ParentField = null;
            this.Configurable = c;
            this.PreferenceID = id;
            this.SortIndex = idx;
        }

        public PrefField(Field f, Field par, Configurable c, String id, int idx) {
            this.Field = f;
            this.ParentField = par;
            this.Configurable = c;
            this.PreferenceID = id;
            this.SortIndex = idx;
        }

        public String toString() {
            return String.format(Locale.US, "Field: %s, ID: %s, Sort: %d", this.Field.getName(), this.PreferenceID, this.SortIndex);
        }
    }
}

