/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.configuration;

import com.t4login.Log;
import com.t4login.application.configuration.IConfigBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public abstract class Configurable {
    private static final String TAG = "Configurable";
    private static Map<String, IConfigBuilder> configBuilders = new HashMap<String, IConfigBuilder>();
    public final String uid;

    public static void registerConfigBuilder(String name, IConfigBuilder builder) {
        configBuilders.put(name, builder);
    }

    public static Configurable createConfig(String name, String uid) {
        if (configBuilders.containsKey(name)) {
            return configBuilders.get(name).buildConfigObject(uid);
        }
        Log.e(TAG, "createConfig(), No configurable with cid: '" + name + "' registered.");
        return null;
    }

    protected Configurable(String uid) {
        this.uid = uid != null && !uid.isEmpty() ? uid : UUID.randomUUID().toString();
    }

    protected Configurable() {
        this(UUID.randomUUID().toString());
    }

    public String toString() {
        return this.configurableName();
    }

    public abstract String configID();

    public String getUUID() {
        return this.uid;
    }

    public abstract String configurableName();

    public boolean filterProperty(String propertyName) {
        return false;
    }

    public boolean isEnabled(String propertyName) {
        return true;
    }

    public boolean propertyUpdated(String propertyName) {
        return false;
    }

    public static interface ConfigurationChangedHandler {
        public void onConfigurationChanged(boolean var1);
    }
}

