/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.underlays;

import com.t4login.Host;
import com.t4login.Resource;
import com.t4login.application.chart.ChartContext;
import com.t4login.application.chart.IValueFormatter;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.IBarDataPoint;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.DataField;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.render.IChartRenderer;
import com.t4login.application.chart.render.IRendererFactory;
import com.t4login.application.chart.render.IStudyIndicatorBarRenderer;
import com.t4login.application.chart.render.ISummaryRenderer;
import com.t4login.application.chart.render.ITrackLabelRenderer;
import com.t4login.application.chart.scales.IValueScale;
import com.t4login.application.chart.scales.ValueScale;
import com.t4login.application.chart.studies.BarStudy;
import com.t4login.application.chart.studies.Study;
import com.t4login.application.chart.studies.StudyCategory;
import com.t4login.application.chart.studies.StudyConfigurable;
import com.t4login.application.chart.studies.StudyDefinition;
import com.t4login.application.chart.studies.StudyType;
import com.t4login.application.configuration.Category;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.EditorType;
import com.t4login.application.configuration.IncludeConfig;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.Serialize;
import com.t4login.application.configuration.UserRole;
import com.t4login.datetime.NDateTime;
import com.t4login.util.ColorUtil;
import com.t4login.util.Range;
import com.t4login.util.RangeType;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.EnumSet;
import java.util.Locale;

@StudyDefinition(id="VOLu", nameResId="chart_vol_study_name", descrResId="chart_vol_study_descr", category=StudyCategory.Underlay, type=StudyType.Underlay, userRole=UserRole.Basic)
public class VolumeUnderlayStudy
extends Study {
    private static final String TAG = "VolumeUnderlayStudy";
    private static StudyDefinition DEF = VolumeUnderlayStudy.class.getAnnotation(StudyDefinition.class);
    private final Configuration mConfig;
    private IStudyIndicatorBarRenderer mBarRenderer = null;
    private final ITrackLabelRenderer mVolumeTradedTracklabel;
    private final ISummaryRenderer mSummary;
    private final DecimalFormat mSummaryFormatter;

    public VolumeUnderlayStudy(ChartContext ccontext) {
        this(ccontext, null);
    }

    @Override
    public String getUID() {
        return this.mConfig.uid;
    }

    public VolumeUnderlayStudy(ChartContext ccontext, Object config) {
        super(ccontext);
        this.mConfig = config instanceof Configuration ? (Configuration)config : new Configuration("");
        IRendererFactory rendererFactory = Host.getRendererFactory();
        this.mBarRenderer = rendererFactory.createStudyIndicatorBarRenderer();
        this.mVolumeTradedTracklabel = rendererFactory.createTrackLabelRenderer();
        this.mVolumeTradedTracklabel.setValueFormatter(new IValueFormatter(){

            @Override
            public String formatValue(double value) {
                return VolumeUnderlayStudy.this.mSummaryFormatter.format(value);
            }
        });
        this.mSummary = rendererFactory.createSummaryRenderer();
        this.mSummaryFormatter = (DecimalFormat)NumberFormat.getInstance(Locale.US);
    }

    @Override
    public StudyDefinition getStudyDefinition() {
        return DEF;
    }

    @Override
    public Configurable getConfiguration() {
        return this.mConfig;
    }

    @Override
    public IValueScale createValueScale() {
        EnumSet<ValueScale.ScaleBehavior> opts = EnumSet.noneOf(ValueScale.ScaleBehavior.class);
        return new ValueScale(opts);
    }

    @Override
    public IChartRenderer getRenderer() {
        BarDataSeries ser = this.getBarData();
        DataField plotField = ser.getDataDefinition().getField("VOLUME");
        DataField risingColorField = ser.getDataDefinition().getField("CLOSE");
        DataField fallingColorField = ser.getDataDefinition().getField("OPEN");
        this.mBarRenderer.updateDateSource(ser.getDataSource(), plotField, risingColorField, fallingColorField);
        if (this.mConfig.CustomizeColors) {
            this.mBarRenderer.setRisingColor(this.mConfig.RisingColor).setFallingColor(this.mConfig.FallingColor).setOutlineColor(this.mConfig.OutlineColor);
        } else {
            BarStudy.Configuration barConfig = this.getChartContext().Profile.getPrimaryStudyConfig();
            if (barConfig != null) {
                this.mBarRenderer.setRisingColor(barConfig.RisingColor).setFallingColor(barConfig.FallingColor).setOutlineColor(barConfig.OutlineColor);
            }
        }
        return this.mBarRenderer;
    }

    @Override
    protected ISummaryRenderer getSummary(NDateTime trackTime) {
        BarDataSeries bars;
        IBarDataPoint dp;
        if (!this.mConfig.SummaryConfig.DisplaySummaries) {
            return null;
        }
        Object summText = "VOL";
        if (this.mConfig.SummaryConfig.DisplayVolumeValue && (dp = (bars = this.getBarData()).getNearestTo(trackTime)) != null) {
            summText = (String)summText + " " + this.mSummaryFormatter.format(dp.getVolume());
        }
        this.mSummary.setText((String)summText).setIcon(ISummaryRenderer.SummaryIcon.HistBars);
        return this.mSummary;
    }

    @Override
    protected ITrackLabelRenderer getTrackLabel() {
        BarDataSeries bars = this.getBarData();
        IBarDataPoint lastBar = bars.getLast();
        if (lastBar != null) {
            int trackColor = this.mConfig.RisingColor;
            if (this.mConfig.CustomizeColors) {
                trackColor = lastBar.getClose() < lastBar.getOpen() ? this.mConfig.FallingColor : this.mConfig.RisingColor;
            } else {
                BarStudy.Configuration barConfig = this.getChartContext().Profile.getPrimaryStudyConfig();
                if (barConfig != null) {
                    trackColor = lastBar.getClose() < lastBar.getOpen() ? barConfig.FallingColor : barConfig.RisingColor;
                }
            }
            this.mVolumeTradedTracklabel.setFillColor(trackColor).setBorderColor(this.mConfig.OutlineColor).setFixedAlpha(175);
            this.mVolumeTradedTracklabel.setTrackValue(Double.valueOf(lastBar.getVolume()));
            return this.mVolumeTradedTracklabel;
        }
        return null;
    }

    @Override
    public Range<Double> getValueRange(Range<NDateTime> timeRange) {
        BarDataSeries bars = this.getBarData();
        double maxVol = 0.0;
        for (IBarDataPoint pt : bars.getPointsBetween(timeRange, RangeType.Extended)) {
            maxVol = Math.max(maxVol, (double)pt.getVolume());
        }
        return Range.of(0.0, maxVol);
    }

    @Override
    public Range<NDateTime> getTimeRange() {
        BarDataSeries bars = this.getBarData();
        return bars.getTimeRange();
    }

    @Override
    public Integer getPreceedingIntervals() {
        return 0;
    }

    @Override
    protected void onUpdateStudy() {
    }

    @Override
    protected void onRecomputeStudy() {
    }

    @Override
    protected void onResetStudy() {
    }

    @Override
    public DataDefinition getDataDefinition() {
        BarDataSeries bars = this.getBarData();
        return bars.getDataDefinition();
    }

    @Override
    public IDataSource getDataSource() {
        BarDataSeries bars = this.getBarData();
        return bars.getDataSource();
    }

    @Category(value="chart_vol_study")
    public static class Configuration
    extends StudyConfigurable {
        @PropertyConfig(idx=0, name="chart_vol_customize_colors_name", description="chart_vol_customize_colors_descr", editor=EditorType.Switch)
        @DefaultValue(value="false")
        public boolean CustomizeColors = false;
        @PropertyConfig(idx=1, name="rising_color_name", description="rising_color_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#000000")
        @Serialize(value=Serialize.As.Color)
        public int RisingColor = ColorUtil.rgb(26, 196, 26);
        @PropertyConfig(idx=2, name="falling_color_name", description="falling_color_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#FF0000")
        @Serialize(value=Serialize.As.Color)
        public int FallingColor = ColorUtil.rgb(192, 0, 0);
        @PropertyConfig(idx=2, name="outline_color_name", description="outline_color_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#000000")
        @Serialize(value=Serialize.As.Color)
        public int OutlineColor = ColorUtil.rgb(0, 0, 0);
        @IncludeConfig(idx=3)
        @Category(value="chart_summaries")
        public final SummaryConfig SummaryConfig = new SummaryConfig();

        public Configuration(String uid) {
            super(uid);
        }

        @Override
        public String configID() {
            return DEF.id();
        }

        @Override
        public String configurableName() {
            return Resource.localizeString("chart_vol_u_study_name");
        }

        @Override
        public boolean isEnabled(String propertyName) {
            if (propertyName.equals("RisingColor") && !this.CustomizeColors) {
                return false;
            }
            if (propertyName.equals("FallingColor") && !this.CustomizeColors) {
                return false;
            }
            if (propertyName.equals("OutlineColor") && !this.CustomizeColors) {
                return false;
            }
            return super.isEnabled(propertyName);
        }
    }

    public static class SummaryConfig
    extends Configurable {
        @PropertyConfig(idx=0, name="chart_display_summaries_name", description="chart_display_summaries_descr", editor=EditorType.Switch)
        @DefaultValue(value="true")
        public boolean DisplaySummaries = true;
        @PropertyConfig(idx=1, name="vol_summary_display_volume_name", description="empty")
        @DefaultValue(value="true")
        public boolean DisplayVolumeValue = true;

        @Override
        public String configID() {
            return "VolumeUnderlayStudy$SummaryConfig";
        }

        @Override
        public String configurableName() {
            return Resource.localizeString("chart_summaries");
        }

        @Override
        public boolean isEnabled(String propertyName) {
            return !propertyName.equals("DisplayVolumeValue") || this.DisplaySummaries;
        }
    }
}

