/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.overlays;

import com.t4login.Host;
import com.t4login.Resource;
import com.t4login.application.chart.ChartContext;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.render.IChartRenderer;
import com.t4login.application.chart.render.IRendererFactory;
import com.t4login.application.chart.render.IStudyLineRenderer;
import com.t4login.application.chart.render.ISummaryRenderer;
import com.t4login.application.chart.scales.IValueScale;
import com.t4login.application.chart.studies.Study;
import com.t4login.application.chart.studies.StudyCategory;
import com.t4login.application.chart.studies.StudyConfigurable;
import com.t4login.application.chart.studies.StudyDefinition;
import com.t4login.application.chart.studies.StudyType;
import com.t4login.application.chart.studies.computations.BarMovingAverage;
import com.t4login.application.chart.studies.computations.MAPriceType;
import com.t4login.application.chart.studies.computations.MAType;
import com.t4login.application.configuration.Category;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.EditorType;
import com.t4login.application.configuration.IncludeConfig;
import com.t4login.application.configuration.NumberFormatF;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.Serialize;
import com.t4login.application.configuration.UserRole;
import com.t4login.application.settings.AppSettings;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.priceconversion.IPriceFormatArgs;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.definitions.priceconversion.PriceFormat;
import com.t4login.util.ColorUtil;
import com.t4login.util.Range;

@StudyDefinition(id="TMA", nameResId="chart_tma_study_name", descrResId="chart_tma_study_descr", category=StudyCategory.Overlay, type=StudyType.Overlay, userRole=UserRole.Basic)
public class TMAStudy
extends Study {
    private static final String TAG = "TMAStudy";
    private static StudyDefinition DEF = TMAStudy.class.getAnnotation(StudyDefinition.class);
    private final Configuration mConfig;
    private BarMovingAverage mMA = null;
    private DataSeries mData = new DataSeries("MovAvg");
    private final IStudyLineRenderer mAvgRenderer;
    private final ISummaryRenderer mSummary;

    public TMAStudy(ChartContext ccontext) {
        this(ccontext, null);
    }

    @Override
    public String getUID() {
        return this.mConfig.uid;
    }

    public TMAStudy(ChartContext ccontext, Object config) {
        super(ccontext);
        this.mConfig = config instanceof Configuration ? (Configuration)config : new Configuration("");
        IRendererFactory rendererFactory = Host.getRendererFactory();
        assert (rendererFactory != null);
        this.mAvgRenderer = rendererFactory.createStudyLineRenderer();
        this.mSummary = rendererFactory.createSummaryRenderer();
    }

    @Override
    public StudyDefinition getStudyDefinition() {
        return DEF;
    }

    @Override
    public Configurable getConfiguration() {
        return this.mConfig;
    }

    @Override
    public IValueScale createValueScale() {
        throw new UnsupportedOperationException("Overlay studies do not support creating value scales. They should always be secondary studies.");
    }

    @Override
    public IChartRenderer getRenderer() {
        this.mAvgRenderer.updateDataSource(this.mData, this.mMA.getDataDefinition().getPrimaryField()).setColor(this.mConfig.LineColor).setWidth(this.mConfig.LineThickness).setLineStyle(IChartRenderer.LineStyle.Solid).setOffset(this.mConfig.Offset);
        return this.mAvgRenderer;
    }

    @Override
    protected ISummaryRenderer getSummary(NDateTime trackTime) {
        BarMovingAverage.MAValue dp;
        if (!this.mConfig.SummaryConfig.DisplaySummaries) {
            return null;
        }
        Object summText = this.mConfig.configurableName();
        if (this.mConfig.SummaryConfig.DisplayMovingAverageValue && this.mMA != null && (dp = (BarMovingAverage.MAValue)this.mData.getNearestTo(trackTime)) != null) {
            Price maPrice = Price.of(dp.MA).roundToNearest(this.getMarket());
            summText = (String)summText + " " + PriceFormat.convertPriceToDisplayFormat(maPrice, (IPriceFormatArgs)this.getMarket(), AppSettings.instance.MarketData.PriceDisplay);
        }
        this.mSummary.setText((String)summText).setIcon(ISummaryRenderer.SummaryIcon.Oscillator);
        return this.mSummary;
    }

    @Override
    public Range<Double> getValueRange(Range<NDateTime> timeRange) {
        return this.mData.getValueRange(timeRange);
    }

    @Override
    public Range<NDateTime> getTimeRange() {
        return this.mData.getTimeRange();
    }

    @Override
    public Integer getPreceedingIntervals() {
        return null;
    }

    @Override
    protected void onUpdateStudy() {
        if (this.mMA == null) {
            this.mMA = new BarMovingAverage(this.getBarData(), MAType.TMA, this.mConfig.PriceType, this.mConfig.Periods, this.mData);
            this.mMA.reCompute();
        } else {
            this.mMA.update();
        }
    }

    @Override
    protected void onRecomputeStudy() {
        this.mMA = new BarMovingAverage(this.getBarData(), MAType.TMA, this.mConfig.PriceType, this.mConfig.Periods, this.mData);
        this.mMA.reCompute();
        if (this.mAvgRenderer != null) {
            this.mAvgRenderer.updateDataSource(this.mData, this.mMA.getDataDefinition().getPrimaryField());
        }
    }

    @Override
    protected void onResetStudy() {
        this.mData.clear();
    }

    @Override
    public DataDefinition getDataDefinition() {
        if (this.mMA == null) {
            this.mMA = new BarMovingAverage(this.getBarData(), MAType.TMA, this.mConfig.PriceType, this.mConfig.Periods, this.mData);
        }
        return this.mMA.getDataDefinition();
    }

    @Override
    public IDataSource getDataSource() {
        return this.mData;
    }

    @Category(value="chart_tma_study")
    public static class Configuration
    extends StudyConfigurable {
        @PropertyConfig(idx=0, name="ma_pricetype_name", description="ma_pricetype_descr")
        @DefaultValue(value="Closing")
        public MAPriceType PriceType = MAPriceType.Closing;
        @PropertyConfig(idx=1, name="ma_periods_name", description="ma_periods_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10000.0f)
        @DefaultValue(value="10")
        public int Periods = 10;
        @PropertyConfig(idx=2, name="ma_offset_name", description="ma_offset_descr")
        @NumberFormatF(minValue=-10000.0f, maxValue=10000.0f, increment=1.0f, displayDecimals=0)
        @DefaultValue(value="0")
        public int Offset = 0;
        @PropertyConfig(idx=3, name="linecolor_name", description="linecolor_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#800080")
        @Serialize(value=Serialize.As.Color)
        public int LineColor = ColorUtil.rgb(128, 0, 128);
        @PropertyConfig(idx=4, name="linewidth_name", description="linewidth_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10.0f, increment=1.0f, displayDecimals=0)
        @DefaultValue(value="2")
        public int LineThickness = 2;
        @IncludeConfig(idx=5)
        @Category(value="chart_summaries")
        public final SummaryConfig SummaryConfig = new SummaryConfig();

        public Configuration(String uid) {
            super(uid);
        }

        @Override
        public String configID() {
            return DEF.id();
        }

        @Override
        public String configurableName() {
            return String.format("%s(%d)", Resource.localizeString("chart_tma_study"), this.Periods);
        }
    }

    public static class SummaryConfig
    extends Configurable {
        @PropertyConfig(idx=0, name="chart_display_summaries_name", description="chart_display_summaries_descr", editor=EditorType.Switch)
        @DefaultValue(value="true")
        public boolean DisplaySummaries = true;
        @PropertyConfig(idx=1, name="chart_summary_display_movingaverage_name", description="empty")
        @DefaultValue(value="true")
        public boolean DisplayMovingAverageValue = true;

        @Override
        public String configID() {
            return "TMAStudy$SummaryConfig";
        }

        @Override
        public String configurableName() {
            return Resource.localizeString("chart_summaries");
        }

        @Override
        public boolean isEnabled(String propertyName) {
            return !propertyName.equals("DisplayMovingAverageValue") || this.DisplaySummaries;
        }
    }
}

