/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.overlays;

import com.t4login.Host;
import com.t4login.Resource;
import com.t4login.api.Market;
import com.t4login.application.chart.ChartContext;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.SettlementDataPoint;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.render.IChartRenderer;
import com.t4login.application.chart.render.IRendererFactory;
import com.t4login.application.chart.render.IStudyStepRenderer;
import com.t4login.application.chart.render.ISummaryRenderer;
import com.t4login.application.chart.scales.IValueScale;
import com.t4login.application.chart.studies.Study;
import com.t4login.application.chart.studies.StudyCategory;
import com.t4login.application.chart.studies.StudyConfigurable;
import com.t4login.application.chart.studies.StudyDefinition;
import com.t4login.application.chart.studies.StudyType;
import com.t4login.application.configuration.Category;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.EditorType;
import com.t4login.application.configuration.IncludeConfig;
import com.t4login.application.configuration.NumberFormatF;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.Serialize;
import com.t4login.application.configuration.UserRole;
import com.t4login.application.settings.AppSettings;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.priceconversion.IPriceFormatArgs;
import com.t4login.definitions.priceconversion.PriceFormat;
import com.t4login.util.ColorUtil;
import com.t4login.util.Range;

@StudyDefinition(id="SETTL", nameResId="chart_settl_study_name", descrResId="chart_settl_study_descr", category=StudyCategory.Overlay, type=StudyType.Overlay, userRole=UserRole.Basic)
public class SettlementStudy
extends Study {
    private static final String TAG = "SettlementStudy";
    private static StudyDefinition DEF = SettlementStudy.class.getAnnotation(StudyDefinition.class);
    private final Configuration mConfig;
    private final IStudyStepRenderer mSettlRenderer;
    private final ISummaryRenderer mSummary;

    public SettlementStudy(ChartContext ccontext) {
        this(ccontext, null);
    }

    @Override
    public String getUID() {
        return this.mConfig.uid;
    }

    public SettlementStudy(ChartContext ccontext, Object config) {
        super(ccontext);
        this.mConfig = config instanceof Configuration ? (Configuration)config : new Configuration("");
        IRendererFactory rendererFactory = Host.getRendererFactory();
        assert (rendererFactory != null);
        this.mSettlRenderer = rendererFactory.createStudyStepRenderer();
        this.mSummary = rendererFactory.createSummaryRenderer();
    }

    @Override
    public StudyDefinition getStudyDefinition() {
        return DEF;
    }

    @Override
    public Configurable getConfiguration() {
        return this.mConfig;
    }

    @Override
    public IValueScale createValueScale() {
        throw new UnsupportedOperationException("Overlay studies do not support creating value scales. They should always be secondary studies.");
    }

    @Override
    public IChartRenderer getRenderer() {
        BarDataSeries bars = this.getBarData();
        this.mSettlRenderer.updateDateSource(bars.getSettlementData(), bars.getSettlementDataDefinition().getPrimaryField()).setExtendTo(bars.getTimeRange().end()).setColor(this.mConfig.LineColor).setWidth(this.mConfig.LineThickness).setLineStyle(IChartRenderer.LineStyle.Solid).setDrawRisers(false);
        return this.mSettlRenderer;
    }

    @Override
    protected ISummaryRenderer getSummary(NDateTime trackTime) {
        Market apiMarket;
        SettlementDataPoint dp;
        if (!this.mConfig.SummaryConfig.DisplaySummaries) {
            return null;
        }
        Object summText = this.mConfig.configurableName();
        BarDataSeries bars = this.getBarData();
        DataSeries<SettlementDataPoint> settls = bars.getSettlementData();
        if (this.mConfig.SummaryConfig.DisplaySettlementValue && settls != null && (dp = (SettlementDataPoint)settls.getNearestTo(trackTime)) != null && (apiMarket = this.getMarket().getAPIMarket()) != null) {
            summText = (String)summText + " " + PriceFormat.convertPriceToDisplayFormat(dp.SettlementPrice, (IPriceFormatArgs)apiMarket, AppSettings.instance.MarketData.PriceDisplay);
        }
        this.mSummary.setText((String)summText).setIcon(ISummaryRenderer.SummaryIcon.Oscillator);
        return this.mSummary;
    }

    @Override
    public Range<Double> getValueRange(Range<NDateTime> timeRange) {
        BarDataSeries bars = this.getBarData();
        DataSeries<SettlementDataPoint> settls = bars.getSettlementData();
        return settls.getValueRange(timeRange);
    }

    @Override
    public Range<NDateTime> getTimeRange() {
        BarDataSeries bars = this.getBarData();
        return bars.getTimeRange();
    }

    @Override
    public Integer getPreceedingIntervals() {
        return null;
    }

    @Override
    protected void onUpdateStudy() {
    }

    @Override
    protected void onRecomputeStudy() {
    }

    @Override
    protected void onResetStudy() {
    }

    @Override
    public DataDefinition getDataDefinition() {
        BarDataSeries bars = this.getBarData();
        return bars.getSettlementDataDefinition();
    }

    @Override
    public IDataSource getDataSource() {
        BarDataSeries bars = this.getBarData();
        return bars.getSettlementData();
    }

    @Category(value="chart_settl_settings")
    public static class Configuration
    extends StudyConfigurable {
        @PropertyConfig(idx=0, name="linecolor_name", description="linecolor_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#FF8C00")
        @Serialize(value=Serialize.As.Color)
        public int LineColor = ColorUtil.rgb(255, 140, 0);
        @PropertyConfig(idx=1, name="linewidth_name", description="linewidth_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10.0f, increment=1.0f, displayDecimals=0)
        @DefaultValue(value="2")
        public int LineThickness = 2;
        @IncludeConfig(idx=2)
        @Category(value="chart_summaries")
        public final SummaryConfig SummaryConfig = new SummaryConfig();

        public Configuration(String uid) {
            super(uid);
        }

        @Override
        public String configID() {
            return DEF.id();
        }

        @Override
        public String configurableName() {
            return Resource.localizeString("chart_settl_settings");
        }
    }

    public static class SummaryConfig
    extends Configurable {
        @PropertyConfig(idx=0, name="chart_display_summaries_name", description="chart_display_summaries_descr", editor=EditorType.Switch)
        @DefaultValue(value="true")
        public boolean DisplaySummaries = true;
        @PropertyConfig(idx=1, name="settl_summary_display_settl_value_name", description="settl_summary_display_settl_value_descr")
        @DefaultValue(value="true")
        public boolean DisplaySettlementValue = true;

        @Override
        public String configID() {
            return "SettlementStudy$SummaryConfig";
        }

        @Override
        public String configurableName() {
            return Resource.localizeString("chart_summaries");
        }

        @Override
        public boolean isEnabled(String propertyName) {
            return !propertyName.equals("DisplaySettlementValue") || this.DisplaySummaries;
        }
    }
}

