/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.overlays;

import com.t4login.Host;
import com.t4login.Log;
import com.t4login.Resource;
import com.t4login.application.chart.ChartContext;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.IBarDataPoint;
import com.t4login.application.chart.chartdata.IDataPoint;
import com.t4login.application.chart.chartdata.IDataPointValue;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.DataField;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.render.CompoundRenderer;
import com.t4login.application.chart.render.IChartRenderer;
import com.t4login.application.chart.render.IRendererFactory;
import com.t4login.application.chart.render.IStudyLineRenderer;
import com.t4login.application.chart.render.ISummaryRenderer;
import com.t4login.application.chart.scales.IValueScale;
import com.t4login.application.chart.studies.Study;
import com.t4login.application.chart.studies.StudyCategory;
import com.t4login.application.chart.studies.StudyConfigurable;
import com.t4login.application.chart.studies.StudyDefinition;
import com.t4login.application.chart.studies.StudyType;
import com.t4login.application.configuration.Category;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.EditorType;
import com.t4login.application.configuration.IncludeConfig;
import com.t4login.application.configuration.NumberFormatF;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.Serialize;
import com.t4login.application.configuration.UserRole;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.priceconversion.PriceFormat;
import com.t4login.util.ColorUtil;
import com.t4login.util.Range;
import com.t4login.util.TextUtils;
import java.util.ArrayList;

@StudyDefinition(id="CHANN", nameResId="chart_chann_study_name", descrResId="chart_chann_study_descr", category=StudyCategory.Overlay, type=StudyType.Overlay, userRole=UserRole.Basic)
public class PriceChannelsStudy
extends Study {
    private static final String TAG = "PriceChannelsStudy";
    private static StudyDefinition DEF = PriceChannelsStudy.class.getAnnotation(StudyDefinition.class);
    private final Configuration mConfig;
    private final IStudyLineRenderer mTopRenderer;
    private final IStudyLineRenderer mBottomRenderer;
    private final IStudyLineRenderer mAvgRenderer;
    private CompoundRenderer mRenderer;
    private final ISummaryRenderer mSummary;
    private DataSeries<ChannValue> mData = new DataSeries("CHANN");
    private DataDefinition mDataDef = null;

    public PriceChannelsStudy(ChartContext ccontext) {
        this(ccontext, null);
    }

    @Override
    public String getUID() {
        return this.mConfig.uid;
    }

    public PriceChannelsStudy(ChartContext ccontext, Object config) {
        super(ccontext);
        this.mConfig = config instanceof Configuration ? (Configuration)config : new Configuration("");
        IRendererFactory rendererFactory = Host.getRendererFactory();
        assert (rendererFactory != null);
        this.mTopRenderer = rendererFactory.createStudyLineRenderer();
        this.mBottomRenderer = rendererFactory.createStudyLineRenderer();
        this.mAvgRenderer = rendererFactory.createStudyLineRenderer();
        this.mRenderer = new CompoundRenderer();
        this.mRenderer.addRenderer(this.mTopRenderer);
        this.mRenderer.addRenderer(this.mBottomRenderer);
        this.mRenderer.addRenderer(this.mAvgRenderer);
        this.mSummary = rendererFactory.createSummaryRenderer();
    }

    @Override
    public StudyDefinition getStudyDefinition() {
        return DEF;
    }

    @Override
    public Configurable getConfiguration() {
        return this.mConfig;
    }

    @Override
    public IValueScale createValueScale() {
        throw new UnsupportedOperationException("Overlay studies do not support creating value scales. They should always be secondary studies.");
    }

    @Override
    public IChartRenderer getRenderer() {
        this.mTopRenderer.updateDataSource(this.mData, this.getDataDefinition().getField("UPPER")).setColor(this.mConfig.LineColor).setWidth(this.mConfig.LineThickness).setLineStyle(IChartRenderer.LineStyle.Solid).setOffset(this.mConfig.Offset);
        this.mBottomRenderer.updateDataSource(this.mData, this.getDataDefinition().getField("LOWER")).setColor(this.mConfig.LineColor).setWidth(this.mConfig.LineThickness).setLineStyle(IChartRenderer.LineStyle.Solid).setOffset(this.mConfig.Offset);
        this.mAvgRenderer.updateDataSource(this.mData, this.getDataDefinition().getField("AVG")).setColor(this.mConfig.LineColor).setWidth(this.mConfig.LineThickness).setLineStyle(IChartRenderer.LineStyle.Dotted).setOffset(this.mConfig.Offset).setHidden(!this.mConfig.DisplayChannelAvg);
        return this.mRenderer;
    }

    @Override
    protected ISummaryRenderer getSummary(NDateTime trackTime) {
        ChannValue dp;
        if (!this.mConfig.SummaryConfig.DisplaySummaries) {
            return null;
        }
        Object summText = this.mConfig.configurableName();
        if (this.mData != null && (dp = (ChannValue)this.mData.getNearestTo(trackTime)) != null) {
            ArrayList<String> summs = new ArrayList<String>();
            if (this.mConfig.SummaryConfig.DisplayChannelValues) {
                summs.add(PriceFormat.convertPriceToDisplayFormat(dp.Upper, this.getMarket()));
            }
            if (this.mConfig.SummaryConfig.DisplayChannelAverageValue) {
                summs.add(PriceFormat.convertPriceToDisplayFormat(dp.Avg, this.getMarket()));
            }
            if (this.mConfig.SummaryConfig.DisplayChannelValues) {
                summs.add(PriceFormat.convertPriceToDisplayFormat(dp.Lower, this.getMarket()));
            }
            if (summs.size() > 0) {
                summText = (String)summText + " " + TextUtils.join((CharSequence)" - ", summs);
            }
        }
        this.mSummary.setText((String)summText).setIcon(ISummaryRenderer.SummaryIcon.Oscillator);
        return this.mSummary;
    }

    @Override
    public Range<Double> getValueRange(Range<NDateTime> timeRange) {
        return this.mData.getValueRange(timeRange);
    }

    @Override
    public Range<NDateTime> getTimeRange() {
        return this.mData.getTimeRange();
    }

    @Override
    public Integer getPreceedingIntervals() {
        return null;
    }

    @Override
    protected void onUpdateStudy() {
        if (this.mData.getCount() == 0) {
            this.compute(null);
        } else {
            ChannValue startpt = null;
            BarDataSeries ser = this.getBarData();
            IBarDataPoint basept = ser.baseDataPoint;
            if (basept != null) {
                ChannValue lastpt = (ChannValue)this.mData.getLast();
                while (lastpt != null && lastpt.Time.compareTo(basept.getTime()) > 0) {
                    this.mData.removeDataPoint(lastpt);
                }
                startpt = lastpt = (ChannValue)this.mData.getLast();
            }
            if (startpt == null) {
                startpt = (ChannValue)this.mData.getLast();
            }
            this.compute(startpt);
        }
    }

    @Override
    protected void onRecomputeStudy() {
        this.mData.clear();
        this.compute(null);
        if (this.mAvgRenderer != null) {
            this.mAvgRenderer.updateDataSource(this.mData, this.getDataDefinition().getPrimaryField());
        }
    }

    @Override
    protected void onResetStudy() {
        this.mData.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compute(ChannValue startpt) {
        int startidx = 0;
        int offset = this.mConfig.Offset + 1;
        BarDataSeries series = this.getBarData();
        if (startpt != null) {
            startidx = startpt.DataIndex;
        }
        this.mData.beginUpdate();
        try {
            int nbars = series.getCount();
            for (int i = startidx; i < nbars; ++i) {
                IBarDataPoint bar = series.get(i);
                if (i < this.mConfig.Periods + offset - 1 || i >= nbars + offset) continue;
                IBarDataPoint firstbar = series.get(i - offset);
                double upper = firstbar.getHigh();
                double lower = firstbar.getLow();
                for (int j = 1; j < this.mConfig.Periods; ++j) {
                    IBarDataPoint prevbar = series.get(i - offset - j);
                    upper = prevbar.getHigh() > upper ? prevbar.getHigh() : upper;
                    lower = prevbar.getLow() < lower ? prevbar.getLow() : lower;
                }
                double avg = (upper + lower) / 2.0;
                this.mData.addDataPoint(new ChannValue(bar.getTime(), upper, lower, avg, i));
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeStudy(), Compute failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    @Override
    public DataDefinition getDataDefinition() {
        if (this.mDataDef == null) {
            this.mDataDef = new DataDefinition("CHANN");
            this.mDataDef.addField(new DataField("UPPER", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof ChannValue) {
                        ChannValue trdp = (ChannValue)dp;
                        return trdp.Upper;
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(){

                @Override
                public String getFormattedValue(double value) {
                    try {
                        return PriceFormat.convertPriceToDisplayFormat(value, PriceChannelsStudy.this.getBarData().getArgs().Market);
                    }
                    catch (Exception ex) {
                        Log.e("PriceChannelStudy.DD", "getFormattedValue(), Error.", ex);
                        return Double.toString(value);
                    }
                }
            }, false, true));
            this.mDataDef.addField(new DataField("AVG", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof ChannValue) {
                        ChannValue trdp = (ChannValue)dp;
                        return trdp.Avg;
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(){

                @Override
                public String getFormattedValue(double value) {
                    try {
                        return PriceFormat.convertPriceToDisplayFormat(value, PriceChannelsStudy.this.getBarData().getArgs().Market);
                    }
                    catch (Exception ex) {
                        Log.e("PriceChannelStudy.DD", "getFormattedValue(), Error.", ex);
                        return Double.toString(value);
                    }
                }
            }, true, true));
            this.mDataDef.addField(new DataField("LOWER", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof ChannValue) {
                        ChannValue trdp = (ChannValue)dp;
                        return trdp.Lower;
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(){

                @Override
                public String getFormattedValue(double value) {
                    try {
                        return PriceFormat.convertPriceToDisplayFormat(value, PriceChannelsStudy.this.getBarData().getArgs().Market);
                    }
                    catch (Exception ex) {
                        Log.e("PriceChannelStudy.DD", "getFormattedValue(), Error.", ex);
                        return Double.toString(value);
                    }
                }
            }, false, true));
        }
        return this.mDataDef;
    }

    @Override
    public IDataSource getDataSource() {
        return this.mData;
    }

    @Category(value="chart_chann_study")
    public static class Configuration
    extends StudyConfigurable {
        @PropertyConfig(idx=0, name="chann_periods_name", description="chann_periods_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10000.0f)
        @DefaultValue(value="20")
        public int Periods = 20;
        @PropertyConfig(idx=1, name="chann_offset_name", description="chann_offset_descr")
        @NumberFormatF(minValue=-10000.0f, maxValue=10000.0f, increment=1.0f, displayDecimals=0)
        @DefaultValue(value="0")
        public int Offset = 0;
        @PropertyConfig(idx=2, name="chann_display_channel_avg_name", description="chann_display_channel_avg_descr")
        @DefaultValue(value="true")
        public boolean DisplayChannelAvg = true;
        @PropertyConfig(idx=3, name="linecolor_name", description="linecolor_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#007FFF")
        @Serialize(value=Serialize.As.Color)
        public int LineColor = ColorUtil.rgb(0, 127, 255);
        @PropertyConfig(idx=4, name="linewidth_name", description="linewidth_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10.0f, increment=1.0f, displayDecimals=0)
        @DefaultValue(value="2")
        public int LineThickness = 2;
        @IncludeConfig(idx=5)
        @Category(value="chart_summaries")
        public final SummaryConfig SummaryConfig = new SummaryConfig();

        public Configuration(String uid) {
            super(uid);
        }

        @Override
        public String configID() {
            return DEF.id();
        }

        @Override
        public String configurableName() {
            return String.format("%s(%d)", Resource.localizeString("chart_chann_study"), this.Periods);
        }
    }

    public static class SummaryConfig
    extends Configurable {
        @PropertyConfig(idx=0, name="chart_display_summaries_name", description="chart_display_summaries_descr", editor=EditorType.Switch)
        @DefaultValue(value="true")
        public boolean DisplaySummaries = true;
        @PropertyConfig(idx=1, name="chann_summary_display_channel_values_name", description="empty")
        @DefaultValue(value="true")
        public boolean DisplayChannelValues = true;
        @PropertyConfig(idx=2, name="chann_summary_display_avg_value_name", description="empty")
        @DefaultValue(value="true")
        public boolean DisplayChannelAverageValue = true;

        @Override
        public String configID() {
            return "PriceChannelsStudy$SummaryConfig";
        }

        @Override
        public String configurableName() {
            return Resource.localizeString("chart_summaries");
        }

        @Override
        public boolean isEnabled(String propertyName) {
            if (propertyName.equals("DisplayChannelValues") && !this.DisplaySummaries) {
                return false;
            }
            return !propertyName.equals("DisplayChannelAverageValue") || this.DisplaySummaries;
        }
    }

    public static class ChannValue
    implements IDataPointValue {
        public final NDateTime Time;
        public final double Upper;
        public final double Lower;
        public final double Avg;
        public final int DataIndex;

        public ChannValue(NDateTime time, double upper, double lower, double avg, int idx) {
            this.Time = time;
            this.Upper = upper;
            this.Lower = lower;
            this.Avg = avg;
            this.DataIndex = idx;
        }

        @Override
        public double getValue() {
            return this.Avg;
        }

        @Override
        public NDateTime getTime() {
            return this.Time;
        }
    }
}

