/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.overlays;

import com.t4login.Host;
import com.t4login.Resource;
import com.t4login.application.chart.BarInterval;
import com.t4login.application.chart.ChartContext;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.render.CompoundRenderer;
import com.t4login.application.chart.render.IChartRenderer;
import com.t4login.application.chart.render.IRendererFactory;
import com.t4login.application.chart.render.IStudyPivotPointRender;
import com.t4login.application.chart.render.ISummaryRenderer;
import com.t4login.application.chart.render.LabelPosition;
import com.t4login.application.chart.scales.IValueScale;
import com.t4login.application.chart.studies.Study;
import com.t4login.application.chart.studies.StudyCategory;
import com.t4login.application.chart.studies.StudyConfigurable;
import com.t4login.application.chart.studies.StudyDefinition;
import com.t4login.application.chart.studies.StudyType;
import com.t4login.application.chart.studies.computations.PP;
import com.t4login.application.configuration.Category;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.EditorType;
import com.t4login.application.configuration.NumberFormatF;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.RequiresRole;
import com.t4login.application.configuration.Serialize;
import com.t4login.application.configuration.UserRole;
import com.t4login.datetime.NDateTime;
import com.t4login.util.ColorUtil;
import com.t4login.util.Range;
import java.util.ArrayList;
import java.util.List;

@StudyDefinition(id="PP", nameResId="chart_pp_study_name", descrResId="chart_pp_study_descr", category=StudyCategory.Overlay, type=StudyType.Overlay, userRole=UserRole.Basic)
public class PivotPointsStudy
extends Study {
    private static final String TAG = "PivotPointsStudy";
    private static StudyDefinition DEF = PivotPointsStudy.class.getAnnotation(StudyDefinition.class);
    private final Configuration mConfig;
    private PP mPP = null;
    private DataSeries<PP.PPValue> mData = new DataSeries("PP");
    private List<String> mFormulaErrors = new ArrayList<String>();
    private final IStudyPivotPointRender mR4Renderer;
    private final IStudyPivotPointRender mR3Renderer;
    private final IStudyPivotPointRender mR2Renderer;
    private final IStudyPivotPointRender mR1Renderer;
    private final IStudyPivotPointRender mPPRenderer;
    private final IStudyPivotPointRender mS1Renderer;
    private final IStudyPivotPointRender mS2Renderer;
    private final IStudyPivotPointRender mS3Renderer;
    private final IStudyPivotPointRender mS4Renderer;
    private final CompoundRenderer mRenderer;
    private final ISummaryRenderer mSummary;

    public PivotPointsStudy(ChartContext ccontext) {
        this(ccontext, null);
    }

    @Override
    public String getUID() {
        return this.mConfig.uid;
    }

    public PivotPointsStudy(ChartContext ccontext, Object config) {
        super(ccontext);
        this.mConfig = config instanceof Configuration ? (Configuration)config : new Configuration("");
        IRendererFactory rendererFactory = Host.getRendererFactory();
        assert (rendererFactory != null);
        this.mR4Renderer = rendererFactory.createStudyPivotPointRenderer();
        this.mR3Renderer = rendererFactory.createStudyPivotPointRenderer();
        this.mR2Renderer = rendererFactory.createStudyPivotPointRenderer();
        this.mR1Renderer = rendererFactory.createStudyPivotPointRenderer();
        this.mPPRenderer = rendererFactory.createStudyPivotPointRenderer();
        this.mS1Renderer = rendererFactory.createStudyPivotPointRenderer();
        this.mS2Renderer = rendererFactory.createStudyPivotPointRenderer();
        this.mS3Renderer = rendererFactory.createStudyPivotPointRenderer();
        this.mS4Renderer = rendererFactory.createStudyPivotPointRenderer();
        this.mRenderer = new CompoundRenderer();
        this.mRenderer.addRenderer(this.mR4Renderer);
        this.mRenderer.addRenderer(this.mS4Renderer);
        this.mRenderer.addRenderer(this.mR3Renderer);
        this.mRenderer.addRenderer(this.mS3Renderer);
        this.mRenderer.addRenderer(this.mR2Renderer);
        this.mRenderer.addRenderer(this.mS2Renderer);
        this.mRenderer.addRenderer(this.mR1Renderer);
        this.mRenderer.addRenderer(this.mS1Renderer);
        this.mRenderer.addRenderer(this.mPPRenderer);
        this.mSummary = rendererFactory.createSummaryRenderer();
    }

    @Override
    public boolean getUsesCustomBarInterval() {
        return true;
    }

    @Override
    public BarInterval getCustomBarInterval() {
        return BarInterval.Bar1Day;
    }

    @Override
    public StudyDefinition getStudyDefinition() {
        return DEF;
    }

    @Override
    public Configurable getConfiguration() {
        return this.mConfig;
    }

    @Override
    public IValueScale createValueScale() {
        throw new UnsupportedOperationException("Overlay studies do not support creating value scales. They should always be secondary studies.");
    }

    @Override
    public IChartRenderer getRenderer() {
        this.mR4Renderer.updateDateSource(this.mData, this.mPP.getDataDefinition().getField("R4")).setColor(this.mConfig.R4LineColor).setWidth(this.mConfig.LineThickness).setDrawHistoricalValues(this.mConfig.DisplayHistoricalValues).setLabelPosition(this.mConfig.LineLabelPosition).setHidden(this.mConfig.CustomSRLevels < 4.0f || this.mConfig.Method.getSRLevels() < 4);
        this.mR3Renderer.updateDateSource(this.mData, this.mPP.getDataDefinition().getField("R3")).setColor(this.mConfig.R3LineColor).setWidth(this.mConfig.LineThickness).setDrawHistoricalValues(this.mConfig.DisplayHistoricalValues).setLabelPosition(this.mConfig.LineLabelPosition).setHidden(this.mConfig.CustomSRLevels < 3.0f || this.mConfig.Method.getSRLevels() < 3);
        this.mR2Renderer.updateDateSource(this.mData, this.mPP.getDataDefinition().getField("R2")).setColor(this.mConfig.R2LineColor).setWidth(this.mConfig.LineThickness).setDrawHistoricalValues(this.mConfig.DisplayHistoricalValues).setLabelPosition(this.mConfig.LineLabelPosition).setHidden(this.mConfig.CustomSRLevels < 2.0f || this.mConfig.Method.getSRLevels() < 2);
        this.mR1Renderer.updateDateSource(this.mData, this.mPP.getDataDefinition().getField("R1")).setColor(this.mConfig.R1LineColor).setWidth(this.mConfig.LineThickness).setDrawHistoricalValues(this.mConfig.DisplayHistoricalValues).setLabelPosition(this.mConfig.LineLabelPosition).setHidden(this.mConfig.CustomSRLevels < 1.0f || this.mConfig.Method.getSRLevels() < 1);
        this.mPPRenderer.updateDateSource(this.mData, this.mPP.getDataDefinition().getField("PP")).setColor(this.mConfig.PPLineColor).setWidth(this.mConfig.LineThickness).setDrawHistoricalValues(this.mConfig.DisplayHistoricalValues).setLabelPosition(this.mConfig.LineLabelPosition);
        this.mS1Renderer.updateDateSource(this.mData, this.mPP.getDataDefinition().getField("S1")).setColor(this.mConfig.S1LineColor).setWidth(this.mConfig.LineThickness).setDrawHistoricalValues(this.mConfig.DisplayHistoricalValues).setLabelPosition(this.mConfig.LineLabelPosition).setHidden(this.mConfig.CustomSRLevels < 1.0f || this.mConfig.Method.getSRLevels() < 1);
        this.mS2Renderer.updateDateSource(this.mData, this.mPP.getDataDefinition().getField("S2")).setColor(this.mConfig.S2LineColor).setWidth(this.mConfig.LineThickness).setDrawHistoricalValues(this.mConfig.DisplayHistoricalValues).setLabelPosition(this.mConfig.LineLabelPosition).setHidden(this.mConfig.CustomSRLevels < 2.0f || this.mConfig.Method.getSRLevels() < 2);
        this.mS3Renderer.updateDateSource(this.mData, this.mPP.getDataDefinition().getField("S3")).setColor(this.mConfig.S3LineColor).setWidth(this.mConfig.LineThickness).setDrawHistoricalValues(this.mConfig.DisplayHistoricalValues).setLabelPosition(this.mConfig.LineLabelPosition).setHidden(this.mConfig.CustomSRLevels < 3.0f || this.mConfig.Method.getSRLevels() < 3);
        this.mS4Renderer.updateDateSource(this.mData, this.mPP.getDataDefinition().getField("S4")).setColor(this.mConfig.S4LineColor).setWidth(this.mConfig.LineThickness).setDrawHistoricalValues(this.mConfig.DisplayHistoricalValues).setLabelPosition(this.mConfig.LineLabelPosition).setHidden(this.mConfig.CustomSRLevels < 4.0f || this.mConfig.Method.getSRLevels() < 4);
        return this.mRenderer;
    }

    @Override
    protected ISummaryRenderer getSummary(NDateTime trackTime) {
        this.mSummary.setText(this.mConfig.configurableName());
        return this.mSummary;
    }

    @Override
    public Range<Double> getValueRange(Range<NDateTime> timeRange) {
        return this.mData.getValueRange(timeRange);
    }

    @Override
    public Range<NDateTime> getTimeRange() {
        return this.mData.getTimeRange();
    }

    @Override
    public Integer getPreceedingIntervals() {
        return this.mConfig.BarsBack + 1;
    }

    @Override
    protected void onUpdateStudy() {
        if (this.mPP == null) {
            String[] formulas = new String[]{this.mConfig.R4CustomFormula, this.mConfig.R3CustomFormula, this.mConfig.R2CustomFormula, this.mConfig.R1CustomFormula, this.mConfig.PPCustomFormula, this.mConfig.S1CustomFormula, this.mConfig.S2CustomFormula, this.mConfig.S3CustomFormula, this.mConfig.S4CustomFormula};
            this.mPP = new PP(this.getBarData(), this.mConfig.Method, formulas, this.mConfig.BarsBack, this.mData);
            this.mPP.reCompute();
        } else {
            this.mPP.update();
        }
    }

    @Override
    protected void onRecomputeStudy() {
        String[] formulas = new String[]{this.mConfig.R4CustomFormula, this.mConfig.R3CustomFormula, this.mConfig.R2CustomFormula, this.mConfig.R1CustomFormula, this.mConfig.PPCustomFormula, this.mConfig.S1CustomFormula, this.mConfig.S2CustomFormula, this.mConfig.S3CustomFormula, this.mConfig.S4CustomFormula};
        this.mPP = new PP(this.getBarData(), this.mConfig.Method, formulas, this.mConfig.BarsBack, this.mData);
        this.mPP.reCompute();
        if (this.mRenderer != null) {
            boolean alignToTradeDate = this.getBarData().getArgs().Interval.compareTo(BarInterval.Bar1Day) >= 0;
            this.mR4Renderer.updateDateSource(this.mData, this.mPP.getDataDefinition().getField("R4"), alignToTradeDate);
            this.mR3Renderer.updateDateSource(this.mData, this.mPP.getDataDefinition().getField("R3"), alignToTradeDate);
            this.mR2Renderer.updateDateSource(this.mData, this.mPP.getDataDefinition().getField("R2"), alignToTradeDate);
            this.mR1Renderer.updateDateSource(this.mData, this.mPP.getDataDefinition().getField("R1"), alignToTradeDate);
            this.mPPRenderer.updateDateSource(this.mData, this.mPP.getDataDefinition().getField("PP"), alignToTradeDate);
            this.mS1Renderer.updateDateSource(this.mData, this.mPP.getDataDefinition().getField("S1"), alignToTradeDate);
            this.mS2Renderer.updateDateSource(this.mData, this.mPP.getDataDefinition().getField("S2"), alignToTradeDate);
            this.mS3Renderer.updateDateSource(this.mData, this.mPP.getDataDefinition().getField("S3"), alignToTradeDate);
            this.mS4Renderer.updateDateSource(this.mData, this.mPP.getDataDefinition().getField("S4"), alignToTradeDate);
        }
    }

    @Override
    protected void onResetStudy() {
        this.mData.clear();
    }

    @Override
    public DataDefinition getDataDefinition() {
        if (this.mPP == null) {
            String[] formulas = new String[]{this.mConfig.R4CustomFormula, this.mConfig.R3CustomFormula, this.mConfig.R2CustomFormula, this.mConfig.R1CustomFormula, this.mConfig.PPCustomFormula, this.mConfig.S1CustomFormula, this.mConfig.S2CustomFormula, this.mConfig.S3CustomFormula, this.mConfig.S4CustomFormula};
            this.mPP = new PP(this.getBarData(), this.mConfig.Method, formulas, this.mConfig.BarsBack, this.mData);
        }
        return this.mPP.getDataDefinition();
    }

    @Override
    public IDataSource getDataSource() {
        return this.mData;
    }

    @Category(value="chart_pp_study")
    public static class Configuration
    extends StudyConfigurable {
        @PropertyConfig(idx=0, name="pp_barsback_name", description="pp_barsback_descr")
        @DefaultValue(value="1")
        public int BarsBack = 1;
        @PropertyConfig(idx=1, name="pp_displayhistoricalvalues_name", description="pp_displayhistoricalvalues_descr")
        @DefaultValue(value="false")
        public boolean DisplayHistoricalValues = false;
        @PropertyConfig(idx=2, name="pp_computationmethod_name", description="pp_computationmethod_descr")
        @DefaultValue(value="Floor")
        public PP.PPMethod Method = PP.PPMethod.Floor;
        @PropertyConfig(idx=3, name="pp_customsrlevels_name", description="pp_customsrlevels_descr")
        @NumberFormatF(minValue=0.0f, maxValue=4.0f, increment=1.0f, displayDecimals=0)
        @DefaultValue(value="2")
        public float CustomSRLevels = 2.0f;
        @PropertyConfig(idx=4, name="pp_displaymidpoints_name", description="pp_displaymidpoints_descr")
        @DefaultValue(value="false")
        @RequiresRole(value=UserRole.NotAllowed)
        public boolean DisplayMidpoints = false;
        @PropertyConfig(idx=10, name="pp_r4formula_name", description="empty", editor=EditorType.PivotScriptEditor)
        @DefaultValue(value="")
        public String R4CustomFormula = "";
        @PropertyConfig(idx=10, name="pp_r4formula_name", description="empty", editor=EditorType.PivotScriptEditor, restorable=false)
        public String R4Description = "";
        @PropertyConfig(idx=11, name="pp_r4linecolor_name", description="empty", editor=EditorType.ColorPicker)
        @DefaultValue(value="#006400")
        @Serialize(value=Serialize.As.Color)
        public int R4LineColor = ColorUtil.rgb(0, 100, 0);
        @PropertyConfig(idx=12, name="pp_r3formula_name", description="empty", editor=EditorType.PivotScriptEditor)
        @DefaultValue(value="H + (2 * (PP - L))")
        public String R3CustomFormula = "H + (2 * (PP - L))";
        @PropertyConfig(idx=12, name="pp_r3formula_name", description="empty", editor=EditorType.PivotScriptEditor, restorable=false)
        public String R3Description = "";
        @PropertyConfig(idx=13, name="pp_r3linecolor_name", description="empty", editor=EditorType.ColorPicker)
        @DefaultValue(value="#006400")
        @Serialize(value=Serialize.As.Color)
        public int R3LineColor = ColorUtil.rgb(0, 100, 0);
        @PropertyConfig(idx=14, name="pp_r2formula_name", description="empty", editor=EditorType.PivotScriptEditor)
        @DefaultValue(value="PP + RANGE")
        public String R2CustomFormula = "PP + RANGE";
        @PropertyConfig(idx=14, name="pp_r2formula_name", description="empty", editor=EditorType.PivotScriptEditor, restorable=false)
        public String R2Description = "";
        @PropertyConfig(idx=15, name="pp_r2linecolor_name", description="empty", editor=EditorType.ColorPicker)
        @DefaultValue(value="#006400")
        @Serialize(value=Serialize.As.Color)
        public int R2LineColor = ColorUtil.rgb(0, 100, 0);
        @PropertyConfig(idx=16, name="pp_r1formula_name", description="empty", editor=EditorType.PivotScriptEditor)
        @DefaultValue(value="2 * PP - L")
        public String R1CustomFormula = "2 * PP - L";
        @PropertyConfig(idx=16, name="pp_r1formula_name", description="empty", editor=EditorType.PivotScriptEditor, restorable=false)
        public String R1Description = "";
        @PropertyConfig(idx=17, name="pp_r1linecolor_name", description="empty", editor=EditorType.ColorPicker)
        @DefaultValue(value="#006400")
        @Serialize(value=Serialize.As.Color)
        public int R1LineColor = ColorUtil.rgb(0, 100, 0);
        @PropertyConfig(idx=30, name="pp_ppformula_name", description="empty", editor=EditorType.PivotScriptEditor)
        @DefaultValue(value="(H + L + C)/3")
        public String PPCustomFormula = "(H + L + C)/3";
        @PropertyConfig(idx=30, name="pp_ppformula_name", description="empty", editor=EditorType.PivotScriptEditor, restorable=false)
        public String PPDescription = "";
        @PropertyConfig(idx=31, name="pp_pplinecolor_name", description="empty", editor=EditorType.ColorPicker)
        @DefaultValue(value="#0000FF")
        @Serialize(value=Serialize.As.Color)
        public int PPLineColor = ColorUtil.rgb(0, 0, 255);
        @PropertyConfig(idx=40, name="pp_s1formula_name", description="empty", editor=EditorType.PivotScriptEditor)
        @DefaultValue(value="2 * PP - H")
        public String S1CustomFormula = "2 * PP - H";
        @PropertyConfig(idx=40, name="pp_s1formula_name", description="empty", editor=EditorType.PivotScriptEditor, restorable=false)
        public String S1Description = "";
        @PropertyConfig(idx=41, name="pp_s1linecolor_name", description="empty", editor=EditorType.ColorPicker)
        @DefaultValue(value="#FF8C00")
        @Serialize(value=Serialize.As.Color)
        public int S1LineColor = ColorUtil.rgb(255, 140, 0);
        @PropertyConfig(idx=42, name="pp_s2formula_name", description="empty", editor=EditorType.PivotScriptEditor)
        @DefaultValue(value="PP - RANGE")
        public String S2CustomFormula = "PP - RANGE";
        @PropertyConfig(idx=42, name="pp_s2formula_name", description="empty", editor=EditorType.PivotScriptEditor, restorable=false)
        public String S2Description = "";
        @PropertyConfig(idx=43, name="pp_s2linecolor_name", description="empty", editor=EditorType.ColorPicker)
        @DefaultValue(value="#FF8C00")
        @Serialize(value=Serialize.As.Color)
        public int S2LineColor = ColorUtil.rgb(255, 140, 0);
        @PropertyConfig(idx=44, name="pp_s3formula_name", description="empty", editor=EditorType.PivotScriptEditor)
        @DefaultValue(value="L - (2 * (HIGH - PP))")
        public String S3CustomFormula = "L - (2 * (HIGH - PP))";
        @PropertyConfig(idx=44, name="pp_s3formula_name", description="empty", editor=EditorType.PivotScriptEditor, restorable=false)
        public String S3Description = "";
        @PropertyConfig(idx=45, name="pp_s3linecolor_name", description="empty", editor=EditorType.ColorPicker)
        @DefaultValue(value="#FF8C00")
        @Serialize(value=Serialize.As.Color)
        public int S3LineColor = ColorUtil.rgb(255, 140, 0);
        @PropertyConfig(idx=46, name="pp_s4formula_name", description="empty", editor=EditorType.PivotScriptEditor)
        @DefaultValue(value="")
        public String S4CustomFormula = "";
        @PropertyConfig(idx=46, name="pp_s4formula_name", description="empty", editor=EditorType.PivotScriptEditor, restorable=false)
        public String S4Description = "";
        @PropertyConfig(idx=47, name="pp_s4linecolor_name", description="empty", editor=EditorType.ColorPicker)
        @DefaultValue(value="#FF8C00")
        @Serialize(value=Serialize.As.Color)
        public int S4LineColor = ColorUtil.rgb(255, 140, 0);
        @PropertyConfig(idx=60, name="linewidth_name", description="linewidth_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10.0f, increment=1.0f, displayDecimals=0)
        @DefaultValue(value="1")
        public int LineThickness = 1;
        @PropertyConfig(idx=61, name="pp_labelposition_name", description="pp_labelposition_descr")
        @DefaultValue(value="Right")
        @RequiresRole(value=UserRole.NotAllowed)
        public LabelPosition LineLabelPosition = LabelPosition.Right;

        public Configuration(String uid) {
            super(uid);
        }

        @Override
        public String configID() {
            return DEF.id();
        }

        @Override
        public String configurableName() {
            return String.format("%s(%s)", Resource.localizeString("chart_pp_study"), this.Method);
        }

        @Override
        public boolean filterProperty(String propertyName) {
            if (propertyName.equals("R4CustomFormula")) {
                return this.Method != PP.PPMethod.Custom;
            }
            if (propertyName.equals("R3CustomFormula")) {
                return this.Method != PP.PPMethod.Custom;
            }
            if (propertyName.equals("R2CustomFormula")) {
                return this.Method != PP.PPMethod.Custom;
            }
            if (propertyName.equals("R1CustomFormula")) {
                return this.Method != PP.PPMethod.Custom;
            }
            if (propertyName.equals("PPCustomFormula")) {
                return this.Method != PP.PPMethod.Custom;
            }
            if (propertyName.equals("S1CustomFormula")) {
                return this.Method != PP.PPMethod.Custom;
            }
            if (propertyName.equals("S2CustomFormula")) {
                return this.Method != PP.PPMethod.Custom;
            }
            if (propertyName.equals("S3CustomFormula")) {
                return this.Method != PP.PPMethod.Custom;
            }
            if (propertyName.equals("S4CustomFormula")) {
                return this.Method != PP.PPMethod.Custom;
            }
            if (propertyName.equals("R4Description")) {
                return this.Method == PP.PPMethod.Demark || this.Method == PP.PPMethod.Custom || this.Method.getSRLevels() < 4;
            }
            if (propertyName.equals("R3Description")) {
                return this.Method == PP.PPMethod.Demark || this.Method == PP.PPMethod.Custom || this.Method.getSRLevels() < 3;
            }
            if (propertyName.equals("R2Description")) {
                return this.Method == PP.PPMethod.Demark || this.Method == PP.PPMethod.Custom || this.Method.getSRLevels() < 2;
            }
            if (propertyName.equals("R1Description")) {
                return this.Method == PP.PPMethod.Demark || this.Method == PP.PPMethod.Custom || this.Method.getSRLevels() < 1;
            }
            if (propertyName.equals("PPDescription")) {
                return this.Method == PP.PPMethod.Demark || this.Method == PP.PPMethod.Custom;
            }
            if (propertyName.equals("S1Description")) {
                return this.Method == PP.PPMethod.Demark || this.Method == PP.PPMethod.Custom || this.Method.getSRLevels() < 1;
            }
            if (propertyName.equals("S2Description")) {
                return this.Method == PP.PPMethod.Demark || this.Method == PP.PPMethod.Custom || this.Method.getSRLevels() < 2;
            }
            if (propertyName.equals("S3Description")) {
                return this.Method == PP.PPMethod.Demark || this.Method == PP.PPMethod.Custom || this.Method.getSRLevels() < 3;
            }
            if (propertyName.equals("S4Description")) {
                return this.Method == PP.PPMethod.Demark || this.Method == PP.PPMethod.Custom || this.Method.getSRLevels() < 4;
            }
            if (propertyName.equals("R4LineColor")) {
                return this.Method.getSRLevels() < 4;
            }
            if (propertyName.equals("R3LineColor")) {
                return this.Method.getSRLevels() < 3;
            }
            if (propertyName.equals("R2LineColor")) {
                return this.Method.getSRLevels() < 2;
            }
            if (propertyName.equals("R1LineColor")) {
                return this.Method.getSRLevels() < 1;
            }
            if (propertyName.equals("S1LineColor")) {
                return this.Method.getSRLevels() < 1;
            }
            if (propertyName.equals("S2LineColor")) {
                return this.Method.getSRLevels() < 2;
            }
            if (propertyName.equals("S3LineColor")) {
                return this.Method.getSRLevels() < 3;
            }
            if (propertyName.equals("S4LineColor")) {
                return this.Method.getSRLevels() < 4;
            }
            return super.filterProperty(propertyName);
        }

        @Override
        public boolean isEnabled(String propertyName) {
            if (propertyName.equals("R4Description")) {
                return false;
            }
            if (propertyName.equals("R3Description")) {
                return false;
            }
            if (propertyName.equals("R2Description")) {
                return false;
            }
            if (propertyName.equals("R1Description")) {
                return false;
            }
            if (propertyName.equals("PPDescription")) {
                return false;
            }
            if (propertyName.equals("S1Description")) {
                return false;
            }
            if (propertyName.equals("S2Description")) {
                return false;
            }
            if (propertyName.equals("S3Description")) {
                return false;
            }
            if (propertyName.equals("S4Description")) {
                return false;
            }
            return super.isEnabled(propertyName);
        }

        @Override
        public boolean propertyUpdated(String propertyName) {
            if (propertyName.equals("Method")) {
                switch (this.Method) {
                    case Floor: {
                        this.R4Description = "";
                        this.R3Description = "H + (2 * (PP - L))";
                        this.R2Description = "PP + RANGE";
                        this.R1Description = "2 * PP - L";
                        this.PPDescription = "(H + L + C)/3";
                        this.S1Description = "2 * PP - H";
                        this.S2Description = "PP - Range";
                        this.S3Description = "L - (2 * (High - PP))";
                        this.S4Description = "";
                        break;
                    }
                    case Woodie: {
                        this.R4Description = "PP + (RANGE * 3)";
                        this.R3Description = "H + (2 * (PP - L))";
                        this.R2Description = "PP + RANGE";
                        this.R1Description = "2 * PP - L";
                        this.PPDescription = "(H + L + (2 * O[1])) / 4";
                        this.S1Description = "2 * PP - H";
                        this.S2Description = "PP - RANGE";
                        this.S3Description = "L - (2 * (H - PP))";
                        this.S4Description = "PP - (RANGE * 3)";
                        break;
                    }
                    case Camarilla: {
                        this.R4Description = "CLOSE + (RANGE * 1.1 / 2)";
                        this.R3Description = "C + (RANGE * 1.1 / 4)";
                        this.R2Description = "C + (RANGE * 1.1 / 6)";
                        this.R1Description = "C + (RANGE * 1.1 / 12)";
                        this.PPDescription = "(H + L + C) / 3";
                        this.S1Description = "C - (RANGE * 1.1 / 12)";
                        this.S2Description = "C - (RANGE * 1.1 / 6)";
                        this.S3Description = "CLOSE - (RANGE * 1.1 / 4)";
                        this.S4Description = "CLOSE - (RANGE * 1.1 / 2)";
                        break;
                    }
                    case Demark: {
                        this.R4Description = "";
                        this.R3Description = "";
                        this.R2Description = "";
                        this.R1Description = "";
                        this.PPDescription = "";
                        this.S1Description = "";
                        this.S2Description = "";
                        this.S3Description = "";
                        this.S4Description = "";
                        break;
                    }
                    case Fibonacci: {
                        this.R4Description = "";
                        this.R3Description = "PP + RANGE";
                        this.R2Description = "PP + (0.618 * RANGE)";
                        this.R1Description = "PP + (0.382 * RANGE)";
                        this.PPDescription = "(H + L + C) / 3";
                        this.S1Description = "PP - (0.382 * RANGE)";
                        this.S2Description = "PP - (0.618 * RANGE)";
                        this.S3Description = "PP - RANGE";
                        this.S4Description = "";
                        break;
                    }
                    case HLC: {
                        this.R4Description = "";
                        this.R3Description = "";
                        this.R2Description = "";
                        this.R1Description = "HIGH";
                        this.PPDescription = "CLOSE";
                        this.S1Description = "LOW";
                        this.S2Description = "";
                        this.S3Description = "";
                        this.S4Description = "";
                        break;
                    }
                    default: {
                        this.R4Description = this.Method.getDescription();
                        this.R3Description = this.Method.getDescription();
                        this.R2Description = this.Method.getDescription();
                        this.R1Description = this.Method.getDescription();
                        this.PPDescription = this.Method.getDescription();
                        this.S1Description = this.Method.getDescription();
                        this.S2Description = this.Method.getDescription();
                        this.S3Description = this.Method.getDescription();
                        this.S4Description = this.Method.getDescription();
                    }
                }
                return true;
            }
            return super.propertyUpdated(propertyName);
        }
    }
}

