/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.overlays;

import com.t4login.Host;
import com.t4login.Resource;
import com.t4login.application.chart.ChartContext;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.render.IChartRenderer;
import com.t4login.application.chart.render.IRendererFactory;
import com.t4login.application.chart.render.IStudyPointRenderer;
import com.t4login.application.chart.render.ISummaryRenderer;
import com.t4login.application.chart.scales.IValueScale;
import com.t4login.application.chart.studies.Study;
import com.t4login.application.chart.studies.StudyCategory;
import com.t4login.application.chart.studies.StudyConfigurable;
import com.t4login.application.chart.studies.StudyDefinition;
import com.t4login.application.chart.studies.StudyType;
import com.t4login.application.chart.studies.computations.ParabolicSAR;
import com.t4login.application.configuration.Category;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.EditorType;
import com.t4login.application.configuration.IncludeConfig;
import com.t4login.application.configuration.NumberFormatF;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.Serialize;
import com.t4login.application.configuration.UserRole;
import com.t4login.application.settings.AppSettings;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.priceconversion.IPriceFormatArgs;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.definitions.priceconversion.PriceFormat;
import com.t4login.util.ColorUtil;
import com.t4login.util.Range;

@StudyDefinition(id="PSAR", nameResId="chart_psar_study_name", descrResId="chart_psar_study_descr", category=StudyCategory.Overlay, type=StudyType.Overlay, userRole=UserRole.Basic)
public class ParabolicSARStudy
extends Study {
    private static final String TAG = "ParabolicSARStudy";
    private static StudyDefinition DEF = ParabolicSARStudy.class.getAnnotation(StudyDefinition.class);
    private final Configuration mConfig;
    private ParabolicSAR mPSAR = null;
    private DataSeries mData = new DataSeries("PSAR");
    private final IStudyPointRenderer mPSARRenderer;
    private final ISummaryRenderer mSummary;

    public ParabolicSARStudy(ChartContext ccontext) {
        this(ccontext, null);
    }

    @Override
    public String getUID() {
        return this.mConfig.uid;
    }

    public ParabolicSARStudy(ChartContext ccontext, Object config) {
        super(ccontext);
        this.mConfig = config instanceof Configuration ? (Configuration)config : new Configuration("");
        IRendererFactory rendererFactory = Host.getRendererFactory();
        assert (rendererFactory != null);
        this.mPSARRenderer = rendererFactory.createStudyPointRenderer();
        this.mSummary = rendererFactory.createSummaryRenderer();
    }

    @Override
    public StudyDefinition getStudyDefinition() {
        return DEF;
    }

    @Override
    public Configurable getConfiguration() {
        return this.mConfig;
    }

    @Override
    public IValueScale createValueScale() {
        throw new UnsupportedOperationException("Overlay studies do not support creating value scales. They should always be secondary studies.");
    }

    @Override
    public IChartRenderer getRenderer() {
        this.mPSARRenderer.updateDateSource(this.mData, this.mPSAR.getDataDefinition().getPrimaryField()).setColor(this.mConfig.PointColor).setPointSize(this.mConfig.PointSize).setPointStyle(IStudyPointRenderer.PointStyle.Box).setStrokeWidth(1.0f);
        return this.mPSARRenderer;
    }

    @Override
    protected ISummaryRenderer getSummary(NDateTime trackTime) {
        ParabolicSAR.SARValue dp;
        if (!this.mConfig.SummaryConfig.DisplaySummaries) {
            return null;
        }
        Object summText = this.mConfig.configurableName();
        if (this.mConfig.SummaryConfig.DisplayPSARValue && this.mPSAR != null && (dp = (ParabolicSAR.SARValue)this.mData.getNearestTo(trackTime)) != null) {
            summText = (String)summText + " " + PriceFormat.convertPriceToDisplayFormat(Price.of(dp.SAR).roundToNearest(this.getMarket()), (IPriceFormatArgs)this.getMarket(), AppSettings.instance.MarketData.PriceDisplay);
        }
        this.mSummary.setText((String)summText).setIcon(ISummaryRenderer.SummaryIcon.Sar);
        return this.mSummary;
    }

    @Override
    public Range<Double> getValueRange(Range<NDateTime> timeRange) {
        return this.mData.getValueRange(timeRange);
    }

    @Override
    public Range<NDateTime> getTimeRange() {
        return this.mData.getTimeRange();
    }

    @Override
    public Integer getPreceedingIntervals() {
        return null;
    }

    @Override
    protected void onUpdateStudy() {
        if (this.mPSAR == null) {
            this.mPSAR = new ParabolicSAR(this.getBarData(), this.mConfig.AccelerationFactor, this.mConfig.MaxAccelerationFactor, this.mData);
            this.mPSAR.reCompute();
        } else {
            this.mPSAR.update();
        }
    }

    @Override
    protected void onRecomputeStudy() {
        this.mPSAR = new ParabolicSAR(this.getBarData(), this.mConfig.AccelerationFactor, this.mConfig.MaxAccelerationFactor, this.mData);
        this.mPSAR.reCompute();
        if (this.mPSARRenderer != null) {
            this.mPSARRenderer.updateDateSource(this.mData, this.mPSAR.getDataDefinition().getPrimaryField());
        }
    }

    @Override
    protected void onResetStudy() {
        this.mData.clear();
    }

    @Override
    public DataDefinition getDataDefinition() {
        if (this.mPSAR == null) {
            this.mPSAR = new ParabolicSAR(this.getBarData(), this.mConfig.AccelerationFactor, this.mConfig.MaxAccelerationFactor, this.mData);
        }
        return this.mPSAR.getDataDefinition();
    }

    @Override
    public IDataSource getDataSource() {
        return this.mData;
    }

    @Category(value="chart_psar_study")
    public static class Configuration
    extends StudyConfigurable {
        @PropertyConfig(idx=0, name="psar_acceleration_factor_name", description="psar_acceleration_factor_descr")
        @NumberFormatF(minValue=0.0f, maxValue=1.0f, increment=0.001f, displayDecimals=3)
        @DefaultValue(value="0.02")
        public double AccelerationFactor = 0.02;
        @PropertyConfig(idx=1, name="psar_max_acceleration_factor_name", description="psar_max_acceleration_factor_descr")
        @NumberFormatF(minValue=0.0f, maxValue=1.0f, increment=0.001f, displayDecimals=3)
        @DefaultValue(value="0.20")
        public double MaxAccelerationFactor = 0.2;
        @PropertyConfig(idx=3, name="pointcolor_name", description="pointcolor_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#0000FF")
        @Serialize(value=Serialize.As.Color)
        public int PointColor = ColorUtil.rgb(0, 0, 255);
        @PropertyConfig(idx=4, name="pointsize_name", description="pointsize_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10.0f, increment=1.0f, displayDecimals=0)
        @DefaultValue(value="3")
        public int PointSize = 3;
        @IncludeConfig(idx=5)
        @Category(value="chart_summaries")
        public final SummaryConfig SummaryConfig = new SummaryConfig();

        public Configuration(String uid) {
            super(uid);
        }

        @Override
        public String configID() {
            return DEF.id();
        }

        @Override
        public String configurableName() {
            return String.format("%s(%.3f,%.3f)", Resource.localizeString("chart_psar_study"), this.AccelerationFactor, this.MaxAccelerationFactor);
        }
    }

    public static class SummaryConfig
    extends Configurable {
        @PropertyConfig(idx=0, name="chart_display_summaries_name", description="chart_display_summaries_descr", editor=EditorType.Switch)
        @DefaultValue(value="true")
        public boolean DisplaySummaries = true;
        @PropertyConfig(idx=1, name="psar_summary_display_psar_value_name", description="empty")
        @DefaultValue(value="true")
        public boolean DisplayPSARValue = true;

        @Override
        public String configID() {
            return "ParabolicSARStudy$SummaryConfig";
        }

        @Override
        public String configurableName() {
            return Resource.localizeString("chart_summaries");
        }

        @Override
        public boolean isEnabled(String propertyName) {
            return !propertyName.equals("DisplayPSARValue") || this.DisplaySummaries;
        }
    }
}

