/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.overlays;

import com.t4login.Host;
import com.t4login.Log;
import com.t4login.Resource;
import com.t4login.application.chart.ChartContext;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.IBarDataPoint;
import com.t4login.application.chart.chartdata.IDataPoint;
import com.t4login.application.chart.chartdata.IDataPointValue;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.DataField;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.render.CompoundRenderer;
import com.t4login.application.chart.render.IChartRenderer;
import com.t4login.application.chart.render.IRendererFactory;
import com.t4login.application.chart.render.IStudyLineRenderer;
import com.t4login.application.chart.render.IStudyRibbonRenderer;
import com.t4login.application.chart.render.ISummaryRenderer;
import com.t4login.application.chart.scales.IValueScale;
import com.t4login.application.chart.studies.Study;
import com.t4login.application.chart.studies.StudyCategory;
import com.t4login.application.chart.studies.StudyConfigurable;
import com.t4login.application.chart.studies.StudyDefinition;
import com.t4login.application.chart.studies.StudyType;
import com.t4login.application.chart.studies.computations.HighLowAvg;
import com.t4login.application.configuration.Category;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.EditorType;
import com.t4login.application.configuration.IncludeConfig;
import com.t4login.application.configuration.NumberFormatF;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.Serialize;
import com.t4login.application.configuration.UserRole;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.priceconversion.IPriceFormatArgs;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.definitions.priceconversion.PriceFormat;
import com.t4login.util.ColorUtil;
import com.t4login.util.Range;
import com.t4login.util.TextUtils;
import java.util.ArrayList;

@StudyDefinition(id="IHK", nameResId="chart_ihk_study_name", descrResId="chart_ihk_study_descr", category=StudyCategory.Overlay, type=StudyType.Overlay, userRole=UserRole.Basic)
public class IchimokuCloudStudy
extends Study {
    private static final String TAG = "IchimokuCloudStudy";
    private static StudyDefinition DEF = IchimokuCloudStudy.class.getAnnotation(StudyDefinition.class);
    private final Configuration mConfig;
    private HighLowAvg mConv = null;
    private HighLowAvg mBase = null;
    private HighLowAvg mLeadB = null;
    private DataSeries<LeadSpanAValue> mLeadSpanAData = new DataSeries("IHK");
    private final IStudyLineRenderer mConversionLineRenderer;
    private final IStudyLineRenderer mBaseLineRenderer;
    private final IStudyRibbonRenderer mRibbonRenderer;
    private final IStudyLineRenderer mLeadingSpanALineRenderer;
    private final IStudyLineRenderer mLeadingSpanBLineRenderer;
    private final IStudyLineRenderer mLaggingLineRenderer;
    private CompoundRenderer mRenderer;
    private final ISummaryRenderer mSummary;
    private DataDefinition mDataDef = null;

    public IchimokuCloudStudy(ChartContext ccontext) {
        this(ccontext, null);
    }

    @Override
    public String getUID() {
        return this.mConfig.uid;
    }

    public IchimokuCloudStudy(ChartContext ccontext, Object config) {
        super(ccontext);
        this.mConfig = config instanceof Configuration ? (Configuration)config : new Configuration("");
        IRendererFactory rendererFactory = Host.getRendererFactory();
        assert (rendererFactory != null);
        this.mConversionLineRenderer = rendererFactory.createStudyLineRenderer();
        this.mBaseLineRenderer = rendererFactory.createStudyLineRenderer();
        this.mRibbonRenderer = rendererFactory.createStudyRibbonRenderer();
        this.mLeadingSpanALineRenderer = rendererFactory.createStudyLineRenderer();
        this.mLeadingSpanBLineRenderer = rendererFactory.createStudyLineRenderer();
        this.mLaggingLineRenderer = rendererFactory.createStudyLineRenderer();
        this.mRenderer = new CompoundRenderer();
        this.mRenderer.addRenderer(this.mConversionLineRenderer);
        this.mRenderer.addRenderer(this.mBaseLineRenderer);
        this.mRenderer.addRenderer(this.mRibbonRenderer);
        this.mRenderer.addRenderer(this.mLeadingSpanALineRenderer);
        this.mRenderer.addRenderer(this.mLeadingSpanBLineRenderer);
        this.mRenderer.addRenderer(this.mLaggingLineRenderer);
        this.mSummary = rendererFactory.createSummaryRenderer();
    }

    @Override
    public StudyDefinition getStudyDefinition() {
        return DEF;
    }

    @Override
    public Configurable getConfiguration() {
        return this.mConfig;
    }

    @Override
    public IValueScale createValueScale() {
        throw new UnsupportedOperationException("Overlay studies do not support creating value scales. They should always be secondary studies.");
    }

    @Override
    public IChartRenderer getRenderer() {
        this.mConversionLineRenderer.updateDataSource(this.mConv.getDataSource(), this.mConv.getDataDefinition().getField("AVG")).setColor(this.mConfig.ConversionLineColor).setWidth(this.mConfig.ConversionLineWidth).setLineStyle(IChartRenderer.LineStyle.Solid);
        this.mBaseLineRenderer.updateDataSource(this.mBase.getDataSource(), this.mBase.getDataDefinition().getField("AVG")).setColor(this.mConfig.BaseLineColor).setWidth(this.mConfig.BaseLineWidth).setLineStyle(IChartRenderer.LineStyle.Solid);
        this.mRibbonRenderer.updateDataSource(this.mLeadSpanAData, this.getDataDefinition().getField("LEADA"), this.mLeadB.getDataSource(), this.mLeadB.getDataDefinition().getField("AVG")).setColorA(this.mConfig.LeadingSpanAColor).setColorB(this.mConfig.LeadingSpanBColor).setAlpha(55).setOffset(this.mConfig.BaseLinePeriods);
        this.mLeadingSpanALineRenderer.updateDataSource(this.mLeadSpanAData, this.getDataDefinition().getField("LEADA")).setColor(this.mConfig.LeadingSpanAColor).setWidth(3.0f).setLineStyle(IChartRenderer.LineStyle.Solid).setOffset(this.mConfig.BaseLinePeriods);
        this.mLeadingSpanBLineRenderer.updateDataSource(this.mLeadB.getDataSource(), this.mLeadB.getDataDefinition().getField("AVG")).setColor(this.mConfig.LeadingSpanBColor).setWidth(3.0f).setLineStyle(IChartRenderer.LineStyle.Solid).setOffset(this.mConfig.BaseLinePeriods);
        BarDataSeries barser = this.getBarData();
        this.mLaggingLineRenderer.updateDataSource(barser, barser.getDataDefinition().getField("CLOSE")).setOffset(-1 * this.mConfig.BaseLinePeriods).setColor(this.mConfig.LaggingSpanColor).setWidth(this.mConfig.LaggingSpanWidth);
        return this.mRenderer;
    }

    @Override
    protected ISummaryRenderer getSummary(NDateTime trackTime) {
        if (!this.mConfig.SummaryConfig.DisplaySummaries) {
            return null;
        }
        Object summText = this.mConfig.configurableName();
        if (this.mConv != null) {
            Price summPrice;
            ArrayList<String> summs = new ArrayList<String>();
            if (this.mConfig.SummaryConfig.DisplayConversionValue) {
                HighLowAvg.HLAValue convdp = (HighLowAvg.HLAValue)this.mConv.getDataSource().getNearestTo(trackTime);
                if (convdp != null) {
                    summPrice = Price.of(convdp.Average).roundToNearest(this.getMarket());
                    summs.add(PriceFormat.convertPriceToDisplayFormat(summPrice, (IPriceFormatArgs)this.getMarket()));
                } else {
                    summs.add(".");
                }
            }
            if (this.mConfig.SummaryConfig.DisplayBaseValue) {
                HighLowAvg.HLAValue basedp = (HighLowAvg.HLAValue)this.mBase.getDataSource().getNearestTo(trackTime);
                if (basedp != null) {
                    summPrice = Price.of(basedp.Average).roundToNearest(this.getMarket());
                    summs.add(PriceFormat.convertPriceToDisplayFormat(summPrice, (IPriceFormatArgs)this.getMarket()));
                } else {
                    summs.add(".");
                }
            }
            if (this.mConfig.SummaryConfig.DisplayLeadSpanAValue) {
                LeadSpanAValue leadspanadp = (LeadSpanAValue)this.mLeadSpanAData.getNearestTo(trackTime);
                if (leadspanadp != null) {
                    summPrice = Price.of(leadspanadp.LeadingA).roundToNearest(this.getMarket());
                    summs.add(PriceFormat.convertPriceToDisplayFormat(summPrice, (IPriceFormatArgs)this.getMarket()));
                } else {
                    summs.add(".");
                }
            }
            if (this.mConfig.SummaryConfig.DisplayLeadSpanBValue) {
                HighLowAvg.HLAValue leadspanbdp = (HighLowAvg.HLAValue)this.mLeadB.getDataSource().getNearestTo(trackTime);
                if (leadspanbdp != null) {
                    summPrice = Price.of(leadspanbdp.Average).roundToNearest(this.getMarket());
                    summs.add(PriceFormat.convertPriceToDisplayFormat(summPrice, (IPriceFormatArgs)this.getMarket()));
                } else {
                    summs.add(".");
                }
            }
            if (this.mConfig.SummaryConfig.DisplayLaggingSpanValue) {
                BarDataSeries ser = this.getBarData();
                IBarDataPoint bar = ser.getNearestTo(trackTime);
                if (bar != null) {
                    summs.add(PriceFormat.convertPriceToDisplayFormat(bar.getClose(), this.getMarket()));
                } else {
                    summs.add(".");
                }
            }
            if (summs.size() > 0) {
                summText = (String)summText + " " + TextUtils.join((CharSequence)" - ", summs);
            }
        }
        this.mSummary.setText((String)summText).setIcon(ISummaryRenderer.SummaryIcon.Oscillator);
        return this.mSummary;
    }

    @Override
    public Range<Double> getValueRange(Range<NDateTime> timeRange) {
        Range<Double> range = ((DataSeries)this.mConv.getDataSource()).getValueRange(timeRange);
        range = range.expanded(((DataSeries)this.mBase.getDataSource()).getValueRange(timeRange));
        range = range.expanded(this.mLeadSpanAData.getValueRange(timeRange));
        range = range.expanded(((DataSeries)this.mLeadB.getDataSource()).getValueRange(timeRange));
        return range;
    }

    @Override
    public Range<NDateTime> getTimeRange() {
        Range<NDateTime> range = this.mConv.getDataSource().getTimeRange();
        range = range.condensed(this.mBase.getDataSource().getTimeRange());
        range = range.condensed(this.mLeadB.getDataSource().getTimeRange());
        range = range.condensed(this.mLeadSpanAData.getTimeRange());
        return range;
    }

    @Override
    public Integer getPreceedingIntervals() {
        return null;
    }

    @Override
    protected void onUpdateStudy() {
        if (this.mConv == null) {
            this.onRecomputeStudy();
        } else {
            LeadSpanAValue startpt = null;
            BarDataSeries ser = this.getBarData();
            IBarDataPoint basept = ser.baseDataPoint;
            if (basept != null) {
                LeadSpanAValue lastpt = (LeadSpanAValue)this.mLeadSpanAData.getLast();
                while (lastpt != null && lastpt.Time.compareTo(basept.getTime()) > 0) {
                    this.mLeadSpanAData.removeDataPoint(lastpt);
                }
                startpt = lastpt = (LeadSpanAValue)this.mLeadSpanAData.getLast();
            }
            if (startpt == null) {
                startpt = (LeadSpanAValue)this.mLeadSpanAData.getLast();
            }
            this.compute(startpt);
        }
    }

    @Override
    protected void onRecomputeStudy() {
        this.mLeadSpanAData.clear();
        BarDataSeries ser = this.getBarData();
        this.mConv = new HighLowAvg(ser, ser.getDataDefinition().getField("HIGH"), ser.getDataDefinition().getField("LOW"), this.mConfig.ConversionLinePeriods, 0);
        this.mBase = new HighLowAvg(ser, ser.getDataDefinition().getField("HIGH"), ser.getDataDefinition().getField("LOW"), this.mConfig.BaseLinePeriods, 0);
        this.mLeadB = new HighLowAvg(ser, ser.getDataDefinition().getField("HIGH"), ser.getDataDefinition().getField("LOW"), this.mConfig.LeadSpanBPeriods, 0);
        this.mConv.reCompute();
        this.mBase.reCompute();
        this.mLeadB.reCompute();
        this.compute(null);
        if (this.mConversionLineRenderer != null) {
            this.mConversionLineRenderer.updateDataSource(this.mConv.getDataSource(), this.mConv.getDataDefinition().getField("AVG"));
            this.mBaseLineRenderer.updateDataSource(this.mBase.getDataSource(), this.mBase.getDataDefinition().getField("AVG"));
            this.mRibbonRenderer.updateDataSource(this.mLeadSpanAData, this.getDataDefinition().getField("LEADA"), this.mLeadB.getDataSource(), this.mLeadB.getDataDefinition().getField("AVG"));
            this.mLeadingSpanALineRenderer.updateDataSource(this.mLeadSpanAData, this.getDataDefinition().getField("LEADA"));
            this.mLeadingSpanBLineRenderer.updateDataSource(this.mLeadB.getDataSource(), this.mLeadB.getDataDefinition().getField("AVG"));
            BarDataSeries barser = this.getBarData();
            this.mLaggingLineRenderer.updateDataSource(barser, barser.getDataDefinition().getField("CLOSE"));
        }
    }

    @Override
    protected void onResetStudy() {
        this.mLeadSpanAData.clear();
        this.mConv.reset();
        this.mBase.reset();
        this.mLeadB.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compute(LeadSpanAValue startpt) {
        int startidx = 0;
        if (startpt != null) {
            startidx = startpt.DataIndex;
        }
        if (this.mConv == null || this.mBase == null || this.mConv.getDataSource().getCount() == 0) {
            return;
        }
        this.mLeadSpanAData.beginUpdate();
        try {
            IDataSource convser = this.mConv.getDataSource();
            IDataSource baseser = this.mBase.getDataSource();
            int npoints = convser.getCount();
            for (int i = startidx; i < npoints; ++i) {
                HighLowAvg.HLAValue convdp = (HighLowAvg.HLAValue)convser.get(i);
                HighLowAvg.HLAValue basedp = (HighLowAvg.HLAValue)baseser.get(convdp.getTime());
                if (basedp == null) continue;
                double leadspana = (convdp.Average + basedp.Average) / 2.0;
                this.mLeadSpanAData.addDataPoint(new LeadSpanAValue(convdp.getTime(), leadspana, i));
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeStudy(), Compute failed.", ex);
        }
        finally {
            this.mLeadSpanAData.endUpdate();
        }
    }

    @Override
    public DataDefinition getDataDefinition() {
        if (this.mDataDef == null) {
            this.mDataDef = new DataDefinition("LEADSPANA");
            this.mDataDef.addField(new DataField("LEADA", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof LeadSpanAValue) {
                        LeadSpanAValue trdp = (LeadSpanAValue)dp;
                        return trdp.LeadingA;
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(){

                @Override
                public String getFormattedValue(double value) {
                    try {
                        return PriceFormat.convertPriceToDisplayFormat(value, IchimokuCloudStudy.this.getBarData().getArgs().Market);
                    }
                    catch (Exception ex) {
                        Log.e("IchimokuCloudStudy.DD", "getFormattedValue(), Error.", ex);
                        return Double.toString(value);
                    }
                }
            }, true, true));
        }
        return this.mDataDef;
    }

    @Override
    public IDataSource getDataSource() {
        return this.mLeadSpanAData;
    }

    @Category(value="chart_ihk_study")
    public static class Configuration
    extends StudyConfigurable {
        @PropertyConfig(idx=0, name="ihk_conv_line_periods_name", description="ihk_conv_line_periods_descr")
        @NumberFormatF(minValue=0.0f, maxValue=10000.0f)
        @DefaultValue(value="9")
        public int ConversionLinePeriods = 9;
        @PropertyConfig(idx=1, name="ihk_conv_line_color_name", description="ihk_conv_line_color_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#0000FF")
        @Serialize(value=Serialize.As.Color)
        public int ConversionLineColor = ColorUtil.rgb(0, 0, 255);
        @PropertyConfig(idx=2, name="ihk_conv_line_width_name", description="ihk_conv_line_width_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10.0f, increment=1.0f, displayDecimals=0)
        @DefaultValue(value="2")
        public int ConversionLineWidth = 2;
        @PropertyConfig(idx=3, name="ihk_base_line_periods_name", description="ihk_base_line_periods_descr")
        @NumberFormatF(minValue=0.0f, maxValue=10000.0f)
        @DefaultValue(value="26")
        public int BaseLinePeriods = 26;
        @PropertyConfig(idx=4, name="ihk_base_line_color_name", description="ihk_base_line_color_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#FF0000")
        @Serialize(value=Serialize.As.Color)
        public int BaseLineColor = ColorUtil.rgb(255, 0, 0);
        @PropertyConfig(idx=5, name="ihk_base_line_width_name", description="ihk_base_line_width_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10.0f, increment=1.0f, displayDecimals=0)
        @DefaultValue(value="2")
        public int BaseLineWidth = 2;
        @PropertyConfig(idx=6, name="ihk_leadspan_b_periods_name", description="ihk_leadspan_b_periods_descr")
        @NumberFormatF(minValue=0.0f, maxValue=10000.0f)
        @DefaultValue(value="52")
        public int LeadSpanBPeriods = 52;
        @PropertyConfig(idx=7, name="ihk_leadspan_a_color_name", description="ihk_leadspan_a_color_name", editor=EditorType.ColorPicker)
        @DefaultValue(value="#FF0000")
        @Serialize(value=Serialize.As.Color)
        public int LeadingSpanAColor = ColorUtil.rgb(0, 255, 0);
        @PropertyConfig(idx=8, name="ihk_leadspan_b_color_name", description="ihk_leadspan_b_color_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#FF0000")
        @Serialize(value=Serialize.As.Color)
        public int LeadingSpanBColor = -65536;
        @PropertyConfig(idx=9, name="ihk_laggingspan_line_color_name", description="empty", editor=EditorType.ColorPicker)
        @DefaultValue(value="#2E6900")
        @Serialize(value=Serialize.As.Color)
        public int LaggingSpanColor = ColorUtil.rgb(46, 105, 0);
        @PropertyConfig(idx=10, name="ihk_laggingspan_line_width_name", description="empty")
        @NumberFormatF(minValue=1.0f, maxValue=10.0f, increment=1.0f, displayDecimals=0)
        @DefaultValue(value="4")
        public int LaggingSpanWidth = 4;
        @IncludeConfig(idx=20)
        @Category(value="chart_summaries")
        public final SummaryConfig SummaryConfig = new SummaryConfig();

        public Configuration(String uid) {
            super(uid);
        }

        @Override
        public String configID() {
            return DEF.id();
        }

        @Override
        public String configurableName() {
            return String.format("%s(%d,%d,%d)", Resource.localizeString("chart_ihk_study"), this.ConversionLinePeriods, this.BaseLinePeriods, this.LeadSpanBPeriods);
        }
    }

    public static class SummaryConfig
    extends Configurable {
        @PropertyConfig(idx=0, name="chart_display_summaries_name", description="chart_display_summaries_descr", editor=EditorType.Switch)
        @DefaultValue(value="true")
        public boolean DisplaySummaries = true;
        @PropertyConfig(idx=1, name="ihk_summary_display_conversion_values_name", description="empty")
        @DefaultValue(value="false")
        public boolean DisplayConversionValue = false;
        @PropertyConfig(idx=2, name="ihk_summary_display_base_values_name", description="empty")
        @DefaultValue(value="false")
        public boolean DisplayBaseValue = false;
        @PropertyConfig(idx=3, name="ihk_summary_display_leadspan_a_values_name", description="empty")
        @DefaultValue(value="false")
        public boolean DisplayLeadSpanAValue = false;
        @PropertyConfig(idx=4, name="ihk_summary_display_leadspan_b_values_name", description="empty")
        @DefaultValue(value="false")
        public boolean DisplayLeadSpanBValue = false;
        @PropertyConfig(idx=5, name="ihk_summary_display_laggingspan_values_name", description="empty")
        @DefaultValue(value="false")
        public boolean DisplayLaggingSpanValue = false;

        @Override
        public String configID() {
            return "IchimokuCloudStudy$SummaryConfig";
        }

        @Override
        public String configurableName() {
            return Resource.localizeString("chart_summaries");
        }

        @Override
        public boolean isEnabled(String propertyName) {
            if (propertyName.equals("DisplayConversionValue") && !this.DisplaySummaries) {
                return false;
            }
            if (propertyName.equals("DisplayBaseValue") && !this.DisplaySummaries) {
                return false;
            }
            if (propertyName.equals("DisplayLeadSpanAValue") && !this.DisplaySummaries) {
                return false;
            }
            if (propertyName.equals("DisplayLeadSpanBValue") && !this.DisplaySummaries) {
                return false;
            }
            return !propertyName.equals("DisplayLaggingSpanValue") || this.DisplaySummaries;
        }
    }

    public static class LeadSpanAValue
    implements IDataPointValue {
        public final NDateTime Time;
        public final double LeadingA;
        public final int DataIndex;

        public LeadSpanAValue(NDateTime time, double leada, int idx) {
            this.Time = time;
            this.LeadingA = leada;
            this.DataIndex = idx;
        }

        @Override
        public double getValue() {
            return this.LeadingA;
        }

        @Override
        public NDateTime getTime() {
            return this.Time;
        }
    }
}

