/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.overlays;

import com.t4login.Host;
import com.t4login.Resource;
import com.t4login.application.chart.ChartContext;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.chartdata.dataprovider.specialized.BandDataSourceWrapper;
import com.t4login.application.chart.render.CompoundRenderer;
import com.t4login.application.chart.render.IChartRenderer;
import com.t4login.application.chart.render.IRendererFactory;
import com.t4login.application.chart.render.IStudyLineRenderer;
import com.t4login.application.chart.render.ISummaryRenderer;
import com.t4login.application.chart.scales.IValueScale;
import com.t4login.application.chart.studies.Study;
import com.t4login.application.chart.studies.StudyCategory;
import com.t4login.application.chart.studies.StudyConfigurable;
import com.t4login.application.chart.studies.StudyDefinition;
import com.t4login.application.chart.studies.StudyType;
import com.t4login.application.chart.studies.computations.BarMovingAverage;
import com.t4login.application.chart.studies.computations.MAPriceType;
import com.t4login.application.chart.studies.computations.MAType;
import com.t4login.application.configuration.Category;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.EditorType;
import com.t4login.application.configuration.IncludeConfig;
import com.t4login.application.configuration.NumberFormatF;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.Serialize;
import com.t4login.application.configuration.UserRole;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.priceconversion.IPriceFormatArgs;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.definitions.priceconversion.PriceFormat;
import com.t4login.util.ColorUtil;
import com.t4login.util.Range;
import com.t4login.util.TextUtils;
import java.util.ArrayList;

@StudyDefinition(id="BB", nameResId="chart_bb_study_name", descrResId="chart_bb_study_descr", category=StudyCategory.Overlay, type=StudyType.Overlay, userRole=UserRole.Basic)
public class BollingerBands
extends Study {
    private static final String TAG = "BollingerBands";
    private static StudyDefinition DEF = BollingerBands.class.getAnnotation(StudyDefinition.class);
    private final Configuration mConfig;
    private BarMovingAverage mMA = null;
    private BandDataSourceWrapper mBands = null;
    private DataSeries mData = new DataSeries("MovAvg");
    private final IStudyLineRenderer mTopRenderer;
    private final IStudyLineRenderer mBottomRenderer;
    private final IStudyLineRenderer mAvgRenderer;
    private final CompoundRenderer mRenderer;
    private final ISummaryRenderer mSummary;

    public BollingerBands(ChartContext ccontext) {
        this(ccontext, null);
    }

    @Override
    public String getUID() {
        return this.mConfig.uid;
    }

    public BollingerBands(ChartContext ccontext, Object config) {
        super(ccontext);
        this.mConfig = config instanceof Configuration ? (Configuration)config : new Configuration("");
        IRendererFactory rendererFactory = Host.getRendererFactory();
        assert (rendererFactory != null);
        this.mTopRenderer = rendererFactory.createStudyLineRenderer();
        this.mBottomRenderer = rendererFactory.createStudyLineRenderer();
        this.mAvgRenderer = rendererFactory.createStudyLineRenderer();
        this.mRenderer = new CompoundRenderer();
        this.mRenderer.addRenderer(this.mTopRenderer);
        this.mRenderer.addRenderer(this.mBottomRenderer);
        this.mRenderer.addRenderer(this.mAvgRenderer);
        this.mSummary = rendererFactory.createSummaryRenderer();
    }

    @Override
    public StudyDefinition getStudyDefinition() {
        return DEF;
    }

    @Override
    public Configurable getConfiguration() {
        return this.mConfig;
    }

    @Override
    public IValueScale createValueScale() {
        throw new UnsupportedOperationException("Overlay studies do not support creating value scales. They should always be secondary studies.");
    }

    @Override
    public IChartRenderer getRenderer() {
        this.mTopRenderer.updateDataSource(this.mBands, this.mBands.getDataDefinition().getField("TOP")).setColor(this.mConfig.LineColor).setWidth(this.mConfig.LineThickness).setLineStyle(IChartRenderer.LineStyle.Solid).setOffset(this.mConfig.Offset);
        this.mBottomRenderer.updateDataSource(this.mBands, this.mBands.getDataDefinition().getField("BOTTOM")).setColor(this.mConfig.LineColor).setWidth(this.mConfig.LineThickness).setLineStyle(IChartRenderer.LineStyle.Solid).setOffset(this.mConfig.Offset);
        this.mAvgRenderer.updateDataSource(this.mBands, this.mBands.getDataDefinition().getField("BASE")).setColor(this.mConfig.LineColor).setWidth(this.mConfig.LineThickness).setLineStyle(IChartRenderer.LineStyle.Dotted).setOffset(this.mConfig.Offset).setHidden(!this.mConfig.DisplayMovAvgLine);
        return this.mRenderer;
    }

    @Override
    protected ISummaryRenderer getSummary(NDateTime trackTime) {
        BandDataSourceWrapper.BandValue dp;
        if (!this.mConfig.SummaryConfig.DisplaySummaries) {
            return null;
        }
        Object summText = this.mConfig.configurableName();
        if (this.mBands != null && (dp = (BandDataSourceWrapper.BandValue)this.mBands.getDataSource().getNearestTo(trackTime)) != null) {
            ArrayList<String> summs = new ArrayList<String>();
            if (this.mConfig.SummaryConfig.DisplayBandValues) {
                Price topPrice = Price.of(dp.TopValue).roundToNearest(this.getMarket());
                summs.add(PriceFormat.convertPriceToDisplayFormat(topPrice, (IPriceFormatArgs)this.getMarket()));
            }
            if (this.mConfig.SummaryConfig.DisplaySMAValue) {
                Price maPrice = Price.of(dp.BaseValue).roundToNearest(this.getMarket());
                summs.add(PriceFormat.convertPriceToDisplayFormat(maPrice, (IPriceFormatArgs)this.getMarket()));
            }
            if (this.mConfig.SummaryConfig.DisplayBandValues) {
                Price bottomPrice = Price.of(dp.BottomValue).roundToNearest(this.getMarket());
                summs.add(PriceFormat.convertPriceToDisplayFormat(bottomPrice, (IPriceFormatArgs)this.getMarket()));
            }
            if (summs.size() > 0) {
                summText = (String)summText + " " + TextUtils.join((CharSequence)", ", summs);
            }
        }
        this.mSummary.setText((String)summText).setIcon(ISummaryRenderer.SummaryIcon.Oscillator);
        return this.mSummary;
    }

    @Override
    public Range<Double> getValueRange(Range<NDateTime> timeRange) {
        if (this.mBands != null) {
            return this.mBands.getValueRange(timeRange);
        }
        return this.mData.getValueRange(timeRange);
    }

    @Override
    public Range<NDateTime> getTimeRange() {
        return this.mData.getTimeRange();
    }

    @Override
    public Integer getPreceedingIntervals() {
        return null;
    }

    @Override
    protected void onUpdateStudy() {
        if (this.mMA == null) {
            this.mMA = new BarMovingAverage(this.getBarData(), MAType.SMA, this.mConfig.PriceType, this.mConfig.Periods, this.mData);
            this.mBands = new BandDataSourceWrapper(this.mData, this.mMA.getDataDefinition().getPrimaryField(), this.mMA.getDataDefinition().getField("STDDEV"), this.mConfig.BandDeviations, true);
            this.mMA.reCompute();
        } else {
            this.mMA.update();
        }
    }

    @Override
    protected void onRecomputeStudy() {
        this.mMA = new BarMovingAverage(this.getBarData(), MAType.SMA, this.mConfig.PriceType, this.mConfig.Periods, this.mData);
        this.mBands = new BandDataSourceWrapper(this.mData, this.mMA.getDataDefinition().getPrimaryField(), this.mMA.getDataDefinition().getField("STDDEV"), this.mConfig.BandDeviations, true);
        this.mMA.reCompute();
        if (this.mRenderer != null) {
            this.mTopRenderer.updateDataSource(this.mBands, this.mBands.getDataDefinition().getField("TOP"));
            this.mBottomRenderer.updateDataSource(this.mBands, this.mBands.getDataDefinition().getField("BOTTOM"));
            this.mAvgRenderer.updateDataSource(this.mBands, this.mBands.getDataDefinition().getField("BASE"));
        }
    }

    @Override
    protected void onResetStudy() {
        this.mData.clear();
    }

    @Override
    public DataDefinition getDataDefinition() {
        if (this.mMA == null) {
            this.mMA = new BarMovingAverage(this.getBarData(), MAType.SMA, this.mConfig.PriceType, this.mConfig.Periods, this.mData);
            this.mBands = new BandDataSourceWrapper(this.mData, this.mMA.getDataDefinition().getPrimaryField(), this.mMA.getDataDefinition().getField("STDDEV"), this.mConfig.BandDeviations, true);
        }
        return this.mMA.getDataDefinition();
    }

    @Override
    public IDataSource getDataSource() {
        return this.mData;
    }

    @Category(value="chart_bb_study")
    public static class Configuration
    extends StudyConfigurable {
        @PropertyConfig(idx=0, name="ma_pricetype_name", description="ma_pricetype_descr")
        @DefaultValue(value="Closing")
        public MAPriceType PriceType = MAPriceType.Closing;
        @PropertyConfig(idx=1, name="ma_periods_name", description="ma_periods_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10000.0f)
        @DefaultValue(value="20")
        public int Periods = 20;
        @PropertyConfig(idx=2, name="ma_offset_name", description="ma_offset_descr")
        @NumberFormatF(minValue=-10000.0f, maxValue=10000.0f, increment=1.0f, displayDecimals=0)
        @DefaultValue(value="0")
        public int Offset = 0;
        @PropertyConfig(idx=2, name="bb_banddeviations_name", description="bb_banddeviations_descr")
        @NumberFormatF(minValue=0.0f, maxValue=20.0f, increment=0.25f, displayDecimals=2)
        @DefaultValue(value="2.0")
        public float BandDeviations = 2.0f;
        @PropertyConfig(idx=3, name="bb_displayavg_name", description="bb_displayavg_descr", editor=EditorType.Switch)
        @DefaultValue(value="true")
        public boolean DisplayMovAvgLine = true;
        @PropertyConfig(idx=4, name="linecolor_name", description="linecolor_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#0000FF")
        @Serialize(value=Serialize.As.Color)
        public int LineColor = ColorUtil.rgb(0, 0, 255);
        @PropertyConfig(idx=5, name="linewidth_name", description="linewidth_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10.0f, increment=1.0f, displayDecimals=0)
        @DefaultValue(value="2")
        public int LineThickness = 2;
        @IncludeConfig(idx=13)
        @Category(value="chart_summaries")
        public final SummaryConfig SummaryConfig = new SummaryConfig();

        public Configuration(String uid) {
            super(uid);
        }

        @Override
        public String configID() {
            return DEF.id();
        }

        @Override
        public String configurableName() {
            return String.format("%s(%d/%.1f)", Resource.localizeString("chart_bb_study"), this.Periods, Float.valueOf(this.BandDeviations));
        }
    }

    public static class SummaryConfig
    extends Configurable {
        @PropertyConfig(idx=0, name="chart_display_summaries_name", description="chart_display_summaries_descr", editor=EditorType.Switch)
        @DefaultValue(value="true")
        public boolean DisplaySummaries = true;
        @PropertyConfig(idx=1, name="bb_summary_display_sma_name", description="empty")
        @DefaultValue(value="true")
        public boolean DisplaySMAValue = true;
        @PropertyConfig(idx=2, name="bb_summary_display_bands_name", description="empty")
        @DefaultValue(value="true")
        public boolean DisplayBandValues = true;

        @Override
        public String configID() {
            return "BollingerBands$SummaryConfig";
        }

        @Override
        public String configurableName() {
            return Resource.localizeString("chart_summaries");
        }

        @Override
        public boolean isEnabled(String propertyName) {
            if (propertyName.equals("DisplaySMAValue") && !this.DisplaySummaries) {
                return false;
            }
            return !propertyName.equals("DisplayBandValues") || this.DisplaySummaries;
        }
    }
}

