/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.indicators;

import com.t4login.Host;
import com.t4login.Resource;
import com.t4login.application.chart.ChartContext;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.render.CompoundRenderer;
import com.t4login.application.chart.render.IChartRenderer;
import com.t4login.application.chart.render.IRendererFactory;
import com.t4login.application.chart.render.IStudyLineRenderer;
import com.t4login.application.chart.render.ISummaryRenderer;
import com.t4login.application.chart.scales.IValueScale;
import com.t4login.application.chart.scales.ValueScale;
import com.t4login.application.chart.scales.ValueScaleConfig;
import com.t4login.application.chart.studies.Study;
import com.t4login.application.chart.studies.StudyCategory;
import com.t4login.application.chart.studies.StudyConfigurable;
import com.t4login.application.chart.studies.StudyDefinition;
import com.t4login.application.chart.studies.StudyType;
import com.t4login.application.chart.studies.computations.BarRateOfChange;
import com.t4login.application.chart.studies.computations.MAPriceType;
import com.t4login.application.chart.studies.computations.MAType;
import com.t4login.application.chart.studies.computations.MovingAverage;
import com.t4login.application.configuration.Category;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.EditorType;
import com.t4login.application.configuration.IncludeConfig;
import com.t4login.application.configuration.NumberFormatF;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.Serialize;
import com.t4login.application.configuration.UserRole;
import com.t4login.datetime.NDateTime;
import com.t4login.util.ColorUtil;
import com.t4login.util.Range;
import com.t4login.util.TextUtils;
import java.util.ArrayList;
import java.util.EnumSet;

@StudyDefinition(id="ROC", nameResId="chart_roc_study_name", descrResId="chart_roc_study_descr", category=StudyCategory.Oscillator, type=StudyType.Indicator, userRole=UserRole.Basic)
public class RateOfChangeStudy
extends Study {
    private static final String TAG = "ROCStudy";
    private static StudyDefinition DEF = RateOfChangeStudy.class.getAnnotation(StudyDefinition.class);
    private final Configuration mConfig;
    private BarRateOfChange mROC = null;
    private DataSeries mData = new DataSeries();
    private MovingAverage mEMA = null;
    private DataSeries mEMAData = new DataSeries();
    private final IStudyLineRenderer mROCLineRenderer;
    private final IStudyLineRenderer mEMALineRenderer;
    private final CompoundRenderer mRenderer;
    private final ISummaryRenderer mSummary;

    public RateOfChangeStudy(ChartContext ccontext) {
        this(ccontext, null);
    }

    @Override
    public String getUID() {
        return this.mConfig.uid;
    }

    public RateOfChangeStudy(ChartContext ccontext, Object config) {
        super(ccontext);
        this.mConfig = config instanceof Configuration ? (Configuration)config : new Configuration("");
        IRendererFactory rendererFactory = Host.getRendererFactory();
        assert (rendererFactory != null);
        this.mROCLineRenderer = rendererFactory.createStudyLineRenderer();
        this.mEMALineRenderer = rendererFactory.createStudyLineRenderer();
        this.mRenderer = new CompoundRenderer();
        this.mRenderer.addRenderer(this.mROCLineRenderer);
        this.mRenderer.addRenderer(this.mEMALineRenderer);
        this.mSummary = rendererFactory.createSummaryRenderer();
    }

    @Override
    public StudyDefinition getStudyDefinition() {
        return DEF;
    }

    @Override
    public Configurable getConfiguration() {
        return this.mConfig;
    }

    @Override
    public IValueScale createValueScale() {
        EnumSet<ValueScale.ScaleBehavior> opts = EnumSet.noneOf(ValueScale.ScaleBehavior.class);
        ValueScaleConfig config = new ValueScaleConfig();
        config.DisplayDecimals = 2;
        return new ValueScale(opts, config);
    }

    @Override
    public IChartRenderer getRenderer() {
        this.mROCLineRenderer.updateDataSource(this.mData, this.mROC.getDataDefinition().getPrimaryField()).setColor(this.mConfig.LineColor).setWidth(this.mConfig.LineWidth).setLineStyle(IChartRenderer.LineStyle.Solid).setHidden(!this.mConfig.ShowROCLine);
        this.mEMALineRenderer.updateDataSource(this.mEMAData, this.mEMA.getDataDefinition().getPrimaryField()).setColor(this.mConfig.EMALineColor).setWidth(this.mConfig.EMALineWidth).setLineStyle(IChartRenderer.LineStyle.Solid).setHidden(!this.mConfig.ShowEMALine);
        return this.mRenderer;
    }

    @Override
    protected ISummaryRenderer getSummary(NDateTime trackTime) {
        if (!this.mConfig.SummaryConfig.DisplaySummaries) {
            return null;
        }
        Object summText = this.mConfig.configurableName();
        if (this.mROC != null) {
            BarRateOfChange.ROCValue roc = (BarRateOfChange.ROCValue)this.mData.getNearestTo(trackTime);
            MovingAverage.MAValue ema = (MovingAverage.MAValue)this.mEMAData.getNearestTo(trackTime);
            if (roc != null) {
                ArrayList<String> summs = new ArrayList<String>();
                if (this.mConfig.SummaryConfig.DisplayROCValue) {
                    summs.add(String.format("%.2f%%", roc.ROC));
                }
                if (ema != null && this.mConfig.SummaryConfig.DisplayEMAValue) {
                    summs.add(String.format("%.2f%%", ema.MA));
                }
                if (summs.size() > 0) {
                    summText = (String)summText + " " + TextUtils.join((CharSequence)", ", summs);
                }
            }
        }
        this.mSummary.setText((String)summText).setIcon(ISummaryRenderer.SummaryIcon.Oscillator);
        return this.mSummary;
    }

    @Override
    public Range<Double> getValueRange(Range<NDateTime> timeRange) {
        Range<Double> rng = Range.empty();
        if (this.mConfig.ShowROCLine) {
            rng = rng.expanded(this.mData.getValueRange(timeRange));
        }
        if (this.mConfig.ShowEMALine) {
            rng = rng.expanded(this.mEMAData.getValueRange(timeRange));
        }
        if (rng.isEmpty()) {
            rng = Range.of(-1.0, 1.0);
        }
        return rng;
    }

    @Override
    public Range<NDateTime> getTimeRange() {
        if (this.mConfig.ShowEMALine) {
            return this.mEMAData.getTimeRange();
        }
        return this.mData.getTimeRange();
    }

    @Override
    public Integer getPreceedingIntervals() {
        return this.mConfig.Periods + this.mConfig.EMAPeriods;
    }

    @Override
    protected void onUpdateStudy() {
        if (this.mROC == null) {
            this.onRecomputeStudy();
        } else {
            this.mROC.update();
            this.mEMA.update();
        }
    }

    @Override
    protected void onRecomputeStudy() {
        this.mROC = new BarRateOfChange(this.getBarData(), this.mConfig.PriceType, this.mConfig.Periods, this.mData);
        this.mROC.reCompute();
        this.mEMA = new MovingAverage(this.mROC, this.mROC.getDataDefinition().getPrimaryField(), MAType.EMA, this.mConfig.EMAPeriods, this.mEMAData);
        this.mEMA.reCompute();
        if (this.mRenderer != null) {
            this.mROCLineRenderer.updateDataSource(this.mData, this.mROC.getDataDefinition().getPrimaryField());
            this.mEMALineRenderer.updateDataSource(this.mEMAData, this.mEMA.getDataDefinition().getPrimaryField());
        }
    }

    @Override
    protected void onResetStudy() {
        if (this.mROC != null) {
            this.mROC.reset();
            this.mEMA.reset();
        }
        this.mData.clear();
        this.mEMAData.clear();
    }

    @Override
    public DataDefinition getDataDefinition() {
        if (this.mROC != null) {
            return this.mROC.getDataDefinition();
        }
        return null;
    }

    @Override
    public IDataSource getDataSource() {
        return this.mData;
    }

    @Category(value="chart_roc_study")
    public static class Configuration
    extends StudyConfigurable {
        @PropertyConfig(idx=0, name="roc_pricetype_name", description="roc_pricetype_descr")
        @DefaultValue(value="Closing")
        public MAPriceType PriceType = MAPriceType.Closing;
        @PropertyConfig(idx=1, name="roc_periods_name", description="roc_periods_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10000.0f)
        @DefaultValue(value="12")
        public int Periods = 12;
        @PropertyConfig(idx=2, name="roc_ema_periods_name", description="roc_ema_periods_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10000.0f)
        @DefaultValue(value="26")
        public int EMAPeriods = 26;
        @PropertyConfig(idx=3, name="roc_show_roc_line_name", description="empty", editor=EditorType.Switch)
        @DefaultValue(value="true")
        public boolean ShowROCLine = true;
        @PropertyConfig(idx=4, name="linecolor_name", description="linecolor_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#000000")
        @Serialize(value=Serialize.As.Color)
        public int LineColor = ColorUtil.rgb(128, 128, 128);
        @PropertyConfig(idx=5, name="linewidth_name", description="linewidth_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10.0f, increment=1.0f, displayDecimals=0)
        @DefaultValue(value="2")
        public int LineWidth = 2;
        @PropertyConfig(idx=6, name="roc_show_ema_line_name", description="empty", editor=EditorType.Switch)
        @DefaultValue(value="true")
        public boolean ShowEMALine = true;
        @PropertyConfig(idx=7, name="roc_ema_line_color_name", description="roc_ema_line_color_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#6495ED")
        @Serialize(value=Serialize.As.Color)
        public int EMALineColor = ColorUtil.rgb(100, 149, 237);
        @PropertyConfig(idx=8, name="roc_ema_line_width_name", description="roc_ema_line_width_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10.0f, increment=1.0f, displayDecimals=0)
        @DefaultValue(value="1")
        public int EMALineWidth = 1;
        @IncludeConfig(idx=9)
        @Category(value="chart_summaries")
        public final SummaryConfig SummaryConfig = new SummaryConfig();

        public Configuration(String uid) {
            super(uid);
        }

        @Override
        public String configID() {
            return DEF.id();
        }

        @Override
        public String configurableName() {
            return String.format("%s(%d, %d)", Resource.localizeString("chart_roc_study"), this.Periods, this.EMAPeriods);
        }

        @Override
        public boolean isEnabled(String propertyName) {
            if (propertyName.equals("LineColor") && !this.ShowROCLine) {
                return false;
            }
            if (propertyName.equals("LineWidth") && !this.ShowROCLine) {
                return false;
            }
            if (propertyName.equals("EMALineColor") && !this.ShowEMALine) {
                return false;
            }
            return !propertyName.equals("EMALineWidth") || this.ShowEMALine;
        }
    }

    public static class SummaryConfig
    extends Configurable {
        @PropertyConfig(idx=0, name="chart_display_summaries_name", description="chart_display_summaries_descr", editor=EditorType.Switch)
        @DefaultValue(value="true")
        public boolean DisplaySummaries = true;
        @PropertyConfig(idx=1, name="roc_summary_display_roc_name", description="empty")
        @DefaultValue(value="true")
        public boolean DisplayROCValue = true;
        @PropertyConfig(idx=2, name="roc_summary_display_ema_name", description="empty")
        @DefaultValue(value="true")
        public boolean DisplayEMAValue = true;

        @Override
        public String configID() {
            return "ROCStudy$SummaryConfig";
        }

        @Override
        public String configurableName() {
            return Resource.localizeString("chart_summaries");
        }

        @Override
        public boolean isEnabled(String propertyName) {
            if (propertyName.equals("DisplayROCValue") && !this.DisplaySummaries) {
                return false;
            }
            return !propertyName.equals("DisplayEMAValue") || this.DisplaySummaries;
        }
    }
}

