/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.indicators;

import com.t4login.Host;
import com.t4login.Resource;
import com.t4login.application.chart.ChartContext;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.render.CompoundRenderer;
import com.t4login.application.chart.render.IChartRenderer;
import com.t4login.application.chart.render.IRendererFactory;
import com.t4login.application.chart.render.IStudyWaveLineRenderer;
import com.t4login.application.chart.render.IStudyZeroLineRenderer;
import com.t4login.application.chart.render.ISummaryRenderer;
import com.t4login.application.chart.scales.IValueScale;
import com.t4login.application.chart.scales.ValueScale;
import com.t4login.application.chart.scales.ValueScaleConfig;
import com.t4login.application.chart.studies.Study;
import com.t4login.application.chart.studies.StudyCategory;
import com.t4login.application.chart.studies.StudyConfigurable;
import com.t4login.application.chart.studies.StudyDefinition;
import com.t4login.application.chart.studies.StudyType;
import com.t4login.application.chart.studies.computations.BarRSI;
import com.t4login.application.configuration.Category;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.EditorType;
import com.t4login.application.configuration.IncludeConfig;
import com.t4login.application.configuration.NumberFormatF;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.Serialize;
import com.t4login.application.configuration.UserRole;
import com.t4login.datetime.NDateTime;
import com.t4login.util.ColorUtil;
import com.t4login.util.Range;
import java.util.EnumSet;

@StudyDefinition(id="RSI", nameResId="chart_rsi_study_name", descrResId="chart_rsi_study_descr", category=StudyCategory.Oscillator, type=StudyType.Indicator, userRole=UserRole.Basic)
public class RSIStudy
extends Study {
    private static final String TAG = "RSIStudy";
    private static StudyDefinition DEF = RSIStudy.class.getAnnotation(StudyDefinition.class);
    private final Configuration mConfig;
    private BarRSI mRSI = null;
    private DataSeries mData = new DataSeries();
    private final IStudyWaveLineRenderer mWaveLineRenderer;
    private final IStudyZeroLineRenderer mZeroLineRenderer;
    private final IStudyZeroLineRenderer mTopLimitLineRenderer;
    private final IStudyZeroLineRenderer mBottomLimitLineRenderer;
    private final CompoundRenderer mRenderer;
    private final ISummaryRenderer mSummary;

    public RSIStudy(ChartContext ccontext) {
        this(ccontext, null);
    }

    @Override
    public String getUID() {
        return this.mConfig.uid;
    }

    public RSIStudy(ChartContext ccontext, Object config) {
        super(ccontext);
        this.mConfig = config instanceof Configuration ? (Configuration)config : new Configuration("");
        IRendererFactory rendererFactory = Host.getRendererFactory();
        assert (rendererFactory != null);
        this.mWaveLineRenderer = rendererFactory.createStudyWaveLineRenderer();
        this.mZeroLineRenderer = rendererFactory.createStudyZeroLineRenderer();
        this.mTopLimitLineRenderer = rendererFactory.createStudyZeroLineRenderer();
        this.mBottomLimitLineRenderer = rendererFactory.createStudyZeroLineRenderer();
        this.mRenderer = new CompoundRenderer();
        this.mRenderer.addRenderer(this.mWaveLineRenderer);
        this.mRenderer.addRenderer(this.mZeroLineRenderer);
        this.mRenderer.addRenderer(this.mTopLimitLineRenderer);
        this.mRenderer.addRenderer(this.mBottomLimitLineRenderer);
        this.mSummary = rendererFactory.createSummaryRenderer();
    }

    @Override
    public StudyDefinition getStudyDefinition() {
        return DEF;
    }

    @Override
    public Configurable getConfiguration() {
        return this.mConfig;
    }

    @Override
    public IValueScale createValueScale() {
        EnumSet<ValueScale.ScaleBehavior> opts = EnumSet.noneOf(ValueScale.ScaleBehavior.class);
        opts.add(ValueScale.ScaleBehavior.Tight);
        ValueScaleConfig config = new ValueScaleConfig();
        config.DisplayDecimals = 0;
        ValueScale scale = new ValueScale(opts, config);
        return scale;
    }

    @Override
    public IChartRenderer getRenderer() {
        this.mZeroLineRenderer.setLineStyle(IChartRenderer.LineStyle.Dashed).setWidth(1.0f).setValue(50.0);
        this.mTopLimitLineRenderer.setLineStyle(IChartRenderer.LineStyle.Solid).setWidth(1.0f);
        this.mBottomLimitLineRenderer.setLineStyle(IChartRenderer.LineStyle.Solid).setWidth(1.0f);
        this.mWaveLineRenderer.updateDateSource(this.mData, this.mRSI.getDataDefinition().getPrimaryField()).setLineColor(this.mConfig.LineColor).setCrestColor(this.mConfig.WavecrestColor).setWidth(this.mConfig.LineWidth).setLineStyle(IChartRenderer.LineStyle.Solid).setCenterLevel(50.0).setOverBoughtLevel(this.mConfig.OverBoughtLevel).setOverSoldLevel(this.mConfig.OverSoldLevel);
        this.mTopLimitLineRenderer.setValue(this.mConfig.OverBoughtLevel);
        this.mBottomLimitLineRenderer.setValue(this.mConfig.OverSoldLevel);
        return this.mRenderer;
    }

    @Override
    protected ISummaryRenderer getSummary(NDateTime trackTime) {
        BarRSI.RSIValue dp;
        if (!this.mConfig.SummaryConfig.DisplaySummaries) {
            return null;
        }
        Object summText = this.mConfig.configurableName();
        if (this.mConfig.SummaryConfig.DisplayRSIValue && this.mData != null && (dp = (BarRSI.RSIValue)this.mData.getNearestTo(trackTime)) != null) {
            summText = (String)summText + " " + String.format("%.2f", dp.RSI);
        }
        this.mSummary.setText((String)summText).setIcon(ISummaryRenderer.SummaryIcon.Oscillator);
        return this.mSummary;
    }

    @Override
    public Range<Double> getValueRange(Range<NDateTime> timeRange) {
        return Range.of(0.0, 100.0);
    }

    @Override
    public Range<NDateTime> getTimeRange() {
        return this.mData.getTimeRange();
    }

    @Override
    public Integer getPreceedingIntervals() {
        return this.mConfig.Periods;
    }

    @Override
    protected void onUpdateStudy() {
        if (this.mRSI == null) {
            this.onRecomputeStudy();
        } else {
            this.mRSI.update();
        }
    }

    @Override
    protected void onRecomputeStudy() {
        this.mRSI = new BarRSI(this.getBarData(), this.mConfig.Periods, this.mData);
        this.mRSI.reCompute();
        if (this.mWaveLineRenderer != null) {
            this.mWaveLineRenderer.updateDateSource(this.mData, this.mRSI.getDataDefinition().getPrimaryField());
        }
    }

    @Override
    protected void onResetStudy() {
        if (this.mRSI != null) {
            this.mRSI.reset();
        }
        this.mData.clear();
    }

    @Override
    public DataDefinition getDataDefinition() {
        if (this.mRSI != null) {
            return this.mRSI.getDataDefinition();
        }
        return null;
    }

    @Override
    public IDataSource getDataSource() {
        return this.mData;
    }

    @Category(value="chart_rsi_study")
    public static class Configuration
    extends StudyConfigurable {
        @PropertyConfig(idx=0, name="rsi_periods_name", description="rsi_periods_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10000.0f)
        @DefaultValue(value="14")
        public int Periods = 14;
        @PropertyConfig(idx=1, name="rsi_overbought_level_name", description="rsi_overbought_level_descr")
        @NumberFormatF(minValue=50.0f, maxValue=100.0f)
        @DefaultValue(value="70")
        public int OverBoughtLevel = 70;
        @PropertyConfig(idx=2, name="rsi_oversold_level_name", description="rsi_oversold_level_descr")
        @NumberFormatF(minValue=0.0f, maxValue=50.0f)
        @DefaultValue(value="30")
        public int OverSoldLevel = 30;
        @PropertyConfig(idx=3, name="linecolor_name", description="linecolor_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#00008B")
        @Serialize(value=Serialize.As.Color)
        public int LineColor = ColorUtil.rgb(0, 0, 139);
        @PropertyConfig(idx=4, name="linewidth_name", description="linewidth_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10.0f, increment=1.0f, displayDecimals=0)
        @DefaultValue(value="2")
        public int LineWidth = 2;
        @PropertyConfig(idx=5, name="wavecrest_color_name", description="wavecrest_color_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#ADD8E6")
        @Serialize(value=Serialize.As.Color)
        public int WavecrestColor = ColorUtil.rgb(173, 216, 230);
        @IncludeConfig(idx=6)
        @Category(value="chart_summaries")
        public final SummaryConfig SummaryConfig = new SummaryConfig();

        public Configuration(String uid) {
            super(uid);
        }

        @Override
        public String configID() {
            return DEF.id();
        }

        @Override
        public String configurableName() {
            return String.format("%s(%d)", Resource.localizeString("chart_rsi_study"), this.Periods);
        }
    }

    public static class SummaryConfig
    extends Configurable {
        @PropertyConfig(idx=0, name="chart_display_summaries_name", description="chart_display_summaries_descr", editor=EditorType.Switch)
        @DefaultValue(value="true")
        public boolean DisplaySummaries = true;
        @PropertyConfig(idx=1, name="rsi_summary_display_rsi_name", description="empty")
        @DefaultValue(value="true")
        public boolean DisplayRSIValue = true;

        @Override
        public String configID() {
            return "RSIStudy$SummaryConfig";
        }

        @Override
        public String configurableName() {
            return Resource.localizeString("chart_summaries");
        }

        @Override
        public boolean isEnabled(String propertyName) {
            return !propertyName.equals("DisplayRSIValue") || this.DisplaySummaries;
        }
    }
}

