/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.indicators;

import com.t4login.Host;
import com.t4login.Resource;
import com.t4login.application.chart.ChartContext;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.IDataPoint;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.render.CompoundRenderer;
import com.t4login.application.chart.render.IChartRenderer;
import com.t4login.application.chart.render.IRendererFactory;
import com.t4login.application.chart.render.IStudyIndicatorBarRenderer;
import com.t4login.application.chart.render.IStudyLineRenderer;
import com.t4login.application.chart.render.IStudyZeroLineRenderer;
import com.t4login.application.chart.render.ISummaryRenderer;
import com.t4login.application.chart.scales.IValueScale;
import com.t4login.application.chart.scales.ValueScale;
import com.t4login.application.chart.scales.ValueScaleConfig;
import com.t4login.application.chart.studies.Study;
import com.t4login.application.chart.studies.StudyCategory;
import com.t4login.application.chart.studies.StudyConfigurable;
import com.t4login.application.chart.studies.StudyDefinition;
import com.t4login.application.chart.studies.StudyType;
import com.t4login.application.chart.studies.computations.BarMovingAverage;
import com.t4login.application.chart.studies.computations.Difference;
import com.t4login.application.chart.studies.computations.MAPriceType;
import com.t4login.application.chart.studies.computations.MAType;
import com.t4login.application.chart.studies.computations.MovingAverage;
import com.t4login.application.configuration.Category;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.EditorType;
import com.t4login.application.configuration.IncludeConfig;
import com.t4login.application.configuration.NumberFormatF;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.Serialize;
import com.t4login.application.configuration.UserRole;
import com.t4login.datetime.NDateTime;
import com.t4login.util.ColorUtil;
import com.t4login.util.Range;
import com.t4login.util.TextUtils;
import java.util.ArrayList;
import java.util.EnumSet;

@StudyDefinition(id="MACD", nameResId="chart_macd_study_name", descrResId="chart_macd_study_descr", category=StudyCategory.Oscillator, type=StudyType.Indicator, userRole=UserRole.Basic)
public class MACDStudy
extends Study {
    private static final String TAG = "MACDStudy";
    private static StudyDefinition DEF = MACDStudy.class.getAnnotation(StudyDefinition.class);
    private final Configuration mConfig;
    private BarMovingAverage mEMA1 = null;
    private BarMovingAverage mEMA2 = null;
    private Difference mDiff = null;
    private DataSeries mMACD = new DataSeries();
    private MovingAverage mMACDEMA = null;
    private DataSeries mSignal = new DataSeries();
    private Difference mMACDSigDiff = null;
    private DataSeries mSignalDiff = new DataSeries();
    private IStudyLineRenderer mMACDLineRenderer = null;
    private IStudyLineRenderer mSignalLineRenderer = null;
    private IStudyIndicatorBarRenderer mHistogramRenderer = null;
    private IStudyZeroLineRenderer mZeroLineRenderer = null;
    private CompoundRenderer mRenderer = null;
    private final ISummaryRenderer mSummary;

    public MACDStudy(ChartContext ccontext) {
        this(ccontext, null);
    }

    @Override
    public String getUID() {
        return this.mConfig.uid;
    }

    public MACDStudy(ChartContext ccontext, Object config) {
        super(ccontext);
        this.mConfig = config instanceof Configuration ? (Configuration)config : new Configuration("");
        IRendererFactory rendererFactory = Host.getRendererFactory();
        assert (rendererFactory != null);
        this.mMACDLineRenderer = rendererFactory.createStudyLineRenderer();
        this.mSignalLineRenderer = rendererFactory.createStudyLineRenderer();
        this.mHistogramRenderer = rendererFactory.createStudyIndicatorBarRenderer();
        this.mZeroLineRenderer = rendererFactory.createStudyZeroLineRenderer();
        this.mRenderer = new CompoundRenderer();
        this.mRenderer.addRenderer(this.mHistogramRenderer);
        this.mRenderer.addRenderer(this.mZeroLineRenderer);
        this.mRenderer.addRenderer(this.mSignalLineRenderer);
        this.mRenderer.addRenderer(this.mMACDLineRenderer);
        this.mSummary = rendererFactory.createSummaryRenderer();
    }

    @Override
    public StudyDefinition getStudyDefinition() {
        return DEF;
    }

    @Override
    public Configurable getConfiguration() {
        return this.mConfig;
    }

    @Override
    public IValueScale createValueScale() {
        EnumSet<ValueScale.ScaleBehavior> opts = EnumSet.noneOf(ValueScale.ScaleBehavior.class);
        return new ValueScale(this.mConfig.ScaleConfig);
    }

    @Override
    public IChartRenderer getRenderer() {
        this.mMACDLineRenderer.setColor(this.mConfig.MACDLineColor).setWidth(this.mConfig.MACDLineWidth).setLineStyle(IChartRenderer.LineStyle.Solid).setHidden(!this.mConfig.ShowMACDLine);
        this.mSignalLineRenderer.setColor(this.mConfig.SignalLineColor).setWidth(this.mConfig.SignalLineWidth).setLineStyle(IChartRenderer.LineStyle.Solid).setHidden(!this.mConfig.ShowSignalLine);
        this.mHistogramRenderer.setFillColor(this.mConfig.HistogramColor).setOutlineColor(-16777216).setHidden(!this.mConfig.ShowHistogram);
        return this.mRenderer;
    }

    @Override
    protected ISummaryRenderer getSummary(NDateTime trackTime) {
        if (!this.mConfig.SummaryConfig.DisplaySummaries) {
            return null;
        }
        Object summText = this.mConfig.configurableName();
        if (this.mDiff != null) {
            Object macd = this.mDiff.getDataSource().getNearestTo(trackTime);
            Object sig = this.mMACDEMA.getDataSource().getNearestTo(trackTime);
            Object sigdiff = this.mMACDSigDiff.getDataSource().getNearestTo(trackTime);
            if (macd != null && sig != null && sigdiff != null) {
                ArrayList<String> summs = new ArrayList<String>();
                if (this.mConfig.SummaryConfig.DisplayMCADValue) {
                    double macdVal = this.mDiff.getDataDefinition().getPrimaryField().getDataPointValue((IDataPoint)macd);
                    summs.add(String.format("%.1f", macdVal));
                }
                if (this.mConfig.SummaryConfig.DisplaySignalValue) {
                    double sigVal = this.mMACDEMA.getDataDefinition().getPrimaryField().getDataPointValue((IDataPoint)sig);
                    summs.add(String.format("%.1f", sigVal));
                }
                if (this.mConfig.SummaryConfig.DisplaySignalDiffValue) {
                    double sigdiffVal = this.mMACDSigDiff.getDataDefinition().getPrimaryField().getDataPointValue((IDataPoint)sigdiff);
                    summs.add(String.format("%.1f", sigdiffVal));
                }
                if (summs.size() > 0) {
                    summText = (String)summText + " " + TextUtils.join((CharSequence)", ", summs);
                }
            }
        }
        this.mSummary.setText((String)summText).setIcon(ISummaryRenderer.SummaryIcon.Oscillator);
        return this.mSummary;
    }

    @Override
    public Range<Double> getValueRange(Range<NDateTime> timeRange) {
        Range<Double> rng = Range.empty();
        if (this.mConfig.ShowMACDLine) {
            rng = rng.expanded(this.mMACD.getValueRange(timeRange));
        }
        if (this.mConfig.ShowSignalLine) {
            rng = rng.expanded(this.mSignal.getValueRange(timeRange));
        }
        if (this.mConfig.ShowHistogram) {
            rng = rng.expanded(this.mSignalDiff.getValueRange(timeRange));
        }
        return rng;
    }

    @Override
    public Range<NDateTime> getTimeRange() {
        return this.mMACD.getTimeRange();
    }

    @Override
    public Integer getPreceedingIntervals() {
        return Math.max(this.mConfig.Periods1, this.mConfig.Periods2) + this.mConfig.SignalLinePeriods;
    }

    @Override
    protected void onUpdateStudy() {
        if (this.mEMA1 == null) {
            this.onRecomputeStudy();
        } else {
            this.mEMA1.update();
            this.mEMA2.update();
            this.mDiff.update();
            this.mMACDEMA.update();
            this.mMACDSigDiff.update();
        }
    }

    @Override
    protected void onRecomputeStudy() {
        int periods1 = Math.min(this.mConfig.Periods1, this.mConfig.Periods2);
        int periods2 = Math.max(this.mConfig.Periods1, this.mConfig.Periods2);
        this.mEMA1 = new BarMovingAverage(this.getBarData(), MAType.EMA, this.mConfig.PriceType, this.mConfig.Periods1);
        this.mEMA2 = new BarMovingAverage(this.getBarData(), MAType.EMA, this.mConfig.PriceType, this.mConfig.Periods2);
        this.mDiff = new Difference(this.mEMA1, this.mEMA1.getDataDefinition().getPrimaryField(), this.mEMA2, this.mEMA2.getDataDefinition().getPrimaryField(), Difference.DifferenceType.Difference, this.mMACD);
        this.mMACDEMA = new MovingAverage(this.mDiff, this.mDiff.getDataDefinition().getPrimaryField(), MAType.EMA, this.mConfig.SignalLinePeriods, this.mSignal);
        this.mMACDSigDiff = new Difference(this.mDiff, this.mDiff.getDataDefinition().getPrimaryField(), this.mMACDEMA, this.mMACDEMA.getDataDefinition().getPrimaryField(), Difference.DifferenceType.Difference, this.mSignalDiff);
        this.mEMA1.reCompute();
        this.mEMA2.reCompute();
        this.mDiff.reCompute();
        this.mMACDEMA.reCompute();
        this.mMACDSigDiff.reCompute();
        if (this.mRenderer != null) {
            this.mMACDLineRenderer.updateDataSource(this.mMACD, this.mDiff.getDataDefinition().getPrimaryField());
            this.mSignalLineRenderer.updateDataSource(this.mSignal, this.mMACDEMA.getDataDefinition().getPrimaryField());
            this.mHistogramRenderer.updateDateSource(this.mSignalDiff, this.mMACDSigDiff.getDataDefinition().getPrimaryField());
        }
    }

    @Override
    protected void onResetStudy() {
        this.mMACD.clear();
    }

    @Override
    public DataDefinition getDataDefinition() {
        if (this.mDiff != null) {
            return this.mDiff.getDataDefinition();
        }
        return null;
    }

    @Override
    public IDataSource getDataSource() {
        return this.mMACD;
    }

    @Category(value="chart_macd_study")
    public static class Configuration
    extends StudyConfigurable {
        @PropertyConfig(idx=0, name="ma_pricetype_name", description="ma_pricetype_descr")
        @DefaultValue(value="Closing")
        public MAPriceType PriceType = MAPriceType.Closing;
        @PropertyConfig(idx=1, name="ema1_periods_name", description="ma_periods_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10000.0f)
        @DefaultValue(value="12")
        public int Periods1 = 12;
        @PropertyConfig(idx=2, name="ema2_periods_name", description="ma_periods_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10000.0f)
        @DefaultValue(value="26")
        public int Periods2 = 26;
        @PropertyConfig(idx=3, name="signal_periods_name", description="signal_periods_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10000.0f)
        @DefaultValue(value="9")
        public int SignalLinePeriods = 9;
        @PropertyConfig(idx=4, name="macd_show_macd_line_name", description="macd_show_macd_line_descr", editor=EditorType.Switch)
        @DefaultValue(value="true")
        public boolean ShowMACDLine = true;
        @PropertyConfig(idx=5, name="macd_line_color_name", description="macd_line_color_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#000000")
        @Serialize(value=Serialize.As.Color)
        public int MACDLineColor = ColorUtil.rgb(128, 128, 128);
        @PropertyConfig(idx=6, name="macd_line_width_name", description="macd_line_width_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10.0f, increment=1.0f, displayDecimals=0)
        @DefaultValue(value="3")
        public int MACDLineWidth = 3;
        @PropertyConfig(idx=7, name="show_signal_line_name", description="show_signal_line_descr", editor=EditorType.Switch)
        @DefaultValue(value="true")
        public boolean ShowSignalLine = true;
        @PropertyConfig(idx=8, name="signal_line_color_name", description="signal_line_color_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#800080")
        @Serialize(value=Serialize.As.Color)
        public int SignalLineColor = ColorUtil.rgb(128, 0, 128);
        @PropertyConfig(idx=9, name="signal_line_width_name", description="signal_line_width_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10.0f, increment=1.0f, displayDecimals=0)
        @DefaultValue(value="2")
        public int SignalLineWidth = 2;
        @PropertyConfig(idx=10, name="show_histogram_name", description="show_histogram_descr", editor=EditorType.Switch)
        @DefaultValue(value="true")
        public boolean ShowHistogram = true;
        @PropertyConfig(idx=11, name="histogram_color_name", description="histogram_color_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#DA70D6")
        @Serialize(value=Serialize.As.Color)
        public int HistogramColor = ColorUtil.rgb(218, 112, 214);
        @IncludeConfig(idx=12)
        @Category(value="chart_value_scale")
        public final ValueScaleConfig ScaleConfig;
        @IncludeConfig(idx=13)
        @Category(value="chart_summaries")
        public final SummaryConfig SummaryConfig = new SummaryConfig();

        public Configuration(String uid) {
            super(uid);
            this.ScaleConfig = new ValueScaleConfig(EnumSet.of(ValueScaleConfig.AllowOptions.DisplayDecimals));
            this.ScaleConfig.DisplayDecimals = 1;
        }

        @Override
        public String configID() {
            return DEF.id();
        }

        @Override
        public String configurableName() {
            return String.format("%s(%d,%d,%d)", Resource.localizeString("chart_macd_study"), this.Periods1, this.Periods2, this.SignalLinePeriods);
        }

        @Override
        public boolean isEnabled(String propertyName) {
            if (propertyName.equals("MACDLineColor") && !this.ShowMACDLine) {
                return false;
            }
            if (propertyName.equals("MACDLineWidth") && !this.ShowMACDLine) {
                return false;
            }
            if (propertyName.equals("SignalLineColor") && !this.ShowSignalLine) {
                return false;
            }
            if (propertyName.equals("SignalLineWidth") && !this.ShowSignalLine) {
                return false;
            }
            return !propertyName.equals("HistogramColor") || this.ShowHistogram;
        }
    }

    public static class SummaryConfig
    extends Configurable {
        @PropertyConfig(idx=0, name="chart_display_summaries_name", description="chart_display_summaries_descr", editor=EditorType.Switch)
        @DefaultValue(value="true")
        public boolean DisplaySummaries = true;
        @PropertyConfig(idx=1, name="macd_summary_display_macd_name", description="empty")
        @DefaultValue(value="true")
        public boolean DisplayMCADValue = true;
        @PropertyConfig(idx=2, name="macd_summary_display_signal_name", description="empty")
        @DefaultValue(value="true")
        public boolean DisplaySignalValue = true;
        @PropertyConfig(idx=3, name="macd_summary_display_signal_diff_name", description="empty")
        @DefaultValue(value="true")
        public boolean DisplaySignalDiffValue = true;

        @Override
        public String configID() {
            return "MACDStudy$SummaryConfig";
        }

        @Override
        public String configurableName() {
            return Resource.localizeString("chart_summaries");
        }

        @Override
        public boolean isEnabled(String propertyName) {
            if (propertyName.equals("DisplayMCADValue") && !this.DisplaySummaries) {
                return false;
            }
            if (propertyName.equals("DisplaySignalValue") && !this.DisplaySummaries) {
                return false;
            }
            return !propertyName.equals("DisplaySignalDiffValue") || this.DisplaySummaries;
        }
    }
}

