/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.indicators;

import com.t4login.Host;
import com.t4login.Resource;
import com.t4login.application.chart.ChartContext;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.render.IChartRenderer;
import com.t4login.application.chart.render.IRendererFactory;
import com.t4login.application.chart.render.IStudyLineRenderer;
import com.t4login.application.chart.render.ISummaryRenderer;
import com.t4login.application.chart.scales.IValueScale;
import com.t4login.application.chart.scales.ValueScale;
import com.t4login.application.chart.scales.ValueScaleConfig;
import com.t4login.application.chart.studies.Study;
import com.t4login.application.chart.studies.StudyCategory;
import com.t4login.application.chart.studies.StudyConfigurable;
import com.t4login.application.chart.studies.StudyDefinition;
import com.t4login.application.chart.studies.StudyType;
import com.t4login.application.chart.studies.computations.HV;
import com.t4login.application.chart.studies.computations.MAPriceType;
import com.t4login.application.configuration.Category;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.EditorType;
import com.t4login.application.configuration.IncludeConfig;
import com.t4login.application.configuration.NumberFormatF;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.Serialize;
import com.t4login.application.configuration.UserRole;
import com.t4login.datetime.NDateTime;
import com.t4login.util.ColorUtil;
import com.t4login.util.Range;
import java.util.EnumSet;

@StudyDefinition(id="HV", nameResId="chart_hvol_study_name", descrResId="chart_hvol_study_descr", category=StudyCategory.Volatility, type=StudyType.Indicator, userRole=UserRole.Basic)
public class HistoricalVolatilityStudy
extends Study {
    private static final String TAG = "HVOLStudy";
    private static StudyDefinition DEF = HistoricalVolatilityStudy.class.getAnnotation(StudyDefinition.class);
    private final Configuration mConfig;
    private HV mHV = null;
    private DataSeries<HV.HVValue> mData = new DataSeries();
    private final IStudyLineRenderer mLineRenderer;
    private final ISummaryRenderer mSummary;
    private DataDefinition mDataDef = null;

    public HistoricalVolatilityStudy(ChartContext ccontext) {
        this(ccontext, null);
    }

    @Override
    public String getUID() {
        return this.mConfig.uid;
    }

    public HistoricalVolatilityStudy(ChartContext ccontext, Object config) {
        super(ccontext);
        this.mConfig = config instanceof Configuration ? (Configuration)config : new Configuration("");
        IRendererFactory rendererFactory = Host.getRendererFactory();
        assert (rendererFactory != null);
        this.mLineRenderer = rendererFactory.createStudyLineRenderer();
        this.mSummary = rendererFactory.createSummaryRenderer();
    }

    @Override
    public StudyDefinition getStudyDefinition() {
        return DEF;
    }

    @Override
    public Configurable getConfiguration() {
        return this.mConfig;
    }

    @Override
    public IValueScale createValueScale() {
        EnumSet<ValueScale.ScaleBehavior> opts = EnumSet.noneOf(ValueScale.ScaleBehavior.class);
        return new ValueScale(opts, this.mConfig.ScaleConfig);
    }

    @Override
    public IChartRenderer getRenderer() {
        this.mLineRenderer.updateDataSource(this.mData, this.getDataDefinition().getPrimaryField()).setColor(this.mConfig.LineColor).setWidth(this.mConfig.LineWidth).setLineStyle(IChartRenderer.LineStyle.Solid);
        return this.mLineRenderer;
    }

    @Override
    protected ISummaryRenderer getSummary(NDateTime trackTime) {
        HV.HVValue dp;
        if (!this.mConfig.SummaryConfig.DisplaySummaries) {
            return null;
        }
        Object summText = this.mConfig.configurableName();
        if (this.mConfig.SummaryConfig.DisplayHVOLValue && this.mData != null && (dp = (HV.HVValue)this.mData.getNearestTo(trackTime)) != null) {
            summText = (String)summText + " " + String.format("%." + this.mConfig.ScaleConfig.DisplayDecimals + "f", dp.HV);
        }
        this.mSummary.setText((String)summText).setIcon(ISummaryRenderer.SummaryIcon.Line);
        return this.mSummary;
    }

    @Override
    public Range<Double> getValueRange(Range<NDateTime> timeRange) {
        Range<Double> rng = this.mData.getValueRange(timeRange);
        return rng;
    }

    @Override
    public Range<NDateTime> getTimeRange() {
        return this.mData.getTimeRange();
    }

    @Override
    public Integer getPreceedingIntervals() {
        return this.mConfig.Periods;
    }

    @Override
    protected void onUpdateStudy() {
        if (this.mHV == null) {
            this.onRecomputeStudy();
        } else {
            this.mHV.update();
        }
    }

    @Override
    protected void onRecomputeStudy() {
        this.mHV = new HV(this.getBarData(), this.mConfig.Method, this.mConfig.PriceType, this.mConfig.Periods, this.getChartContext().Profile.Data.barInterval, this.mData);
        this.mHV.reCompute();
        if (this.mLineRenderer != null) {
            this.mLineRenderer.updateDataSource(this.mData, this.mHV.getDataDefinition().getPrimaryField());
        }
    }

    @Override
    protected void onResetStudy() {
        this.mData.clear();
    }

    @Override
    public DataDefinition getDataDefinition() {
        if (this.mHV != null) {
            return this.mHV.getDataDefinition();
        }
        return null;
    }

    @Override
    public IDataSource getDataSource() {
        return this.mData;
    }

    @Category(value="chart_hvol_study")
    public static class Configuration
    extends StudyConfigurable {
        @PropertyConfig(idx=0, name="hvol_method_name", description="hvol_method_descr")
        @DefaultValue(value="StdDev")
        public HV.HVMethod Method = HV.HVMethod.StdDev;
        @PropertyConfig(idx=1, name="indicator_pricetype_name", description="indicator_pricetype_descr")
        @DefaultValue(value="Closing")
        public MAPriceType PriceType = MAPriceType.Closing;
        @PropertyConfig(idx=2, name="indicator_periods_name", description="indicator_periods_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10000.0f)
        @DefaultValue(value="10")
        public int Periods = 10;
        @PropertyConfig(idx=3, name="linecolor_name", description="linecolor_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#008000")
        @Serialize(value=Serialize.As.Color)
        public int LineColor = ColorUtil.rgb(0, 128, 0);
        @PropertyConfig(idx=4, name="linewidth_name", description="linewidth_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10.0f, increment=1.0f, displayDecimals=0)
        @DefaultValue(value="2")
        public int LineWidth = 2;
        @IncludeConfig(idx=12)
        @Category(value="chart_value_scale")
        public final ValueScaleConfig ScaleConfig;
        @IncludeConfig(idx=13)
        @Category(value="chart_summaries")
        public final SummaryConfig SummaryConfig = new SummaryConfig();

        public Configuration(String uid) {
            super(uid);
            this.ScaleConfig = new ValueScaleConfig(EnumSet.of(ValueScaleConfig.AllowOptions.DisplayDecimals));
            this.ScaleConfig.DisplayDecimals = 2;
        }

        @Override
        public String configID() {
            return DEF.id();
        }

        @Override
        public String configurableName() {
            return String.format("%s(%d)", Resource.localizeString("chart_hvol_study"), this.Periods);
        }

        @Override
        public boolean filterProperty(String propertyName) {
            if (propertyName.equals("PriceType") && this.Method != HV.HVMethod.StdDev) {
                return true;
            }
            return super.filterProperty(propertyName);
        }
    }

    public static class SummaryConfig
    extends Configurable {
        @PropertyConfig(idx=0, name="chart_display_summaries_name", description="chart_display_summaries_descr", editor=EditorType.Switch)
        @DefaultValue(value="true")
        public boolean DisplaySummaries = true;
        @PropertyConfig(idx=1, name="hvol_summary_display_hvol_name", description="empty")
        @DefaultValue(value="true")
        public boolean DisplayHVOLValue = true;

        @Override
        public String configID() {
            return "HVOLStudy$SummaryConfig";
        }

        @Override
        public String configurableName() {
            return Resource.localizeString("chart_summaries");
        }

        @Override
        public boolean isEnabled(String propertyName) {
            return !propertyName.equals("DisplayHVOLValue") || this.DisplaySummaries;
        }
    }
}

