/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.indicators;

import com.t4login.Host;
import com.t4login.Resource;
import com.t4login.application.chart.ChartContext;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.render.CompoundRenderer;
import com.t4login.application.chart.render.IChartRenderer;
import com.t4login.application.chart.render.IRendererFactory;
import com.t4login.application.chart.render.IStudyLineRenderer;
import com.t4login.application.chart.render.ISummaryRenderer;
import com.t4login.application.chart.scales.IValueScale;
import com.t4login.application.chart.scales.ValueScale;
import com.t4login.application.chart.scales.ValueScaleConfig;
import com.t4login.application.chart.studies.Study;
import com.t4login.application.chart.studies.StudyCategory;
import com.t4login.application.chart.studies.StudyConfigurable;
import com.t4login.application.chart.studies.StudyDefinition;
import com.t4login.application.chart.studies.StudyType;
import com.t4login.application.chart.studies.computations.Stoch;
import com.t4login.application.configuration.Category;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.EditorType;
import com.t4login.application.configuration.IncludeConfig;
import com.t4login.application.configuration.NumberFormatF;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.Serialize;
import com.t4login.application.configuration.UserRole;
import com.t4login.datetime.NDateTime;
import com.t4login.util.ColorUtil;
import com.t4login.util.Range;
import com.t4login.util.TextUtils;
import java.util.ArrayList;
import java.util.EnumSet;

@StudyDefinition(id="Fast STO", nameResId="chart_fast_sto_study_name", descrResId="chart_fast_sto_study_descr", category=StudyCategory.Oscillator, type=StudyType.Indicator, userRole=UserRole.Basic)
public class FastStochasticOscillatorStudy
extends Study {
    private static final String TAG = "FastSTOStudy";
    private static StudyDefinition DEF = FastStochasticOscillatorStudy.class.getAnnotation(StudyDefinition.class);
    private final Configuration mConfig;
    private Stoch mStoch = null;
    private DataSeries<Stoch.STOValue> mData = new DataSeries();
    private final Range<Double> mValueRange = Range.of(0.0, 100.0);
    private final IStudyLineRenderer mKLineRenderer;
    private final IStudyLineRenderer mDLineRenderer;
    private final CompoundRenderer mRenderer;
    private final ISummaryRenderer mSummary;

    public FastStochasticOscillatorStudy(ChartContext ccontext) {
        this(ccontext, null);
    }

    @Override
    public String getUID() {
        return this.mConfig.uid;
    }

    public FastStochasticOscillatorStudy(ChartContext ccontext, Object config) {
        super(ccontext);
        this.mConfig = config instanceof Configuration ? (Configuration)config : new Configuration("");
        IRendererFactory rendererFactory = Host.getRendererFactory();
        assert (rendererFactory != null);
        this.mKLineRenderer = rendererFactory.createStudyLineRenderer();
        this.mDLineRenderer = rendererFactory.createStudyLineRenderer();
        this.mRenderer = new CompoundRenderer();
        this.mRenderer.addRenderer(this.mKLineRenderer);
        this.mRenderer.addRenderer(this.mDLineRenderer);
        this.mSummary = rendererFactory.createSummaryRenderer();
    }

    @Override
    public StudyDefinition getStudyDefinition() {
        return DEF;
    }

    @Override
    public Configurable getConfiguration() {
        return this.mConfig;
    }

    @Override
    public IValueScale createValueScale() {
        EnumSet<ValueScale.ScaleBehavior> opts = EnumSet.noneOf(ValueScale.ScaleBehavior.class);
        opts.add(ValueScale.ScaleBehavior.Tight);
        ValueScaleConfig config = new ValueScaleConfig();
        config.DisplayDecimals = 0;
        return new ValueScale(opts, config);
    }

    @Override
    public IChartRenderer getRenderer() {
        this.mKLineRenderer.updateDataSource(this.mData, this.mStoch.getDataDefinition().getField("K")).setColor(this.mConfig.KLineColor).setWidth(this.mConfig.LineWidth).setLineStyle(IChartRenderer.LineStyle.Solid);
        this.mDLineRenderer.updateDataSource(this.mData, this.mStoch.getDataDefinition().getField("D")).setColor(this.mConfig.DLineColor).setWidth(this.mConfig.LineWidth).setLineStyle(IChartRenderer.LineStyle.Solid);
        return this.mRenderer;
    }

    @Override
    protected ISummaryRenderer getSummary(NDateTime trackTime) {
        Stoch.STOValue stoch;
        if (!this.mConfig.SummaryConfig.DisplaySummaries) {
            return null;
        }
        Object summText = this.mConfig.configurableName();
        if (this.mStoch != null && (stoch = (Stoch.STOValue)this.mData.getNearestTo(trackTime)) != null) {
            ArrayList<String> summs = new ArrayList<String>();
            if (this.mConfig.SummaryConfig.DisplayKValue) {
                double kval = stoch.K;
                summs.add(String.format("%.2f", kval));
            }
            if (this.mConfig.SummaryConfig.DisplayDValue) {
                double dval = stoch.D;
                summs.add(String.format("%.2f", dval));
            }
            if (summs.size() > 0) {
                summText = (String)summText + " " + TextUtils.join((CharSequence)", ", summs);
            }
        }
        this.mSummary.setText((String)summText).setIcon(ISummaryRenderer.SummaryIcon.Oscillator);
        return this.mSummary;
    }

    @Override
    public Range<Double> getValueRange(Range<NDateTime> timeRange) {
        return this.mValueRange;
    }

    @Override
    public Range<NDateTime> getTimeRange() {
        return this.mData.getTimeRange();
    }

    @Override
    public Integer getPreceedingIntervals() {
        return this.mConfig.Periods;
    }

    @Override
    protected void onUpdateStudy() {
        if (this.mStoch == null) {
            this.onRecomputeStudy();
        } else {
            this.mStoch.update();
        }
    }

    @Override
    protected void onRecomputeStudy() {
        this.mStoch = new Stoch(this.getBarData(), this.mConfig.Periods, this.mConfig.KSmoothingPeriods, this.mConfig.DSmoothingPeriods, this.mData);
        this.mStoch.reCompute();
        if (this.mRenderer != null) {
            this.mKLineRenderer.updateDataSource(this.mData, this.mStoch.getDataDefinition().getField("K"));
            this.mDLineRenderer.updateDataSource(this.mData, this.mStoch.getDataDefinition().getField("D"));
        }
    }

    @Override
    protected void onResetStudy() {
        if (this.mStoch != null) {
            this.mStoch.reset();
        }
        this.mData.clear();
    }

    @Override
    public DataDefinition getDataDefinition() {
        if (this.mStoch != null) {
            return this.mStoch.getDataDefinition();
        }
        return null;
    }

    @Override
    public IDataSource getDataSource() {
        return this.mData;
    }

    @Category(value="chart_fast_sto_study")
    public static class Configuration
    extends StudyConfigurable {
        @PropertyConfig(idx=0, name="indicator_periods_name", description="indicator_periods_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10000.0f)
        @DefaultValue(value="14")
        public int Periods = 14;
        @PropertyConfig(idx=1, name="sto_k_periods_name", description="sto_k_periods_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10000.0f)
        @DefaultValue(value="1")
        public int KSmoothingPeriods = 1;
        @PropertyConfig(idx=2, name="sto_d_periods_name", description="indicator_periods_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10000.0f)
        @DefaultValue(value="3")
        public int DSmoothingPeriods = 3;
        @PropertyConfig(idx=3, name="sto_k_linecolor_name", description="sto_k_linecolor_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#000000")
        @Serialize(value=Serialize.As.Color)
        public int KLineColor = ColorUtil.rgb(128, 128, 128);
        @PropertyConfig(idx=4, name="sto_d_linecolor_name", description="sto_d_linecolor_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#FF0000")
        @Serialize(value=Serialize.As.Color)
        public int DLineColor = ColorUtil.rgb(255, 0, 0);
        @PropertyConfig(idx=5, name="linewidth_name", description="linewidth_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10.0f, increment=1.0f, displayDecimals=0)
        @DefaultValue(value="2")
        public int LineWidth = 2;
        @IncludeConfig(idx=10)
        @Category(value="chart_summaries")
        public final SummaryConfig SummaryConfig = new SummaryConfig();

        public Configuration(String uid) {
            super(uid);
        }

        @Override
        public String configID() {
            return DEF.id();
        }

        @Override
        public String configurableName() {
            return String.format("%s(%d,%d,%d)", Resource.localizeString("chart_sto_study"), this.Periods, this.KSmoothingPeriods, this.DSmoothingPeriods);
        }
    }

    public static class SummaryConfig
    extends Configurable {
        @PropertyConfig(idx=0, name="chart_display_summaries_name", description="chart_display_summaries_descr", editor=EditorType.Switch)
        @DefaultValue(value="true")
        public boolean DisplaySummaries = true;
        @PropertyConfig(idx=1, name="sto_summary_display_k_value_name", description="empty")
        @DefaultValue(value="true")
        public boolean DisplayKValue = true;
        @PropertyConfig(idx=1, name="sto_summary_display_d_value_name", description="empty")
        @DefaultValue(value="true")
        public boolean DisplayDValue = true;

        @Override
        public String configID() {
            return "HVOLStudy$SummaryConfig";
        }

        @Override
        public String configurableName() {
            return Resource.localizeString("chart_summaries");
        }

        @Override
        public boolean isEnabled(String propertyName) {
            if (propertyName.equals("DisplayKValue") && !this.DisplaySummaries) {
                return false;
            }
            return !propertyName.equals("DisplayDValue") || this.DisplaySummaries;
        }
    }
}

