/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.indicators;

import com.t4login.Host;
import com.t4login.Log;
import com.t4login.Resource;
import com.t4login.application.chart.ChartContext;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.IBarDataPoint;
import com.t4login.application.chart.chartdata.IDataPoint;
import com.t4login.application.chart.chartdata.IDataPointValue;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.DataField;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.render.CompoundRenderer;
import com.t4login.application.chart.render.IChartRenderer;
import com.t4login.application.chart.render.IRendererFactory;
import com.t4login.application.chart.render.IStudyLineRenderer;
import com.t4login.application.chart.render.IStudyZeroLineRenderer;
import com.t4login.application.chart.render.ISummaryRenderer;
import com.t4login.application.chart.scales.IValueScale;
import com.t4login.application.chart.scales.ValueScale;
import com.t4login.application.chart.scales.ValueScaleConfig;
import com.t4login.application.chart.studies.Study;
import com.t4login.application.chart.studies.StudyCategory;
import com.t4login.application.chart.studies.StudyConfigurable;
import com.t4login.application.chart.studies.StudyDefinition;
import com.t4login.application.chart.studies.StudyType;
import com.t4login.application.chart.studies.computations.RunningCalc;
import com.t4login.application.configuration.Category;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.EditorType;
import com.t4login.application.configuration.IncludeConfig;
import com.t4login.application.configuration.NumberFormatF;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.Serialize;
import com.t4login.application.configuration.UserRole;
import com.t4login.datetime.NDateTime;
import com.t4login.util.ColorUtil;
import com.t4login.util.Range;
import java.util.EnumSet;

@StudyDefinition(id="FVE", nameResId="chart_fve_study_name", descrResId="chart_fve_study_descr", category=StudyCategory.MoneyFlow, type=StudyType.Indicator, userRole=UserRole.Basic)
public class FVEStudy
extends Study {
    private static final String TAG = "FVEStudy";
    private static StudyDefinition DEF = FVEStudy.class.getAnnotation(StudyDefinition.class);
    private final Configuration mConfig;
    private DataSeries<FVEValue> mData = new DataSeries();
    private final IStudyLineRenderer mLineRenderer;
    private final IStudyZeroLineRenderer mZeroLineRenderer;
    private final CompoundRenderer mRenderer;
    private final ISummaryRenderer mSummary;
    private DataDefinition mDataDef = null;

    public FVEStudy(ChartContext ccontext) {
        this(ccontext, null);
    }

    public FVEStudy(ChartContext ccontext, Object config) {
        super(ccontext);
        this.mConfig = config instanceof Configuration ? (Configuration)config : new Configuration("");
        IRendererFactory rendererFactory = Host.getRendererFactory();
        assert (rendererFactory != null);
        this.mLineRenderer = rendererFactory.createStudyLineRenderer();
        this.mZeroLineRenderer = rendererFactory.createStudyZeroLineRenderer();
        this.mRenderer = new CompoundRenderer();
        this.mRenderer.addRenderer(this.mLineRenderer);
        this.mRenderer.addRenderer(this.mZeroLineRenderer);
        this.mSummary = rendererFactory.createSummaryRenderer();
    }

    @Override
    public String getUID() {
        return this.mConfig.uid;
    }

    @Override
    public StudyDefinition getStudyDefinition() {
        return DEF;
    }

    @Override
    public Configurable getConfiguration() {
        return this.mConfig;
    }

    @Override
    public IValueScale createValueScale() {
        EnumSet<ValueScale.ScaleBehavior> opts = EnumSet.noneOf(ValueScale.ScaleBehavior.class);
        opts.add(ValueScale.ScaleBehavior.CrossesZero);
        opts.add(ValueScale.ScaleBehavior.Tight);
        return new ValueScale(opts, this.mConfig.ScaleConfig);
    }

    @Override
    public IChartRenderer getRenderer() {
        this.mLineRenderer.updateDataSource(this.mData, this.getDataDefinition().getPrimaryField()).setColor(this.mConfig.LineColor).setWidth(2.0f).setLineStyle(IChartRenderer.LineStyle.Solid);
        return this.mRenderer;
    }

    @Override
    protected ISummaryRenderer getSummary(NDateTime trackTime) {
        FVEValue fve;
        if (!this.mConfig.SummaryConfig.DisplaySummaries) {
            return null;
        }
        Object summText = this.mConfig.configurableName();
        if (this.mConfig.SummaryConfig.DisplayFVEValue && (fve = (FVEValue)this.mData.getNearestTo(trackTime)) != null) {
            summText = (String)summText + " " + String.format("%." + this.mConfig.ScaleConfig.DisplayDecimals + "f", fve.FVE);
        }
        this.mSummary.setText((String)summText).setIcon(ISummaryRenderer.SummaryIcon.Line);
        return this.mSummary;
    }

    @Override
    public Range<Double> getValueRange(Range<NDateTime> timeRange) {
        return this.mData.getValueRange(timeRange);
    }

    @Override
    public Range<NDateTime> getTimeRange() {
        return this.mData.getTimeRange();
    }

    @Override
    public Integer getPreceedingIntervals() {
        return this.mConfig.Periods;
    }

    @Override
    protected void onUpdateStudy() {
        if (this.mData.getCount() == 0) {
            this.compute(null);
        } else {
            FVEValue startpt = null;
            BarDataSeries ser = this.getBarData();
            IBarDataPoint basept = ser.baseDataPoint;
            if (basept != null) {
                FVEValue lastpt = (FVEValue)this.mData.getLast();
                while (lastpt != null && lastpt.Time.compareTo(basept.getTime()) > 0) {
                    this.mData.removeDataPoint(lastpt);
                }
                startpt = lastpt = (FVEValue)this.mData.getLast();
            }
            if (startpt == null) {
                startpt = (FVEValue)this.mData.getLast();
            }
            this.compute(startpt);
        }
    }

    @Override
    protected void onRecomputeStudy() {
        this.mData.clear();
        this.compute(null);
        if (this.mLineRenderer != null) {
            this.mLineRenderer.updateDataSource(this.mData, this.getDataDefinition().getPrimaryField());
        }
    }

    @Override
    protected void onResetStudy() {
        this.mData.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compute(FVEValue startpt) {
        BarDataSeries series = this.getBarData();
        if (series.getCount() < this.mConfig.Periods) {
            return;
        }
        int startidx = 2 * this.mConfig.Periods - 1;
        RunningCalc vintra = new RunningCalc(this.mConfig.Periods);
        RunningCalc vinter = new RunningCalc(this.mConfig.Periods);
        RunningCalc sumve = new RunningCalc(this.mConfig.Periods);
        RunningCalc avgvol = new RunningCalc(this.mConfig.Periods);
        this.mData.beginUpdate();
        try {
            double prevtyp = 0.0;
            if (startpt != null) {
                startidx = startpt.DataIndex;
                IBarDataPoint prevbar = series.get(startidx - (2 * this.mConfig.Periods - 1) - 1);
                prevtyp = (prevbar.getHigh() + prevbar.getLow() + prevbar.getClose()) / 3.0;
            }
            for (int i = startidx - (2 * this.mConfig.Periods - 1); i < series.getCount(); ++i) {
                IBarDataPoint bar = series.get(i);
                double typ = (bar.getHigh() + bar.getLow() + bar.getClose()) / 3.0;
                double intra = Math.log10(bar.getHigh()) - Math.log10(bar.getLow());
                double inter = Math.log10(typ) - Math.log10(prevtyp);
                vintra.add(intra);
                vinter.add(inter);
                avgvol.add(bar.getVolume());
                if (i >= this.mConfig.Periods) {
                    double cuttoff;
                    double mf = bar.getClose() - (bar.getHigh() + bar.getLow()) / 2.0 + typ - prevtyp;
                    if (mf > (cuttoff = this.mConfig.CutOffCoef * (vinter.getStdDev() + vintra.getStdDev()) * bar.getClose())) {
                        sumve.add(bar.getVolume());
                    } else if (mf < -cuttoff) {
                        sumve.add(-bar.getVolume());
                    } else {
                        sumve.add(0.0);
                    }
                    if (i >= startidx && sumve.getCount() == this.mConfig.Periods) {
                        double fve = 100.0 * sumve.getSum() / (avgvol.getAvg() * (double)this.mConfig.Periods);
                        this.mData.addDataPoint(new FVEValue(bar.getTime(), fve, i));
                    }
                }
                prevtyp = typ;
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeStudy(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    @Override
    public DataDefinition getDataDefinition() {
        if (this.mDataDef == null) {
            this.mDataDef = new DataDefinition("FVE");
            this.mDataDef.addField(new DataField("FVE", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof FVEValue) {
                        FVEValue trdp = (FVEValue)dp;
                        return trdp.FVE;
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(){

                @Override
                public String getFormattedValue(double value) {
                    return String.format("%." + FVEStudy.this.mConfig.ScaleConfig.DisplayDecimals + "f", value);
                }
            }, true, false));
        }
        return this.mDataDef;
    }

    @Override
    public IDataSource getDataSource() {
        return this.mData;
    }

    @Category(value="chart_fve_study")
    public static class Configuration
    extends StudyConfigurable {
        @PropertyConfig(idx=0, name="fve_periods_name", description="fve_periods_descr")
        @NumberFormatF(minValue=2.0f, maxValue=10000.0f)
        @DefaultValue(value="22")
        public int Periods = 22;
        private double CutOffCoef = 0.1;
        @PropertyConfig(idx=1, name="linecolor_name", description="linecolor_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#000000")
        @Serialize(value=Serialize.As.Color)
        public int LineColor = ColorUtil.rgb(128, 128, 128);
        @PropertyConfig(idx=2, name="linewidth_name", description="linewidth_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10.0f, increment=1.0f, displayDecimals=0)
        @DefaultValue(value="2")
        public int LineWidth = 2;
        @IncludeConfig(idx=3)
        @Category(value="chart_value_scale")
        public final ValueScaleConfig ScaleConfig;
        @IncludeConfig(idx=4)
        @Category(value="chart_summaries")
        public final SummaryConfig SummaryConfig = new SummaryConfig();

        public Configuration(String uid) {
            super(uid);
            this.ScaleConfig = new ValueScaleConfig(EnumSet.of(ValueScaleConfig.AllowOptions.DisplayDecimals));
            this.ScaleConfig.DisplayDecimals = 1;
        }

        @Override
        public String configID() {
            return DEF.id();
        }

        @Override
        public String configurableName() {
            return String.format("%s(%d)", Resource.localizeString("chart_fve_study"), this.Periods);
        }
    }

    public static class SummaryConfig
    extends Configurable {
        @PropertyConfig(idx=0, name="chart_display_summaries_name", description="chart_display_summaries_descr", editor=EditorType.Switch)
        @DefaultValue(value="true")
        public boolean DisplaySummaries = true;
        @PropertyConfig(idx=1, name="fve_summary_display_fve_name", description="empty")
        @DefaultValue(value="true")
        public boolean DisplayFVEValue = true;

        @Override
        public String configID() {
            return "FVEStudy$SummaryConfig";
        }

        @Override
        public String configurableName() {
            return Resource.localizeString("chart_summaries");
        }

        @Override
        public boolean isEnabled(String propertyName) {
            return !propertyName.equals("DisplayFVEValue") || this.DisplaySummaries;
        }
    }

    public static class FVEValue
    implements IDataPointValue {
        public final NDateTime Time;
        public final double FVE;
        public final int DataIndex;

        public FVEValue(NDateTime time, double fve, int idx) {
            this.Time = time;
            this.FVE = fve;
            this.DataIndex = idx;
        }

        @Override
        public double getValue() {
            return this.FVE;
        }

        @Override
        public NDateTime getTime() {
            return this.Time;
        }
    }
}

