/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.indicators;

import com.t4login.Host;
import com.t4login.Log;
import com.t4login.Resource;
import com.t4login.application.chart.ChartContext;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.IBarDataPoint;
import com.t4login.application.chart.chartdata.IDataPoint;
import com.t4login.application.chart.chartdata.IDataPointValue;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.DataField;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.render.CompoundRenderer;
import com.t4login.application.chart.render.IChartRenderer;
import com.t4login.application.chart.render.IRendererFactory;
import com.t4login.application.chart.render.IStudyAreaRenderer;
import com.t4login.application.chart.render.IStudyZeroLineRenderer;
import com.t4login.application.chart.render.ISummaryRenderer;
import com.t4login.application.chart.scales.IValueScale;
import com.t4login.application.chart.scales.ValueScale;
import com.t4login.application.chart.scales.ValueScaleConfig;
import com.t4login.application.chart.studies.Study;
import com.t4login.application.chart.studies.StudyCategory;
import com.t4login.application.chart.studies.StudyConfigurable;
import com.t4login.application.chart.studies.StudyDefinition;
import com.t4login.application.chart.studies.StudyType;
import com.t4login.application.configuration.Category;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.EditorType;
import com.t4login.application.configuration.IncludeConfig;
import com.t4login.application.configuration.NumberFormatF;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.Serialize;
import com.t4login.application.configuration.UserRole;
import com.t4login.datetime.NDateTime;
import com.t4login.util.ColorUtil;
import com.t4login.util.Range;
import java.util.EnumSet;

@StudyDefinition(id="CMF", nameResId="chart_cmf_study_name", descrResId="chart_cmf_study_descr", category=StudyCategory.MoneyFlow, type=StudyType.Indicator, userRole=UserRole.Basic)
public class CMFStudy
extends Study {
    private static final String TAG = "CMFStudy";
    private static StudyDefinition DEF = CMFStudy.class.getAnnotation(StudyDefinition.class);
    private final Configuration mConfig;
    private DataSeries<CMFValue> mData = new DataSeries();
    private final IStudyAreaRenderer mAreaRenderer;
    private final IStudyZeroLineRenderer mZeroLineRenderer;
    private final CompoundRenderer mRenderer;
    private final ISummaryRenderer mSummary;
    private DataDefinition mDataDef = null;

    public CMFStudy(ChartContext ccontext) {
        this(ccontext, null);
    }

    @Override
    public String getUID() {
        return this.mConfig.uid;
    }

    public CMFStudy(ChartContext ccontext, Object config) {
        super(ccontext);
        this.mConfig = config instanceof Configuration ? (Configuration)config : new Configuration("");
        IRendererFactory rendererFactory = Host.getRendererFactory();
        assert (rendererFactory != null);
        this.mAreaRenderer = rendererFactory.createStudyAreaRenderer();
        this.mZeroLineRenderer = rendererFactory.createStudyZeroLineRenderer();
        this.mRenderer = new CompoundRenderer();
        this.mRenderer.addRenderer(this.mAreaRenderer);
        this.mRenderer.addRenderer(this.mZeroLineRenderer);
        this.mSummary = rendererFactory.createSummaryRenderer();
    }

    @Override
    public StudyDefinition getStudyDefinition() {
        return DEF;
    }

    @Override
    public Configurable getConfiguration() {
        return this.mConfig;
    }

    @Override
    public IValueScale createValueScale() {
        EnumSet<ValueScale.ScaleBehavior> opts = EnumSet.noneOf(ValueScale.ScaleBehavior.class);
        opts.add(ValueScale.ScaleBehavior.CrossesZero);
        opts.add(ValueScale.ScaleBehavior.Symmetric);
        opts.add(ValueScale.ScaleBehavior.Tight);
        return new ValueScale(opts, this.mConfig.ScaleConfig);
    }

    @Override
    public IChartRenderer getRenderer() {
        this.mAreaRenderer.updateDateSource(this.mData, this.getDataDefinition().getPrimaryField()).setPositiveAreaColor(this.mConfig.BPColor).setNegativeAreaColor(this.mConfig.SPColor).setLineWidth(2.0f).setLineStyle(IChartRenderer.LineStyle.Solid);
        return this.mRenderer;
    }

    @Override
    protected ISummaryRenderer getSummary(NDateTime trackTime) {
        CMFValue cmf;
        if (!this.mConfig.SummaryConfig.DisplaySummaries) {
            return null;
        }
        Object summText = this.mConfig.configurableName();
        if (this.mConfig.SummaryConfig.DisplayCMFValue && (cmf = (CMFValue)this.mData.getNearestTo(trackTime)) != null) {
            summText = (String)summText + " " + String.format("%." + this.mConfig.ScaleConfig.DisplayDecimals + "f", cmf.CMF);
        }
        this.mSummary.setText((String)summText).setIcon(ISummaryRenderer.SummaryIcon.Area);
        return this.mSummary;
    }

    @Override
    public Range<Double> getValueRange(Range<NDateTime> timeRange) {
        return this.mData.getValueRange(timeRange);
    }

    @Override
    public Range<NDateTime> getTimeRange() {
        return this.mData.getTimeRange();
    }

    @Override
    public Integer getPreceedingIntervals() {
        return this.mConfig.Periods;
    }

    @Override
    protected void onUpdateStudy() {
        if (this.mData.getCount() == 0) {
            this.compute(null);
        } else {
            CMFValue startpt = null;
            BarDataSeries ser = this.getBarData();
            IBarDataPoint basept = ser.baseDataPoint;
            if (basept != null) {
                CMFValue lastpt = (CMFValue)this.mData.getLast();
                while (lastpt != null && lastpt.Time.compareTo(basept.getTime()) > 0) {
                    this.mData.removeDataPoint(lastpt);
                }
                startpt = lastpt = (CMFValue)this.mData.getLast();
            }
            if (startpt == null) {
                startpt = (CMFValue)this.mData.getLast();
            }
            this.compute(startpt);
        }
    }

    @Override
    protected void onRecomputeStudy() {
        this.mData.clear();
        this.compute(null);
        if (this.mAreaRenderer != null) {
            this.mAreaRenderer.updateDateSource(this.mData, this.getDataDefinition().getPrimaryField());
        }
    }

    @Override
    protected void onResetStudy() {
        this.mData.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compute(CMFValue startpt) {
        int startidx = 0;
        double accdist = 0.0;
        double cumaccdist = 0.0;
        int cumvolume = 0;
        BarDataSeries series = this.getBarData();
        if (startpt != null) {
            startidx = startpt.DataIndex;
            accdist = startpt.PrevAccDist;
            cumaccdist = startpt.PrevCumAccDist;
            cumvolume = startpt.PrevCumVol;
        }
        this.mData.beginUpdate();
        try {
            for (int i = startidx; i < series.getCount(); ++i) {
                IBarDataPoint bar = series.get(i);
                double close = bar.getClose();
                double high = bar.getHigh();
                double low = bar.getLow();
                int volume = bar.getVolume();
                double clv = 0.0;
                if (high != low) {
                    clv = (close - low - (high - close)) / (high - low);
                }
                double mov = clv * (double)volume;
                double prevaccdist = accdist;
                cumaccdist += (accdist += mov);
                cumvolume += bar.getVolume();
                if (i < this.mConfig.Periods - 1) continue;
                double cmf = cumaccdist / (double)cumvolume;
                this.mData.addDataPoint(new CMFValue(bar.getTime(), cmf, accdist, prevaccdist, cumaccdist - accdist, cumvolume - bar.getVolume(), i));
                cumaccdist -= ((CMFValue)this.mData.get((int)(i - this.mConfig.Periods + 1))).AccDist;
                cumvolume -= series.get(i - this.mConfig.Periods + 1).getVolume();
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeStudy(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    @Override
    public DataDefinition getDataDefinition() {
        if (this.mDataDef == null) {
            this.mDataDef = new DataDefinition("CMF");
            this.mDataDef.addField(new DataField("CMF", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof CMFValue) {
                        CMFValue trdp = (CMFValue)dp;
                        return trdp.CMF;
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(){

                @Override
                public String getFormattedValue(double value) {
                    return String.format("%." + CMFStudy.this.mConfig.ScaleConfig.DisplayDecimals + "f", value);
                }
            }, true, false));
        }
        return this.mDataDef;
    }

    @Override
    public IDataSource getDataSource() {
        return this.mData;
    }

    @Category(value="chart_cmf_study")
    public static class Configuration
    extends StudyConfigurable {
        @PropertyConfig(idx=0, name="cmf_periods_name", description="cmf_periods_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10000.0f)
        @DefaultValue(value="21")
        public int Periods = 21;
        @PropertyConfig(idx=1, name="cmf_buying_pressure_color_name", description="cmf_buying_pressure_color_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#90EE90")
        @Serialize(value=Serialize.As.Color)
        public int BPColor = ColorUtil.rgb(144, 238, 144);
        @PropertyConfig(idx=2, name="cmf_selling_pressure_color_name", description="cmf_selling_pressure_color_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#FFB6C1")
        @Serialize(value=Serialize.As.Color)
        public int SPColor = ColorUtil.rgb(255, 182, 193);
        @IncludeConfig(idx=3)
        @Category(value="chart_value_scale")
        public final ValueScaleConfig ScaleConfig;
        @IncludeConfig(idx=4)
        @Category(value="chart_summaries")
        public final SummaryConfig SummaryConfig = new SummaryConfig();

        public Configuration(String uid) {
            super(uid);
            this.ScaleConfig = new ValueScaleConfig(EnumSet.of(ValueScaleConfig.AllowOptions.DisplayDecimals));
            this.ScaleConfig.DisplayDecimals = 1;
        }

        @Override
        public String configID() {
            return DEF.id();
        }

        @Override
        public String configurableName() {
            return String.format("%s(%d)", Resource.localizeString("chart_cmf_study"), this.Periods);
        }
    }

    public static class SummaryConfig
    extends Configurable {
        @PropertyConfig(idx=0, name="chart_display_summaries_name", description="chart_display_summaries_descr", editor=EditorType.Switch)
        @DefaultValue(value="true")
        public boolean DisplaySummaries = true;
        @PropertyConfig(idx=1, name="cmf_summary_display_cmf_name", description="empty")
        @DefaultValue(value="true")
        public boolean DisplayCMFValue = true;

        @Override
        public String configID() {
            return "CMFStudy$SummaryConfig";
        }

        @Override
        public String configurableName() {
            return Resource.localizeString("chart_summaries");
        }

        @Override
        public boolean isEnabled(String propertyName) {
            return !propertyName.equals("DisplayCMFValue") || this.DisplaySummaries;
        }
    }

    public static class CMFValue
    implements IDataPointValue {
        public final NDateTime Time;
        public final double CMF;
        public final double AccDist;
        public final double PrevAccDist;
        public final double PrevCumAccDist;
        public final int PrevCumVol;
        public final int DataIndex;

        public CMFValue(NDateTime time, double cmf, double acc, double prevacc, double prevcumacc, int prevcumvol, int idx) {
            this.Time = time;
            this.CMF = cmf;
            this.AccDist = acc;
            this.PrevAccDist = prevacc;
            this.PrevCumAccDist = prevcumacc;
            this.PrevCumVol = prevcumvol;
            this.DataIndex = idx;
        }

        @Override
        public double getValue() {
            return this.CMF;
        }

        @Override
        public NDateTime getTime() {
            return this.Time;
        }
    }
}

