/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.indicators;

import com.t4login.Host;
import com.t4login.Resource;
import com.t4login.application.chart.ChartContext;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.render.CompoundRenderer;
import com.t4login.application.chart.render.IChartRenderer;
import com.t4login.application.chart.render.IRendererFactory;
import com.t4login.application.chart.render.IStudyLineRenderer;
import com.t4login.application.chart.render.ISummaryRenderer;
import com.t4login.application.chart.scales.IValueScale;
import com.t4login.application.chart.scales.ValueScale;
import com.t4login.application.chart.scales.ValueScaleConfig;
import com.t4login.application.chart.studies.Study;
import com.t4login.application.chart.studies.StudyCategory;
import com.t4login.application.chart.studies.StudyConfigurable;
import com.t4login.application.chart.studies.StudyDefinition;
import com.t4login.application.chart.studies.StudyType;
import com.t4login.application.chart.studies.computations.BarTR;
import com.t4login.application.chart.studies.computations.MAPriceType;
import com.t4login.application.chart.studies.computations.MAType;
import com.t4login.application.chart.studies.computations.MovingAverage;
import com.t4login.application.configuration.Category;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.EditorType;
import com.t4login.application.configuration.IncludeConfig;
import com.t4login.application.configuration.NumberFormatF;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.Serialize;
import com.t4login.application.configuration.UserRole;
import com.t4login.datetime.NDateTime;
import com.t4login.util.ColorUtil;
import com.t4login.util.Range;
import java.util.EnumSet;

@StudyDefinition(id="ATR", nameResId="chart_atr_study_name", descrResId="chart_atr_study_descr", category=StudyCategory.Volatility, type=StudyType.Indicator, userRole=UserRole.Basic)
public class AverageTrueRangeStudy
extends Study {
    private static final String TAG = "ATRStudy";
    private static StudyDefinition DEF = AverageTrueRangeStudy.class.getAnnotation(StudyDefinition.class);
    private final Configuration mConfig;
    private BarTR mTR = null;
    private MovingAverage mMA = null;
    private DataSeries mATR = new DataSeries();
    private final IStudyLineRenderer mTRLineRenderer;
    private final IStudyLineRenderer mATRLineRenderer;
    private final CompoundRenderer mRenderer;
    private final ISummaryRenderer mSummary;

    public AverageTrueRangeStudy(ChartContext ccontext) {
        this(ccontext, null);
    }

    @Override
    public String getUID() {
        return this.mConfig.uid;
    }

    public AverageTrueRangeStudy(ChartContext ccontext, Object config) {
        super(ccontext);
        this.mConfig = config instanceof Configuration ? (Configuration)config : new Configuration("");
        IRendererFactory rendererFactory = Host.getRendererFactory();
        assert (rendererFactory != null);
        this.mTRLineRenderer = rendererFactory.createStudyLineRenderer();
        this.mATRLineRenderer = rendererFactory.createStudyLineRenderer();
        this.mRenderer = new CompoundRenderer();
        this.mRenderer.addRenderer(this.mTRLineRenderer);
        this.mRenderer.addRenderer(this.mATRLineRenderer);
        this.mSummary = rendererFactory.createSummaryRenderer();
    }

    @Override
    public StudyDefinition getStudyDefinition() {
        return DEF;
    }

    @Override
    public Configurable getConfiguration() {
        return this.mConfig;
    }

    @Override
    public IValueScale createValueScale() {
        EnumSet<ValueScale.ScaleBehavior> opts = EnumSet.noneOf(ValueScale.ScaleBehavior.class);
        opts.add(ValueScale.ScaleBehavior.CrossesZero);
        opts.add(ValueScale.ScaleBehavior.Tight);
        return new ValueScale(opts, this.mConfig.ScaleConfig);
    }

    @Override
    public IChartRenderer getRenderer() {
        this.mTRLineRenderer.updateDataSource(this.mTR.getDataSource(), this.mTR.getDataDefinition().getField("TR")).setColor(this.mConfig.TRLineColor).setWidth(this.mConfig.TRLineWidth).setLineStyle(IChartRenderer.LineStyle.Solid).setHidden(!this.mConfig.DisplayTrueRange);
        this.mATRLineRenderer.updateDataSource(this.mATR, this.mMA.getDataDefinition().getPrimaryField()).setColor(this.mConfig.LineColor).setWidth(this.mConfig.LineWidth).setLineStyle(IChartRenderer.LineStyle.Solid);
        return this.mRenderer;
    }

    @Override
    protected ISummaryRenderer getSummary(NDateTime trackTime) {
        MovingAverage.MAValue dp;
        if (!this.mConfig.SummaryConfig.DisplaySummaries) {
            return null;
        }
        Object summText = this.mConfig.configurableName();
        if (this.mConfig.SummaryConfig.DisplayATRValue && this.mMA != null && (dp = (MovingAverage.MAValue)this.mATR.getNearestTo(trackTime)) != null) {
            summText = (String)summText + " " + String.format("%." + this.mConfig.ScaleConfig.DisplayDecimals + "f", dp.MA);
        }
        this.mSummary.setText((String)summText).setIcon(ISummaryRenderer.SummaryIcon.Line);
        return this.mSummary;
    }

    @Override
    public Range<Double> getValueRange(Range<NDateTime> timeRange) {
        Range<Double> rng = this.mATR.getValueRange(timeRange);
        if (this.mConfig.DisplayTrueRange) {
            Range<Double> trRange = ((DataSeries)this.mTR.getDataSource()).getValueRange(timeRange);
            rng = rng.expanded(trRange);
        }
        return rng;
    }

    @Override
    public Range<NDateTime> getTimeRange() {
        return this.mATR.getTimeRange();
    }

    @Override
    public Integer getPreceedingIntervals() {
        return this.mConfig.Periods;
    }

    @Override
    protected void onUpdateStudy() {
        if (this.mMA == null) {
            this.onRecomputeStudy();
        } else {
            this.mTR.update();
            this.mMA.update();
        }
    }

    @Override
    protected void onRecomputeStudy() {
        this.mTR = new BarTR(this.getBarData());
        this.mMA = new MovingAverage(this.mTR, this.mTR.getDataDefinition().getPrimaryField(), MAType.WilderMA, this.mConfig.Periods, this.mATR);
        this.mTR.reCompute();
        this.mMA.reCompute();
        if (this.mRenderer != null) {
            this.mTRLineRenderer.updateDataSource(this.mTR.getDataSource(), this.mTR.getDataDefinition().getField("TR"));
            this.mATRLineRenderer.updateDataSource(this.mATR, this.mMA.getDataDefinition().getPrimaryField());
        }
    }

    @Override
    protected void onResetStudy() {
        this.mATR.clear();
    }

    @Override
    public DataDefinition getDataDefinition() {
        if (this.mMA != null) {
            return this.mMA.getDataDefinition();
        }
        return null;
    }

    @Override
    public IDataSource getDataSource() {
        return this.mATR;
    }

    @Category(value="chart_atr_study")
    public static class Configuration
    extends StudyConfigurable {
        @PropertyConfig(idx=0, name="ma_pricetype_name", description="ma_pricetype_descr")
        @DefaultValue(value="Closing")
        public MAPriceType PriceType = MAPriceType.Closing;
        @PropertyConfig(idx=1, name="ma_periods_name", description="ma_periods_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10000.0f)
        @DefaultValue(value="14")
        public int Periods = 14;
        @PropertyConfig(idx=5, name="atr_atr_linecolor_name", description="atr_atr_linecolor_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#FF6347")
        @Serialize(value=Serialize.As.Color)
        public int LineColor = ColorUtil.rgb(255, 99, 71);
        @PropertyConfig(idx=6, name="atr_atr_linewidth_name", description="atr_atr_linewidth_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10.0f, increment=1.0f, displayDecimals=0)
        @DefaultValue(value="2")
        public int LineWidth = 2;
        @PropertyConfig(idx=7, name="atr_display_truerange", description="atr_display_truerange_descr", editor=EditorType.Switch)
        @DefaultValue(value="false")
        public boolean DisplayTrueRange = false;
        @PropertyConfig(idx=8, name="atr_tr_linecolor_name", description="atr_tr_linecolor_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#808080")
        @Serialize(value=Serialize.As.Color)
        public int TRLineColor = ColorUtil.rgb(128, 128, 128);
        @PropertyConfig(idx=9, name="atr_tr_linewidth_name", description="atr_tr_linewidth_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10.0f, increment=1.0f, displayDecimals=0)
        @DefaultValue(value="2")
        public int TRLineWidth = 2;
        @IncludeConfig(idx=12)
        @Category(value="chart_value_scale")
        public final ValueScaleConfig ScaleConfig;
        @IncludeConfig(idx=13)
        @Category(value="chart_summaries")
        public final SummaryConfig SummaryConfig = new SummaryConfig();

        public Configuration(String uid) {
            super(uid);
            this.ScaleConfig = new ValueScaleConfig(EnumSet.of(ValueScaleConfig.AllowOptions.DisplayDecimals));
            this.ScaleConfig.DisplayDecimals = 1;
        }

        @Override
        public String configID() {
            return DEF.id();
        }

        @Override
        public String configurableName() {
            return String.format("%s(%d)", Resource.localizeString("chart_atr_study"), this.Periods);
        }

        @Override
        public boolean isEnabled(String propertyName) {
            if (propertyName.equals("TRLineColor") && !this.DisplayTrueRange) {
                return false;
            }
            return !propertyName.equals("TRLineWidth") || this.DisplayTrueRange;
        }
    }

    public static class SummaryConfig
    extends Configurable {
        @PropertyConfig(idx=0, name="chart_display_summaries_name", description="chart_display_summaries_descr", editor=EditorType.Switch)
        @DefaultValue(value="true")
        public boolean DisplaySummaries = true;
        @PropertyConfig(idx=1, name="atr_summary_display_atr_name", description="empty")
        @DefaultValue(value="true")
        public boolean DisplayATRValue = true;

        @Override
        public String configID() {
            return "MACDStudy$SummaryConfig";
        }

        @Override
        public String configurableName() {
            return Resource.localizeString("chart_summaries");
        }

        @Override
        public boolean isEnabled(String propertyName) {
            return !propertyName.equals("DisplayATRValue") || this.DisplaySummaries;
        }
    }
}

