/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.indicators;

import com.t4login.Host;
import com.t4login.Log;
import com.t4login.Resource;
import com.t4login.application.chart.ChartContext;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.IBarDataPoint;
import com.t4login.application.chart.chartdata.IDataPoint;
import com.t4login.application.chart.chartdata.IDataPointValue;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.DataField;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.render.IChartRenderer;
import com.t4login.application.chart.render.IRendererFactory;
import com.t4login.application.chart.render.IStudyLineRenderer;
import com.t4login.application.chart.render.ISummaryRenderer;
import com.t4login.application.chart.scales.IValueScale;
import com.t4login.application.chart.scales.ValueScale;
import com.t4login.application.chart.scales.ValueScaleConfig;
import com.t4login.application.chart.studies.Study;
import com.t4login.application.chart.studies.StudyCategory;
import com.t4login.application.chart.studies.StudyConfigurable;
import com.t4login.application.chart.studies.StudyDefinition;
import com.t4login.application.chart.studies.StudyType;
import com.t4login.application.chart.studies.SupportsPiggyBackMA;
import com.t4login.application.configuration.Category;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.EditorType;
import com.t4login.application.configuration.IncludeConfig;
import com.t4login.application.configuration.NumberFormatF;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.Serialize;
import com.t4login.application.configuration.UserRole;
import com.t4login.datetime.NDateTime;
import com.t4login.util.ColorUtil;
import com.t4login.util.Range;
import java.util.EnumSet;

@StudyDefinition(id="ACC/DIST", nameResId="chart_accdist_study_name", descrResId="chart_accdist_study_descr", category=StudyCategory.MoneyFlow, type=StudyType.Indicator, userRole=UserRole.Basic)
@SupportsPiggyBackMA
public class AccDistStudy
extends Study {
    private static final String TAG = "AccDistStudy";
    private static StudyDefinition DEF = AccDistStudy.class.getAnnotation(StudyDefinition.class);
    private final Configuration mConfig;
    private final IStudyLineRenderer mLineRenderer;
    private final ISummaryRenderer mSummary;
    private DataSeries<AccDistValue> mData = new DataSeries();
    private DataDefinition mDataDef = null;

    public AccDistStudy(ChartContext ccontext) {
        this(ccontext, null);
    }

    @Override
    public String getUID() {
        return this.mConfig.uid;
    }

    public AccDistStudy(ChartContext ccontext, Object config) {
        super(ccontext);
        this.mConfig = config instanceof Configuration ? (Configuration)config : new Configuration("");
        IRendererFactory rendererFactory = Host.getRendererFactory();
        assert (rendererFactory != null);
        this.mLineRenderer = rendererFactory.createStudyLineRenderer();
        this.mSummary = rendererFactory.createSummaryRenderer();
    }

    @Override
    public StudyDefinition getStudyDefinition() {
        return DEF;
    }

    @Override
    public Configurable getConfiguration() {
        return this.mConfig;
    }

    @Override
    public IValueScale createValueScale() {
        EnumSet<ValueScale.ScaleBehavior> opts = EnumSet.noneOf(ValueScale.ScaleBehavior.class);
        return new ValueScale(opts, this.mConfig.ScaleConfig);
    }

    @Override
    public IChartRenderer getRenderer() {
        this.mLineRenderer.updateDataSource(this.mData, this.getDataDefinition().getPrimaryField()).setColor(this.mConfig.LineColor).setWidth(this.mConfig.LineWidth).setLineStyle(IChartRenderer.LineStyle.Solid);
        return this.mLineRenderer;
    }

    @Override
    protected ISummaryRenderer getSummary(NDateTime trackTime) {
        if (!this.mConfig.SummaryConfig.DisplaySummary) {
            return null;
        }
        String summText = this.mConfig.configurableName();
        this.mSummary.setText(summText).setIcon(ISummaryRenderer.SummaryIcon.Line);
        return this.mSummary;
    }

    @Override
    public Range<Double> getValueRange(Range<NDateTime> timeRange) {
        Range<Double> rng = this.mData.getValueRange(timeRange);
        return rng;
    }

    @Override
    public Range<NDateTime> getTimeRange() {
        return this.mData.getTimeRange();
    }

    @Override
    public Integer getPreceedingIntervals() {
        return 0;
    }

    @Override
    protected void onUpdateStudy() {
        if (this.mData.getCount() == 0) {
            this.compute(null);
        } else {
            AccDistValue startpt = null;
            BarDataSeries ser = this.getBarData();
            IBarDataPoint basept = ser.baseDataPoint;
            if (basept != null) {
                AccDistValue lastpt = (AccDistValue)this.mData.getLast();
                while (lastpt != null && lastpt.Time.compareTo(basept.getTime()) > 0) {
                    this.mData.removeDataPoint(lastpt);
                }
                startpt = lastpt = (AccDistValue)this.mData.getLast();
            }
            if (startpt == null) {
                startpt = (AccDistValue)this.mData.getLast();
            }
            this.compute(startpt);
        }
    }

    @Override
    protected void onRecomputeStudy() {
        this.mData.clear();
        this.compute(null);
        if (this.mLineRenderer != null) {
            this.mLineRenderer.updateDataSource(this.mData, this.getDataDefinition().getPrimaryField());
        }
    }

    @Override
    protected void onResetStudy() {
        this.mData.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compute(AccDistValue startpt) {
        int startidx = 0;
        double accdist = 0.0;
        BarDataSeries series = this.getBarData();
        if (startpt != null) {
            startidx = startpt.DataIndex;
            accdist = startpt.PrevAccDist;
        }
        this.mData.beginUpdate();
        try {
            for (int i = startidx; i < series.getCount(); ++i) {
                IBarDataPoint bar = series.get(i);
                double close = bar.getClose();
                double high = bar.getHigh();
                double low = bar.getLow();
                int volume = bar.getVolume();
                double clv = 0.0;
                if (high != low) {
                    clv = (close - low - (high - close)) / (high - low);
                }
                double mov = clv * (double)volume;
                double prevval = accdist;
                this.mData.addDataPoint(new AccDistValue(bar.getTime(), accdist += mov, prevval, i));
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeStudy(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    @Override
    public DataDefinition getDataDefinition() {
        if (this.mDataDef == null) {
            this.mDataDef = new DataDefinition("Acc/Dist");
            this.mDataDef.addField(new DataField("ACC/DIST", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof AccDistValue) {
                        AccDistValue trdp = (AccDistValue)dp;
                        return trdp.AccDist;
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(this){

                @Override
                public String getFormattedValue(double value) {
                    return Double.toString(value);
                }
            }, true, false));
        }
        return this.mDataDef;
    }

    @Override
    public IDataSource getDataSource() {
        return this.mData;
    }

    @Category(value="chart_accdist_study")
    public static class Configuration
    extends StudyConfigurable {
        @PropertyConfig(idx=0, name="linecolor_name", description="linecolor_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#008000")
        @Serialize(value=Serialize.As.Color)
        public int LineColor = ColorUtil.rgb(0, 128, 0);
        @PropertyConfig(idx=1, name="linewidth_name", description="linewidth_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10.0f, increment=1.0f, displayDecimals=0)
        @DefaultValue(value="2")
        public int LineWidth = 2;
        public final ValueScaleConfig ScaleConfig;
        @IncludeConfig(idx=3)
        @Category(value="chart_summaries")
        public final SummaryConfig SummaryConfig = new SummaryConfig();

        public Configuration(String uid) {
            super(uid);
            this.ScaleConfig = new ValueScaleConfig(EnumSet.noneOf(ValueScaleConfig.AllowOptions.class));
            this.ScaleConfig.RenderScale = false;
        }

        @Override
        public String configID() {
            return DEF.id();
        }

        @Override
        public String configurableName() {
            return Resource.localizeString("chart_accdist_study");
        }
    }

    public static class SummaryConfig
    extends Configurable {
        @PropertyConfig(idx=0, name="chart_display_summary_name", description="chart_display_summary_descr", editor=EditorType.Switch)
        @DefaultValue(value="true")
        public boolean DisplaySummary = true;

        @Override
        public String configID() {
            return "AccumDistStudy$SummaryConfig";
        }

        @Override
        public String configurableName() {
            return Resource.localizeString("chart_summaries");
        }

        @Override
        public boolean isEnabled(String propertyName) {
            return true;
        }
    }

    public static class AccDistValue
    implements IDataPointValue {
        public final NDateTime Time;
        public final double AccDist;
        public final double PrevAccDist;
        public final int DataIndex;

        public AccDistValue(NDateTime time, double accdist, double prevaccdist, int idx) {
            this.Time = time;
            this.AccDist = accdist;
            this.PrevAccDist = prevaccdist;
            this.DataIndex = idx;
        }

        @Override
        public double getValue() {
            return this.AccDist;
        }

        @Override
        public NDateTime getTime() {
            return this.Time;
        }
    }
}

