/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.computations.pivscript;

import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.IBarDataPoint;
import com.t4login.application.chart.chartdata.SettlementDataPoint;
import com.t4login.application.chart.studies.computations.pivscript.PPFunc;
import com.t4login.datetime.NDateTime;

public class PPContext {
    public final BarDataSeries Series;
    public IBarDataPoint CurrentBar;
    public PPFunc R4;
    public PPFunc R3;
    public PPFunc R2;
    public PPFunc R1;
    public PPFunc PP;
    public PPFunc S1;
    public PPFunc S2;
    public PPFunc S3;
    public PPFunc S4;

    public PPContext(BarDataSeries series) {
        this.Series = series;
    }

    public double getOpen() {
        return this.CurrentBar.getOpen();
    }

    public double getHigh() {
        return this.CurrentBar.getHigh();
    }

    public double getLow() {
        return this.CurrentBar.getLow();
    }

    public double getClose() {
        return this.CurrentBar.getClose();
    }

    public double getRange() {
        return this.CurrentBar.getHigh() - this.CurrentBar.getLow();
    }

    public double getSettlement() {
        return ((SettlementDataPoint)this.Series.getSettlementData().getPreceeding((NDateTime)this.CurrentBar.getTime())).SettlementPrice.getDoubleValue();
    }

    public Double getOpen(int offset) {
        int idx = this.Series.getIndexOf(this.CurrentBar);
        IBarDataPoint bar = this.Series.get(idx + offset);
        if (bar != null) {
            return bar.getOpen();
        }
        return null;
    }

    public Double getHigh(int offset) {
        int idx = this.Series.getIndexOf(this.CurrentBar);
        IBarDataPoint bar = this.Series.get(idx + offset);
        if (bar != null) {
            return bar.getHigh();
        }
        return null;
    }

    public Double getLow(int offset) {
        int idx = this.Series.getIndexOf(this.CurrentBar);
        IBarDataPoint bar = this.Series.get(idx + offset);
        if (bar != null) {
            return bar.getLow();
        }
        return null;
    }

    public Double getClose(int offset) {
        int idx = this.Series.getIndexOf(this.CurrentBar);
        IBarDataPoint bar = this.Series.get(idx + offset);
        if (bar != null) {
            return bar.getClose();
        }
        return null;
    }

    public Double getRange(int offset) {
        int idx = this.Series.getIndexOf(this.CurrentBar);
        IBarDataPoint bar = this.Series.get(idx + offset);
        if (bar != null) {
            return bar.getHigh() - bar.getLow();
        }
        return null;
    }

    public void reset() {
    }
}

